/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.InjectionKey;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.Scope;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FrameDependentConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PendingTypeConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.op.Construct_0;
import org.xvm.asm.op.Nop;
import org.xvm.asm.op.Var_DN;
import org.xvm.compiler.ast.AstNode;
import org.xvm.runtime.Container;
import org.xvm.runtime.Fiber;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Auto;
import org.xvm.util.Handy;
import org.xvm.util.LinkedIterator;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class MethodStructure
extends Component {
    private Annotation[] m_aAnnotations;
    private MethodConstant m_idFinally;
    private Parameter[] m_aReturns;
    private int m_cTypeParams;
    private int m_cDefaultParams;
    private Parameter[] m_aParams;
    private MethodConstant m_idSuper;
    private Constant[] m_aconstSuper;
    private byte[] m_abOps;
    private byte[] m_abAst;
    Constant[] m_aconstLocal;
    transient Op.ConstantRegistry m_registry;
    private transient Code m_code;
    private transient BinaryAST m_ast;
    private transient RegisterAST[] m_aAstParams;
    transient int m_cVars;
    transient int m_cScopes;
    private transient boolean m_fNative;
    private transient boolean m_fTransient;
    private transient Boolean m_FHasCode;
    private transient Boolean m_FUsesSuper;
    private transient ConcurrencySafety m_safety;
    private transient boolean m_fInitialized;
    private transient MethodStructure m_structFinally;
    private transient int m_nNextUnassignedIndex;
    private Source m_source;

    protected MethodStructure(XvmStructure xsParent, int nFlags, MethodConstant constId, ConditionalConstant condition) {
        super(xsParent, nFlags, constId, condition);
    }

    protected MethodStructure(XvmStructure xsParent, int nFlags, MethodConstant constId, ConditionalConstant condition, Annotation[] annotations, Parameter[] aReturns, Parameter[] aParams, boolean fHasCode, boolean fUsesSuper) {
        this(xsParent, nFlags, constId, condition);
        this.m_aAnnotations = annotations;
        this.m_aReturns = aReturns;
        this.m_aParams = aParams;
        if (aReturns.length > 0 && aReturns[0].isConditionalReturn()) {
            this.setConditionalReturn(true);
        }
        int cTypeParams = 0;
        int cDefaultParams = 0;
        for (Parameter param : aParams) {
            if (param.isTypeParameter()) {
                ++cTypeParams;
                continue;
            }
            if (param.hasDefaultValue()) {
                ++cDefaultParams;
                continue;
            }
            cDefaultParams = 0;
        }
        this.m_cTypeParams = cTypeParams;
        this.m_cDefaultParams = cDefaultParams;
        this.m_FHasCode = fHasCode;
        this.m_FUsesSuper = fUsesSuper;
    }

    public boolean isFunction() {
        return this.isStatic() && !this.isConstructor();
    }

    public boolean isConstructor() {
        String sName = this.getName();
        return "construct".equals(sName) || "=".equals(sName);
    }

    public boolean isVirtualConstructor() {
        return "construct".equals(this.getName()) && this.getParent().getParent().getFormat() == Component.Format.INTERFACE;
    }

    public boolean isShorthandConstructor() {
        return this.isAuxiliary();
    }

    public void markAsShorthand() {
        assert (this.isConstructor());
        this.markAuxiliary();
    }

    public boolean isConstructorFinalizer() {
        boolean fFinalizer = "finally".equals(this.getName());
        assert (!fFinalizer || !this.isFunction());
        return fFinalizer;
    }

    public boolean isPropertyInitializer() {
        return "=".equals(this.getName()) && this.getParent().getParent() instanceof PropertyStructure;
    }

    public boolean isAnonymousClassWrapperConstructor() {
        return this.isConstructor() && this.isSynthetic() && this.getParent().getParent().isSynthetic();
    }

    public boolean isValidator() {
        return "assert".equals(this.getName());
    }

    public int getAnnotationCount() {
        return this.m_aAnnotations == null ? 0 : this.m_aAnnotations.length;
    }

    public Annotation getAnnotation(int i) {
        return i < 0 || i >= this.getAnnotationCount() ? null : this.m_aAnnotations[i];
    }

    public Annotation[] getAnnotations() {
        return this.m_aAnnotations;
    }

    public void reorderAnnotations(Annotation[] annotations) {
        assert (new HashSet<Annotation>(Arrays.asList(annotations)).equals(new HashSet<Annotation>(Arrays.asList(this.m_aAnnotations))));
        this.m_aAnnotations = annotations;
    }

    public Annotation findAnnotation(ClassConstant clzClass) {
        for (Annotation annotation : this.m_aAnnotations) {
            if (!annotation.getAnnotationClass().equals(clzClass)) continue;
            return annotation;
        }
        return null;
    }

    public boolean resolveAnnotations() {
        boolean fVoid = this.getReturnCount() == 0;
        int cMove = 0;
        for (Annotation annotation : this.m_aAnnotations) {
            if (annotation.getAnnotationClass().containsUnresolved()) {
                return false;
            }
            TypeConstant typeAnno = annotation.getAnnotationType();
            if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
                return true;
            }
            TypeConstant typeInto = typeAnno.getExplicitClassInto();
            if (typeInto.containsUnresolved()) {
                return false;
            }
            if (fVoid || typeInto.isIntoMethodType()) continue;
            ++cMove;
        }
        boolean fRebuildId = false;
        for (Parameter parameter : this.m_aParams) {
            TypeConstant typeOld = parameter.getType();
            if (!parameter.resolveAnnotations()) {
                return false;
            }
            if (typeOld.equals(parameter.getType())) continue;
            fRebuildId = true;
        }
        if (cMove == 0) {
            if (fRebuildId) {
                this.rebuildIdentityConstant();
            }
            return true;
        }
        Annotation[] aAll = this.m_aAnnotations;
        int cAll = aAll.length;
        if (cMove == cAll) {
            this.addReturnAnnotations(aAll);
            this.m_aAnnotations = Annotation.NO_ANNOTATIONS;
            return true;
        }
        int cKeep = cAll - cMove;
        Annotation[] aKeep = new Annotation[cKeep];
        Annotation[] aMove = new Annotation[cMove];
        int iKeep = 0;
        int iMove = 0;
        for (Annotation annotation : this.m_aAnnotations) {
            if (annotation.getAnnotationType().getExplicitClassInto().isIntoMethodType()) {
                aKeep[iKeep++] = annotation;
                continue;
            }
            aMove[iMove++] = annotation;
        }
        this.addReturnAnnotations(aMove);
        this.m_aAnnotations = aKeep;
        return true;
    }

    private void addReturnAnnotations(Annotation[] annotations) {
        assert (this.m_aReturns != null);
        assert (this.m_aReturns.length > 0);
        int iRet = 0;
        Parameter ret = this.m_aReturns[iRet];
        if (ret.isConditionalReturn()) {
            ret = this.m_aReturns[++iRet];
        }
        assert (!ret.isConditionalReturn());
        assert (iRet == ret.getIndex());
        ConstantPool pool = this.getConstantPool();
        TypeConstant type = annotations.length == 0 ? ret.getType() : pool.ensureAnnotatedTypeConstant(ret.getType(), annotations);
        this.m_aReturns[iRet] = new Parameter(pool, type, ret.getName(), ret.getDefaultValue(), true, iRet, false);
        this.rebuildIdentityConstant();
    }

    private void rebuildIdentityConstant() {
        ConstantPool pool = this.getConstantPool();
        MethodConstant idOld = this.getIdentityConstant();
        MethodConstant idNew = pool.ensureMethodConstant(idOld.getParentConstant(), idOld.getName(), this.getParamTypes(), this.getReturnTypes());
        this.replaceThisIdentityConstant(idNew);
    }

    public boolean resolveTypedefs() {
        MethodConstant idOld = this.getIdentityConstant();
        if (((IdentityConstant)idOld).containsUnresolved()) {
            return false;
        }
        IdentityConstant idNew = (IdentityConstant)((Constant)idOld).resolveTypedefs();
        if (idNew != idOld) {
            this.replaceThisIdentityConstant(idNew);
        }
        return true;
    }

    public void configureLambda(Parameter[] aParams, int cFormal, Parameter[] aReturns) {
        assert (this.getIdentityConstant().isLambda() && this.getIdentityConstant().isNascent());
        this.m_aParams = aParams;
        this.m_cTypeParams = cFormal;
        this.m_aReturns = aReturns;
    }

    public int getReturnCount() {
        return this.m_aReturns.length;
    }

    public Parameter getReturn(int i) {
        return this.m_aReturns[i];
    }

    public List<Parameter> getReturns() {
        return Arrays.asList(this.m_aReturns);
    }

    public Parameter[] getReturnArray() {
        return this.m_aReturns;
    }

    public TypeConstant[] getReturnTypes() {
        return MethodStructure.toTypeArray(this.m_aReturns);
    }

    public int getParamCount() {
        return this.m_aParams.length;
    }

    public int getTypeParamCount() {
        return this.m_cTypeParams;
    }

    public int getVisibleParamCount() {
        return this.getParamCount() - this.getTypeParamCount();
    }

    public int getDefaultParamCount() {
        return this.m_cDefaultParams;
    }

    public int getRequiredParamCount() {
        return this.getVisibleParamCount() - this.getDefaultParamCount();
    }

    public Parameter getParam(int i) {
        return this.m_aParams[i];
    }

    public Parameter getParam(String sName) {
        Parameter[] aParam;
        for (Parameter param : aParam = this.m_aParams) {
            if (!param.getName().equals(sName)) continue;
            return param;
        }
        return null;
    }

    public boolean isTypeParameter(int i) {
        return 0 <= i && i < this.m_cTypeParams;
    }

    public List<Parameter> getParams() {
        return Arrays.asList(this.m_aParams);
    }

    public Parameter[] getParamArray() {
        return this.m_aParams;
    }

    public TypeConstant[] getParamTypes() {
        return MethodStructure.toTypeArray(this.m_aParams);
    }

    private static TypeConstant[] toTypeArray(Parameter[] aParam) {
        int cParam = aParam.length;
        TypeConstant[] aType = new TypeConstant[cParam];
        for (int i = 0; i < cParam; ++i) {
            aType[i] = aParam[i].getType();
        }
        return aType;
    }

    public Code ensureCode() {
        if (this.isNative() || !this.hasCode()) {
            return null;
        }
        Code code = this.m_code;
        if (code == null) {
            this.m_code = code = new Code(this);
        }
        return code;
    }

    public Code createCode() {
        Code code;
        this.resetRuntimeInfo();
        this.m_fNative = false;
        this.m_aconstLocal = null;
        this.m_abOps = null;
        this.m_abAst = null;
        this.m_ast = null;
        this.m_code = code = new Code(this);
        this.markModified();
        return code;
    }

    public boolean hasOps() {
        return this.ensureCode().hasOps();
    }

    public Op[] getOps() {
        Code code = this.ensureCode();
        if (code == null) {
            throw new IllegalStateException("Method \"" + this.getIdentityConstant().getPathString() + "\" has not been compiled");
        }
        return code.getAssembledOps();
    }

    public BinaryAST getAst() {
        BinaryAST ast = this.m_ast;
        if (ast != null) {
            return ast;
        }
        byte[] abAst = this.m_abAst;
        if (abAst != null) {
            ConstantPool pool = this.getConstantPool();
            Constant[] aconstLocal = this.m_aconstLocal;
            assert (aconstLocal != null);
            Op.ConstantRegistry res = new Op.ConstantRegistry(this, pool);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(abAst));
            Auto ignore = ConstantPool.withPool(pool);
            try {
                this.m_ast = BinaryAST.readAST(in, res);
                Object n = this.m_ast;
                if (ignore != null) {
                    ignore.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public void setAst(BinaryAST astRoot, RegisterAST[] aAstParams) {
        if (astRoot != this.m_ast || aAstParams != this.m_aAstParams) {
            this.m_ast = astRoot;
            this.m_aAstParams = aAstParams;
            this.m_abAst = null;
        }
    }

    public Constant[] getLocalConstants() {
        return this.m_aconstLocal;
    }

    public String getSourceText() {
        return this.m_source == null ? null : this.m_source.getText();
    }

    public int getSourceLineNumber() {
        return this.m_source == null ? 0 : this.m_source.getLineNumber();
    }

    public int getSourceLineCount() {
        return this.m_source == null ? 0 : this.m_source.getLineCount();
    }

    public void configureSource(String sSrc, int iFirstLine) {
        this.m_source = sSrc == null ? null : new Source(iFirstLine, sSrc);
    }

    public String[] getSourceLines(int iFirst, int cLines, boolean fTrim) {
        return this.m_source == null ? null : this.m_source.renderLines(iFirst, cLines, fTrim);
    }

    public List<String> collectUnresolvedTypeParameters(Set<String> setResolved) {
        int cTypeParams = this.getTypeParamCount();
        ArrayList<String> listUnresolved = new ArrayList<String>(cTypeParams);
        for (int iT = 0; iT < cTypeParams; ++iT) {
            String sName = this.getParam(iT).getName();
            if (setResolved.contains(sName)) continue;
            listUnresolved.add(sName);
        }
        return listUnresolved;
    }

    private static boolean checkConflict(TypeConstant typeResult, FormalConstant constFormal, boolean fParam, Map<FormalConstant, TypeConstant> mapTypeParams) {
        if (typeResult != null) {
            TypeConstant typePrev;
            TypeInfo info = typeResult.ensureTypeInfo(ErrorListener.BLACKHOLE);
            if (info.getFormat() == Component.Format.ENUMVALUE) {
                typeResult = info.getExtends();
            }
            if ((typePrev = mapTypeParams.get(constFormal)) != null) {
                if (fParam ? typeResult.isA(typePrev) : typePrev.isA(typeResult)) {
                    return false;
                }
                if (!(!fParam ? typeResult.isA(typePrev) : typePrev.isA(typeResult)) && (typeResult = Op.selectCommonType(typePrev, typeResult, ErrorListener.BLACKHOLE)) == null) {
                    mapTypeParams.remove(constFormal);
                    return true;
                }
            }
            mapTypeParams.put(constFormal, typeResult);
        }
        return false;
    }

    public int getThisSteps() {
        int cSteps = 0;
        Component parent = this.getParent().getParent();
        while (!(parent instanceof ClassStructure)) {
            PropertyStructure prop;
            if (parent instanceof PropertyStructure && (prop = (PropertyStructure)parent).isRefAnnotated()) {
                ++cSteps;
            }
            parent = parent.getParent();
        }
        return cSteps;
    }

    public ListMap<FormalConstant, TypeConstant> resolveTypeParameters(ConstantPool pool, TypeConstant typeTarget, TypeConstant[] atypeArgs, TypeConstant[] atypeReturns, boolean fAllowPending) {
        int cReturns;
        int cTypeParams = this.getTypeParamCount();
        ListMap<FormalConstant, TypeConstant> mapTypeParams = new ListMap<FormalConstant, TypeConstant>(cTypeParams);
        TypeConstant[] atypeMethodParams = this.getParamTypes();
        TypeConstant[] atypeMethodReturns = this.getReturnTypes();
        int cMethodParams = atypeMethodParams.length - cTypeParams;
        int cMethodReturns = atypeMethodReturns.length;
        int cArgs = atypeArgs == null ? 0 : atypeArgs.length;
        int n = cReturns = atypeReturns == null ? 0 : atypeReturns.length;
        assert (cArgs <= cMethodParams && cReturns <= cMethodReturns);
        HashMap<String, TypeConstant> mapTypeGeneric = new HashMap<String, TypeConstant>();
        HashSet<TypeParameterConstant> setPending = new HashSet<TypeParameterConstant>();
        block0: for (int iT = 0; iT < cTypeParams; ++iT) {
            TypeConstant typeResolved;
            TypeConstant typeFormal;
            TypeConstant typeActual;
            Parameter param = this.getParam(iT);
            String sName = param.getName();
            TypeParameterConstant constParam = param.asTypeParameterConstant(this.getIdentityConstant());
            for (int iA = 0; iA < cArgs; ++iA) {
                typeActual = atypeArgs[iA];
                if (typeActual == null) continue;
                typeFormal = atypeMethodParams[cTypeParams + iA];
                typeResolved = typeFormal.resolveTypeParameter(typeActual, sName);
                if (typeResolved != null && !typeResolved.containsUnresolved() && MethodStructure.checkConflict(typeResolved, constParam, true, mapTypeParams)) continue block0;
                this.resolveGenericTypes(pool, typeFormal, typeActual, mapTypeGeneric);
            }
            for (int iR = 0; iR < cMethodReturns; ++iR) {
                TypeConstant typeConstant = typeActual = iR < cReturns ? atypeReturns[iR] : null;
                if (typeActual == null) continue;
                typeFormal = atypeMethodReturns[iR];
                typeResolved = typeFormal.resolveTypeParameter(typeActual, sName);
                if (typeResolved != null && !typeResolved.containsUnresolved() && MethodStructure.checkConflict(typeResolved, constParam, false, mapTypeParams)) continue block0;
                this.resolveGenericTypes(pool, typeFormal, typeActual, mapTypeGeneric);
            }
            if (mapTypeParams.containsKey(constParam)) {
                if (setPending.isEmpty()) continue;
                TypeConstant typeActual2 = mapTypeParams.get(constParam);
                TypeConstant typeFormal2 = atypeMethodParams[iT].getParamType(0);
                Iterator iter = setPending.iterator();
                while (iter.hasNext()) {
                    TypeParameterConstant constPending = (TypeParameterConstant)iter.next();
                    TypeConstant typeResolved2 = typeFormal2.resolveTypeParameter(typeActual2, constPending.getName());
                    if (typeResolved2 == null) continue;
                    mapTypeParams.put(constPending, typeResolved2);
                    iter.remove();
                }
                continue;
            }
            setPending.add(constParam);
            TypeConstant typeParam = param.getType();
            if (typeTarget != null) {
                typeParam = typeParam.resolveGenerics(pool, typeTarget);
            }
            if (!mapTypeGeneric.isEmpty()) {
                typeParam = typeParam.resolveGenerics(pool, mapTypeGeneric::get);
            }
            if (!mapTypeParams.isEmpty()) {
                typeParam = typeParam.resolveGenerics(pool, GenericTypeResolver.of(mapTypeParams));
            }
            TypeConstant typeConstraint = typeParam.getParamType(0);
            if (fAllowPending) {
                PendingTypeConstant typePending = new PendingTypeConstant(pool, typeConstraint);
                mapTypeParams.put(constParam, typePending);
                continue;
            }
            mapTypeParams.put(constParam, typeConstraint);
        }
        return mapTypeParams;
    }

    private void resolveGenericTypes(ConstantPool pool, TypeConstant typeFormal, TypeConstant typeActual, Map<String, TypeConstant> mapTypeGeneric) {
        ClassStructure clzParent = this.getContainingClass();
        if (clzParent.isParameterized()) {
            for (Map.Entry<StringConstant, TypeConstant> entry : clzParent.getTypeParams().entrySet()) {
                String sName = entry.getKey().getValue();
                TypeConstant typeResolved = typeFormal.resolveTypeParameter(typeActual, sName);
                if (typeResolved == null) {
                    mapTypeGeneric.computeIfAbsent(sName, s -> ((TypeConstant)entry.getValue()).resolveGenerics(pool, mapTypeGeneric::get));
                    continue;
                }
                mapTypeGeneric.merge(sName, typeResolved, (typeOld, typeNew) -> typeOld == null || typeNew.isA((TypeConstant)typeOld) ? typeNew : typeOld);
            }
        }
    }

    Scope createInitialScope() {
        Scope scope = new Scope();
        int c = this.getParamCount();
        for (int i = 0; i < c; ++i) {
            scope.allocVar();
        }
        return scope;
    }

    public void ensureRuntimeInfo() {
        if (this.m_cScopes == 0) {
            Code code = this.ensureCode();
            if (code == null) {
                Scope scope = this.createInitialScope();
                this.m_cVars = scope.getMaxVars();
                this.m_cScopes = scope.getMaxDepth();
            } else if (this.needsReassembly()) {
                this.forceAssembly(this.getConstantPool());
                assert (this.m_cScopes > 0);
            }
        }
    }

    public void resetRuntimeInfo() {
        this.m_code = null;
        this.m_cVars = 0;
        this.m_cScopes = 0;
        this.m_fNative = false;
    }

    boolean needsReassembly() {
        return this.m_code != null && this.m_abOps == null || this.m_ast != null && this.m_abAst == null;
    }

    public void forceAssembly(ConstantPool pool) {
        if (this.needsReassembly()) {
            if (this.m_abOps != null) {
                this.ensureCode();
            }
            if (this.m_abAst != null) {
                this.getAst();
            }
        }
        Code code = this.m_code;
        BinaryAST ast = this.m_ast;
        if (code != null || ast != null) {
            Op.ConstantRegistry registry;
            this.m_abOps = null;
            this.m_abAst = null;
            this.m_registry = registry = new Op.ConstantRegistry(this, pool);
            if (code != null) {
                code.prepareOps();
                code.registerConstants(registry);
            }
            if (ast != null) {
                registry.init(this.m_aAstParams);
                ast.prepareWrite(registry);
            }
            this.m_aconstLocal = this.m_registry.getConstantArray();
            if (code != null) {
                code.ensureAssembled(registry);
            }
            if (ast != null) {
                try {
                    ByteArrayOutputStream collectAst = new ByteArrayOutputStream();
                    ast.write(new DataOutputStream(collectAst), registry);
                    this.m_abAst = collectAst.toByteArray();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.m_registry = null;
            assert (this.m_code == null == (this.m_abOps == null));
            assert (this.m_ast == null == (this.m_abAst == null));
        }
    }

    public int getMaxVars() {
        this.ensureRuntimeInfo();
        return this.m_cVars;
    }

    public int getMaxScopes() {
        this.ensureRuntimeInfo();
        return this.m_cScopes;
    }

    @Override
    public void setAbstract(boolean fAbstract) {
        if (fAbstract) {
            this.m_aconstLocal = null;
            this.m_abOps = null;
            this.m_abAst = null;
            this.m_code = null;
            this.m_ast = null;
            this.m_fNative = false;
        }
        super.setAbstract(fAbstract);
    }

    public boolean isNative() {
        return this.m_fNative;
    }

    public void markNative() {
        this.setAbstract(false);
        this.resetRuntimeInfo();
        this.m_fNative = true;
        this.m_fTransient = true;
    }

    public boolean isTransient() {
        return this.m_fTransient;
    }

    public void markTransient() {
        this.m_fTransient = true;
    }

    public boolean isPotentialInitializer() {
        return "=".equals(this.getName()) && this.getReturnCount() == 1 && this.getParamCount() == 0 && this.isConstructor() && !this.isConditionalReturn();
    }

    public boolean isLambda() {
        return this.getIdentityConstant().isLambda();
    }

    public boolean isInitializer(TypeConstant type, GenericTypeResolver resolver) {
        ConstantPool pool = this.getConstantPool();
        return this.isPotentialInitializer() && (this.getReturn(0).getType().equals(type) || resolver != null && this.getReturn(0).getType().resolveGenerics(pool, resolver).equals(type.resolveGenerics(pool, resolver)));
    }

    public boolean isPotentialGetter() {
        return "get".equals(this.getName()) && this.getAccess() == Constants.Access.PUBLIC && this.getReturnCount() >= 1 && !this.isFunction() && !this.isConditionalReturn();
    }

    public boolean isGetter(TypeConstant type, GenericTypeResolver resolver) {
        ConstantPool pool = this.getConstantPool();
        return this.isPotentialGetter() && (this.getReturn(0).getType().equals(type) || resolver != null && this.getReturn(0).getType().resolveGenerics(pool, resolver).isA(type.resolveGenerics(pool, resolver)));
    }

    public boolean isPotentialSetter() {
        return "set".equals(this.getName()) && this.getAccess() == Constants.Access.PUBLIC && this.getParamCount() >= 1 && !this.isFunction() && !this.isConditionalReturn();
    }

    public boolean isSetter(TypeConstant type, GenericTypeResolver resolver) {
        ConstantPool pool = this.getConstantPool();
        return this.isPotentialSetter() && (this.getParam(0).getType().equals(type) || resolver != null && this.getParam(0).getType().resolveGenerics(pool, resolver).isA(type.resolveGenerics(pool, resolver)));
    }

    public MethodStructure getConstructFinally() {
        assert (this.isConstructor());
        MethodStructure structFinally = this.m_structFinally;
        if (structFinally == null) {
            if (this.m_idFinally == null) {
                return null;
            }
            this.m_structFinally = structFinally = (MethodStructure)this.m_idFinally.getComponent();
        }
        return structFinally;
    }

    public void setConstructFinally(MethodStructure structFinally) {
        assert (this.isConstructor());
        this.m_structFinally = structFinally;
        this.m_idFinally = structFinally.getIdentityConstant();
    }

    public boolean hasCode() {
        if (this.m_FHasCode != null) {
            return this.m_FHasCode;
        }
        return this.m_code != null && this.m_code.hasOps();
    }

    public boolean isSuperAllowed() {
        return this.findAnnotation(this.getConstantPool().clzOverride()) != null || this.isPotentialGetter() || this.isPotentialSetter();
    }

    public boolean usesSuper() {
        if (this.m_FUsesSuper != null) {
            return this.m_FUsesSuper;
        }
        Code code = this.ensureCode();
        if (code == null) {
            return false;
        }
        this.m_FUsesSuper = code.usesSuper();
        return this.m_FUsesSuper;
    }

    public boolean isNoOp() {
        if (this.isNative()) {
            return false;
        }
        if (!this.hasCode()) {
            return true;
        }
        return this.ensureCode().isNoOp() && (!this.isConstructor() || this.getConstructFinally() == null);
    }

    public boolean isAccessible(Constants.Access access) {
        return this.getAccess().ordinal() <= access.ordinal();
    }

    public boolean producesFormalType(String sTypeName) {
        for (Parameter param : this.getParams()) {
            if (!param.getType().consumesFormalType(sTypeName, Constants.Access.PUBLIC)) continue;
            return true;
        }
        for (Parameter param : this.getReturns()) {
            if (!param.getType().producesFormalType(sTypeName, Constants.Access.PUBLIC)) continue;
            return true;
        }
        return false;
    }

    public boolean consumesFormalType(String sTypeName) {
        for (Parameter param : this.getParams()) {
            if (!param.getType().producesFormalType(sTypeName, Constants.Access.PUBLIC)) continue;
            return true;
        }
        for (Parameter param : this.getReturns()) {
            if (!param.getType().consumesFormalType(sTypeName, Constants.Access.PUBLIC)) continue;
            return true;
        }
        return false;
    }

    public int ensureInitialized(Frame frame, Frame frameNext) {
        return this.m_fInitialized ? frame.call(frameNext) : this.initialize(frame, frameNext);
    }

    private int initialize(Frame frame, Frame frameNext) {
        Constant[] aconstLocal = this.getLocalConstants();
        if (aconstLocal != null && aconstLocal.length > 0) {
            List<SingletonConstant> listSingletons = null;
            for (Constant constant : aconstLocal) {
                listSingletons = this.addSingleton(frame, constant, listSingletons);
            }
            if (listSingletons != null) {
                Fiber fiber = frame.f_fiber;
                long ldtTimeout = fiber.getTimeoutStamp();
                ObjectHandle hTimeout = fiber.getTimeoutHandle();
                if (ldtTimeout > 0L) {
                    fiber.clearTimeout();
                }
                return Utils.initConstants(frame, listSingletons, frameCaller -> {
                    if (ldtTimeout > 0L) {
                        fiber.setTimeoutHandle(hTimeout, ldtTimeout);
                    }
                    this.m_fInitialized = true;
                    return frameCaller.call(frameNext);
                });
            }
        }
        this.m_fInitialized = true;
        return frame.call(frameNext);
    }

    private List<SingletonConstant> addSingleton(Frame frame, Constant constant, List<SingletonConstant> list) {
        if (constant instanceof SingletonConstant) {
            SingletonConstant constSingle = (SingletonConstant)constant;
            if (list == null) {
                list = new ArrayList<SingletonConstant>(7);
            }
            ConstantPool pooThis = frame.poolContext();
            if (constant.getConstantPool() != pooThis) {
                Container containerThis = frame.f_context.f_container;
                Container containerOrig = containerThis.getOriginContainer(constSingle);
                constSingle = (SingletonConstant)containerOrig.getConstantPool().register(constSingle);
            }
            list.add(constSingle);
        } else if (constant instanceof ArrayConstant) {
            ArrayConstant constArray = (ArrayConstant)constant;
            for (Constant constElement : constArray.getValue()) {
                list = this.addSingleton(frame, constElement, list);
            }
        }
        return list;
    }

    public int calculateLineNumber(int iPC) {
        Code code = this.m_code;
        if (code == null) {
            return 0;
        }
        Op[] aOp = code.m_aop;
        if (aOp == null || iPC >= aOp.length) {
            return 0;
        }
        int nLine = 1;
        for (int i = 0; i <= iPC; ++i) {
            Op op = aOp[i].ensureOp();
            if (!(op instanceof Nop)) continue;
            Nop nop = (Nop)op;
            nLine += nop.getLineCount();
        }
        return nLine == 1 ? 0 : nLine;
    }

    public void setShorthandInitialization(MethodConstant idSuper, Constant[] aconstSuper) {
        assert (this.isShorthandConstructor());
        this.m_idSuper = idSuper;
        this.m_aconstSuper = aconstSuper == null ? Constant.NO_CONSTS : aconstSuper;
    }

    public void collectDefaultParams(Constant[] aconstArgs, Map<String, Constant> mapValues) {
        if (this.m_idSuper != null) {
            MethodStructure ctorSuper = (MethodStructure)this.m_idSuper.getComponent();
            ctorSuper.collectDefaultParams(this.m_aconstSuper, mapValues);
        }
        int cArgs = aconstArgs.length;
        int c = this.getParamCount();
        for (int i = 0; i < c; ++i) {
            Constant constArg;
            Parameter param = this.getParam(i);
            if (i < cArgs && (constArg = aconstArgs[i]) != null) {
                if (constArg instanceof FrameDependentConstant) continue;
                mapValues.put(param.getName(), constArg);
                continue;
            }
            if (!param.hasDefaultValue()) continue;
            mapValues.put(param.getName(), param.getDefaultValue());
        }
    }

    public synchronized int getUnassignedRegisterIndex() {
        return this.m_nNextUnassignedIndex++;
    }

    @Override
    public boolean isConditionalReturn() {
        return super.isConditionalReturn();
    }

    @Override
    public void setConditionalReturn(boolean fConditional) {
        if (fConditional != this.isConditionalReturn()) {
            Parameter paramOld = this.m_aReturns[0];
            if (!paramOld.getType().isEcstasy("Boolean")) {
                throw new IllegalStateException("first return value is not Boolean (" + String.valueOf(paramOld) + ")");
            }
            this.m_aReturns[0] = new Parameter(this.getConstantPool(), paramOld.getType(), paramOld.getName(), paramOld.getDefaultValue(), true, 0, fConditional);
            super.setConditionalReturn(fConditional);
        }
    }

    @Override
    public String getName() {
        return this.getIdentityConstant().getName();
    }

    @Override
    protected boolean isChildLessVisible() {
        return true;
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        TypeConstant typeAnno = annotation.getAnnotationType();
        if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION || !typeAnno.getExplicitClassInto().isIntoMethodType()) {
            throw new IllegalArgumentException("only into Method annotations are allowed");
        }
        int cAnno = this.m_aAnnotations.length;
        if (cAnno == 0) {
            this.m_aAnnotations = new Annotation[]{annotation};
        } else {
            Annotation[] aAnno = new Annotation[cAnno + 1];
            System.arraycopy(this.m_aAnnotations, 0, aAnno, 0, cAnno);
            aAnno[cAnno] = annotation;
            this.m_aAnnotations = aAnno;
        }
    }

    @Override
    protected Component getEldestSibling() {
        MultiMethodStructure parent = (MultiMethodStructure)this.getParent();
        assert (parent != null);
        Component sibling = parent.getMethodByConstantMap().get(this.getIdentityConstant());
        assert (sibling != null);
        return sibling;
    }

    @Override
    public boolean isClassContainer() {
        return true;
    }

    @Override
    public boolean isMethodContainer() {
        return true;
    }

    @Override
    public ConcurrencySafety getConcurrencySafety() {
        if (this.m_safety != null) {
            return this.m_safety;
        }
        ConstantPool pool = this.getConstantPool();
        ConcurrencySafety safety = this.findAnnotation(pool.clzSynchronized()) != null ? ConcurrencySafety.Unsafe : (this.isStatic() || this.findAnnotation(pool.clzConcurrent()) != null ? ConcurrencySafety.Safe : this.getParent().getConcurrencySafety());
        this.m_safety = safety;
        return this.m_safety;
    }

    @Override
    public boolean isAutoNarrowingAllowed() {
        Component container;
        if (this.isFunction() && !((container = this.getParent().getParent()) instanceof ClassStructure)) {
            return false;
        }
        return this.getParent().isAutoNarrowingAllowed();
    }

    @Override
    public ComponentResolver.ResolutionResult resolveName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector) {
        int c = this.getParamCount();
        for (int i = 0; i < c; ++i) {
            Parameter param = this.m_aParams[i];
            if (!param.getName().equals(sName)) continue;
            if (i < this.getTypeParamCount()) {
                assert (param.isTypeParameter());
                return collector.resolvedConstant(this.getConstantPool().ensureRegisterConstant(this.getIdentityConstant(), i, sName));
            }
            AstNode node = collector.getNode();
            if (node == null) {
                collector.getErrorListener().log(Severity.ERROR, "COMPILER-136", null, this);
            } else {
                node.log(collector.getErrorListener(), Severity.ERROR, "COMPILER-136", new Object[0]);
            }
            return ComponentResolver.ResolutionResult.ERROR;
        }
        return super.resolveName(sName, access, collector);
    }

    @Override
    protected MethodStructure cloneBody() {
        int cParams;
        MethodStructure that = (MethodStructure)super.cloneBody();
        int cReturns = this.getReturnCount();
        if (cReturns > 0) {
            Parameter[] aReturns = new Parameter[cReturns];
            for (int i = 0; i < cReturns; ++i) {
                Parameter param = this.m_aReturns[i].cloneBody();
                param.setContaining(this);
                aReturns[i] = param;
            }
            that.m_aReturns = aReturns;
        }
        if ((cParams = this.getParamCount()) > 0) {
            Parameter[] aParams = new Parameter[cParams];
            for (int i = 0; i < cParams; ++i) {
                Parameter param = this.m_aParams[i].cloneBody();
                param.setContaining(this);
                aParams[i] = param;
            }
            that.m_aParams = aParams;
        }
        that.m_code = this.m_abOps == null && this.m_code != null ? this.m_code.cloneOnto(that) : null;
        if (this.m_aconstLocal != null) {
            that.m_aconstLocal = (Constant[])this.m_aconstLocal.clone();
        }
        that.m_structFinally = null;
        if (this.m_source != null) {
            that.m_source = this.m_source.clone();
        }
        return that;
    }

    @Override
    public void collectInjections(Set<InjectionKey> setInjections) {
        Constant[] aconst = this.m_aconstLocal;
        if (aconst == null) {
            return;
        }
        ConstantPool pool = this.getConstantPool();
        boolean fFound = false;
        for (Constant constant : aconst) {
            AnnotatedTypeConstant typeAnno;
            if (!(constant instanceof AnnotatedTypeConstant) || !(typeAnno = (AnnotatedTypeConstant)constant).getAnnotationClass().equals(pool.clzInject())) continue;
            fFound = true;
            break;
        }
        if (fFound) {
            for (Op op : this.ensureCode().getAssembledOps()) {
                String string;
                Constant constant;
                AnnotatedTypeConstant typeAnno;
                Var_DN opVar;
                TypeConstant typeConstant;
                if (!(op instanceof Var_DN) || !((typeConstant = (opVar = (Var_DN)op).getType(aconst)) instanceof AnnotatedTypeConstant) || !(typeAnno = (AnnotatedTypeConstant)typeConstant).getAnnotationClass().equals(pool.clzInject())) continue;
                Constant[] aconstParam = typeAnno.getAnnotationParams();
                if (aconstParam.length > 0 && (constant = aconstParam[0]) instanceof StringConstant) {
                    StringConstant constName = (StringConstant)constant;
                    string = constName.getValue();
                } else {
                    string = opVar.getName(aconst);
                }
                String sName = string;
                setInjections.add(new InjectionKey(sName, typeAnno.getParamType(0)));
            }
        }
    }

    @Override
    public MethodConstant getIdentityConstant() {
        return (MethodConstant)super.getIdentityConstant();
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        Constant[] aconstSuper;
        super.disassemble(in);
        ConstantPool pool = this.getConstantPool();
        MethodConstant constMethod = this.getIdentityConstant();
        TypeConstant[] aconstReturnTypes = constMethod.getRawReturns();
        TypeConstant[] aconstParamTypes = constMethod.getRawParams();
        int cAnnos = Handy.readMagnitude(in);
        Annotation[] aAnnos = cAnnos == 0 ? Annotation.NO_ANNOTATIONS : new Annotation[cAnnos];
        for (int i = 0; i < cAnnos; ++i) {
            aAnnos[i] = (Annotation)pool.getConstant(Handy.readMagnitude(in));
        }
        this.m_idFinally = (MethodConstant)pool.getConstant(Handy.readIndex(in));
        int cReturns = aconstReturnTypes.length;
        Parameter[] aReturns = new Parameter[cReturns];
        boolean fCond = this.isConditionalReturn();
        for (int i = 0; i < cReturns; ++i) {
            Parameter param = new Parameter(pool, in, true, i, i == 0 && fCond);
            if (!param.getType().equals(aconstReturnTypes[i])) {
                throw new IOException("type mismatch between method constant and return " + i + " value type");
            }
            aReturns[i] = param;
        }
        int cTypeParams = Handy.readMagnitude(in);
        int cDefaultParams = Handy.readMagnitude(in);
        int cParams = aconstParamTypes.length;
        Parameter[] aParams = new Parameter[cParams];
        for (int i = 0; i < cParams; ++i) {
            Parameter param = new Parameter(pool, in, false, i, i < cTypeParams);
            if (!param.getType().equals(aconstParamTypes[i])) {
                throw new IOException("type mismatch between method constant and param " + i + " value type");
            }
            aParams[i] = param;
        }
        this.m_idSuper = (MethodConstant)pool.getConstant(Handy.readIndex(in));
        if (this.m_idSuper == null) {
            aconstSuper = Constant.NO_CONSTS;
        } else {
            int cSuperArgs = Handy.readMagnitude(in);
            aconstSuper = new Constant[cSuperArgs];
            for (int i = 0; i < cSuperArgs; ++i) {
                aconstSuper[i] = pool.getConstant(Handy.readIndex(in));
            }
        }
        this.m_aconstSuper = aconstSuper;
        int cConsts = Handy.readMagnitude(in);
        Constant[] aconst = cConsts == 0 ? Constant.NO_CONSTS : new Constant[cConsts];
        for (int i = 0; i < cConsts; ++i) {
            aconst[i] = pool.getConstant(Handy.readMagnitude(in));
        }
        byte[] abOps = null;
        int cbOps = Handy.readMagnitude(in);
        if (cbOps > 0) {
            abOps = new byte[cbOps];
            in.readFully(abOps);
        }
        assert (cConsts == 0 || cbOps > 0);
        byte[] abAST = null;
        int cbAST = Handy.readMagnitude(in);
        if (cbAST > 0) {
            assert (cbOps > 0);
            abAST = new byte[cbAST];
            in.readFully(abAST);
        }
        Source source = new Source();
        source.disassemble(in);
        this.m_aAnnotations = aAnnos;
        this.m_aReturns = aReturns;
        this.m_cTypeParams = cTypeParams;
        this.m_cDefaultParams = cDefaultParams;
        this.m_aParams = aParams;
        this.m_aconstLocal = aconst;
        this.m_abOps = abOps;
        this.m_abAst = abAST;
        this.m_FHasCode = abOps != null || abAST != null;
        this.m_source = source.isPresent() ? source : null;
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_aAnnotations = (Annotation[])Constant.registerConstants(pool, this.m_aAnnotations);
        if (this.m_idFinally != null) {
            this.m_idFinally = (MethodConstant)pool.register(this.m_idFinally);
        }
        for (Parameter param : this.m_aReturns) {
            param.registerConstants(pool);
        }
        for (Parameter param : this.m_aParams) {
            param.registerConstants(pool);
        }
        if (this.m_idSuper != null) {
            this.m_idSuper = (MethodConstant)pool.register(this.m_idSuper);
            this.m_aconstSuper = Constant.registerConstants(pool, this.m_aconstSuper);
        }
        if (this.m_abOps != null || this.m_abAst != null) {
            if (this.m_aconstLocal != null) {
                this.m_aconstLocal = Constant.registerConstants(pool, this.m_aconstLocal);
            }
        } else {
            Op.ConstantRegistry registry;
            this.m_registry = registry = new Op.ConstantRegistry(this, pool);
            if (this.m_code != null) {
                this.m_code.prepareOps();
                this.m_code.registerConstants(registry);
            }
            if (this.m_ast != null) {
                registry.init(this.m_aAstParams);
                this.m_ast.prepareWrite(registry);
            }
            this.m_aconstLocal = registry.getConstantArray();
        }
        if (this.m_source != null) {
            this.m_source.registerConstants(pool);
        }
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        byte[] abAst;
        byte[] abOps;
        Constant[] aconst;
        super.assemble(out);
        Handy.writePackedLong(out, this.m_aAnnotations.length);
        for (Annotation annotation : this.m_aAnnotations) {
            Handy.writePackedLong(out, annotation.getPosition());
        }
        Handy.writePackedLong(out, Constant.indexOf(this.m_idFinally));
        for (XvmStructure xvmStructure : this.m_aReturns) {
            ((Parameter)xvmStructure).assemble(out);
        }
        Handy.writePackedLong(out, this.m_cTypeParams);
        Handy.writePackedLong(out, this.m_cDefaultParams);
        for (XvmStructure xvmStructure : this.m_aParams) {
            ((Parameter)xvmStructure).assemble(out);
        }
        Handy.writePackedLong(out, Constant.indexOf(this.m_idSuper));
        if (this.m_idSuper != null) {
            Handy.writePackedLong(out, this.m_aconstSuper.length);
            for (XvmStructure xvmStructure : this.m_aconstSuper) {
                Handy.writePackedLong(out, Constant.indexOf((Constant)xvmStructure));
            }
        }
        int cConsts = (aconst = this.m_aconstLocal) == null ? 0 : aconst.length;
        Handy.writePackedLong(out, cConsts);
        for (int i = 0; i < cConsts; ++i) {
            Handy.writePackedLong(out, aconst[i].getPosition());
        }
        if (this.m_abOps == null && this.m_code != null) {
            try {
                this.m_code.ensureAssembled(this.m_registry);
            }
            catch (UnsupportedOperationException e) {
                System.err.println("Error in MethodStructure.assemble() of ops for " + this.getParent().getContainingClass().getName() + "." + this.getName() + ": " + String.valueOf(e));
            }
        }
        int n = (abOps = this.m_abOps) == null ? 0 : abOps.length;
        Handy.writePackedLong(out, n);
        if (n > 0) {
            out.write(abOps);
        }
        if (this.m_abAst == null && this.m_ast != null) {
            try {
                ByteArrayOutputStream collectAst = new ByteArrayOutputStream();
                this.m_ast.write(new DataOutputStream(collectAst), this.m_registry);
                this.m_abAst = collectAst.toByteArray();
            }
            catch (IOException e) {
                System.err.println("Error in MethodStructure.assemble() of AST for " + this.getParent().getContainingClass().getName() + "." + this.getName() + ": " + String.valueOf(e));
                throw new IOException(e);
            }
        }
        int cbAst = (abAst = this.m_abAst) == null ? 0 : abAst.length;
        Handy.writePackedLong(out, cbAst);
        if (cbAst > 0) {
            out.write(abAst);
        }
        (this.m_source == null ? new Source() : this.m_source).assemble(out);
        this.m_registry = null;
    }

    @Override
    public Iterator<? extends XvmStructure> getContained() {
        return this.getAnnotationCount() == 0 ? super.getContained() : new LinkedIterator(super.getContained(), Arrays.stream(this.m_aAnnotations).iterator());
    }

    @Override
    public String getDescription() {
        MethodConstant id = this.getIdentityConstant();
        StringBuilder sb = new StringBuilder();
        sb.append("host=\"").append(id.getNamespace().getName()).append("\", id=\"").append(id.getValueString());
        if (id.isLambda()) {
            sb.append("\", lambda=").append(id.getLambdaIndex());
        }
        sb.append("\", sig=").append(id.isNascent() ? "n/a" : id.getSignature());
        if (this.isNative()) {
            sb.append(", native");
        }
        if (this.hasCode()) {
            sb.append(", hasCode");
        }
        if (this.isConditionalReturn()) {
            sb.append(", conditional");
        }
        sb.append(", type-param-count=").append(this.m_cTypeParams).append(", ").append(super.getDescription());
        boolean fSrc = this.m_source != null && this.m_source.isPresent();
        sb.append(", hasSource=").append(fSrc);
        if (fSrc) {
            sb.append(", line-number=").append(this.m_source.getLineNumber()).append(", line-count=").append(this.m_source.getLineCount());
        }
        return sb.toString();
    }

    @Override
    protected void dump(PrintWriter out, String sIndent) {
        super.dump(out, sIndent);
        if (!this.isAbstract() && !this.isNative() && this.hasOps()) {
            out.println(Handy.indentLines(this.ensureCode().toString(), this.nextIndent(sIndent)));
        }
    }

    public static class Code {
        protected final MethodStructure f_method;
        private ArrayList<Op> m_listOps;
        private IdentityHashMap<Op, Integer> m_mapIndex;
        private boolean m_fTrailingPrefix;
        private Op[] m_aop;
        private Code m_hole;
        private int m_nPrevLine;
        private int m_nCurLine;

        Code(MethodStructure method) {
            assert (method != null);
            this.f_method = method;
            byte[] abOps = method.m_abOps;
            if (abOps != null) {
                Op[] aop;
                Constant[] aconst = method.getLocalConstants();
                try {
                    aop = abOps.length == 0 ? Op.NO_OPS : Op.readOps(new DataInputStream(new ByteArrayInputStream(abOps)), aconst);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.m_aop = aop;
                this.addressAndSimulateOps();
                for (Op op : aop) {
                    op.resolveCode(this, aconst);
                }
            }
        }

        Code(MethodStructure method, Code wrappee) {
            assert (method != null);
            assert (wrappee != null);
            this.f_method = method;
        }

        public Op get(int i) {
            return this.m_aop[i];
        }

        public void updateLineNumber(int nLine) {
            this.m_nCurLine = nLine;
        }

        public Code add(Op op) {
            this.ensureAppending();
            int nLineDelta = this.m_nCurLine - this.m_nPrevLine;
            if (nLineDelta != 0 && !op.isEnter()) {
                this.m_nPrevLine = this.m_nCurLine;
                this.add(new Nop(nLineDelta));
            }
            ArrayList<Op> listOps = this.m_listOps;
            if (this.m_fTrailingPrefix) {
                ((Op.Prefix)listOps.getLast()).append(op);
            } else {
                listOps.add(op);
            }
            this.m_fTrailingPrefix = op instanceof Op.Prefix;
            this.m_mapIndex = null;
            return this;
        }

        public Register createRegister(TypeConstant type) {
            return this.createRegister(type, null);
        }

        public Register createRegister(TypeConstant type, String sName) {
            return new Register(type, sName, this.getMethodStructure());
        }

        public Register createRegister(TypeConstant type, boolean fUsedOnce) {
            return this.createRegister(type, null, fUsedOnce);
        }

        public Register createRegister(TypeConstant type, String sName, boolean fUsedOnce) {
            return fUsedOnce ? new Register(type, sName, -1) : new Register(type, sName, this.getMethodStructure());
        }

        public Register lastRegister() {
            ArrayList<Op> list = this.m_listOps;
            if (!list.isEmpty()) {
                Op op;
                do {
                    op = (Op)list.getLast();
                    while (op instanceof Op.Prefix) {
                        Op.Prefix opPrefix = (Op.Prefix)op;
                        op = opPrefix.getNextOp();
                    }
                } while (op == null);
                if (op instanceof OpVar) {
                    OpVar opVar = (OpVar)op;
                    return opVar.getRegister();
                }
                throw new IllegalStateException("op=" + String.valueOf(op));
            }
            throw new IllegalStateException("no ops");
        }

        public Op getLastOp() {
            Op opLast;
            ArrayList<Op> listOps = this.m_listOps;
            Op op = opLast = listOps.isEmpty() ? null : (Op)listOps.getLast();
            if (this.m_fTrailingPrefix) {
                Op opNext;
                while ((opNext = ((Op.Prefix)opLast).getNextOp()) != null && (opLast = opNext) instanceof Op.Prefix) {
                }
            }
            return opLast;
        }

        public boolean usesSuper() {
            Op[] aop = this.ensureOps();
            if (aop != null) {
                for (Op op : aop) {
                    if (!op.usesSuper()) continue;
                    return true;
                }
            }
            return false;
        }

        public Op[] getAssembledOps() {
            return this.ensureOps();
        }

        public boolean hasOps() {
            return this.m_listOps != null && !this.m_listOps.isEmpty() || this.f_method.m_abOps != null && this.f_method.m_abOps.length > 0;
        }

        public boolean isNoOp() {
            if (this.m_listOps == null && this.m_aop == null) {
                return false;
            }
            Op[] aOp = this.ensureOps();
            switch (aOp.length) {
                case 0: {
                    return true;
                }
                case 1: {
                    return aOp[0].getOpCode() == 76;
                }
                case 2: {
                    Construct_0 opCtor0;
                    if (aOp[1].getOpCode() != 76) break;
                    Op op0 = aOp[0];
                    return op0 instanceof Nop || op0 instanceof Construct_0 && (opCtor0 = (Construct_0)op0).isNoOp(this.f_method.getLocalConstants());
                }
            }
            return false;
        }

        Code cloneOnto(MethodStructure method) {
            Code that = new Code(method, this);
            if (this.m_listOps != null) {
                that.m_listOps = new ArrayList<Op>(this.m_listOps);
            }
            that.m_mapIndex = this.m_mapIndex;
            that.m_fTrailingPrefix = this.m_fTrailingPrefix;
            that.m_aop = this.m_aop;
            that.m_nPrevLine = this.m_nPrevLine;
            that.m_nCurLine = this.m_nCurLine;
            return that;
        }

        public MethodStructure getMethodStructure() {
            return this.f_method;
        }

        public Code blackhole() {
            Code hole = this.m_hole;
            if (hole == null) {
                this.m_hole = hole = new BlackHole(this);
            }
            return hole;
        }

        public String toString() {
            if (this.m_listOps == null && this.m_aop == null) {
                return "native";
            }
            Op[] aOp = this.m_aop == null ? this.m_listOps.toArray(Op.NO_OPS) : this.m_aop;
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Op op : aOp) {
                sb.append("\n[").append(i++).append("] ").append(op.toString());
            }
            return sb.substring(1);
        }

        protected void ensureAppending() {
            if (this.f_method.m_abOps != null) {
                throw new IllegalStateException("not appendable");
            }
            if (this.m_listOps == null) {
                this.m_listOps = new ArrayList();
            }
        }

        private boolean eliminateDeadCode() {
            this.addressAndSimulateOps();
            Op[] aop = this.ensureOps();
            this.follow(0);
            int cOld = aop.length;
            int cNew = 0;
            for (int iOld = 0; iOld < cOld; ++iOld) {
                Op op = aop[iOld];
                if (op.isDiscardable()) continue;
                if (cNew < iOld) {
                    aop[cNew] = op;
                }
                ++cNew;
            }
            if (cNew == cOld) {
                return false;
            }
            Op[] aopNew = new Op[cNew];
            System.arraycopy(aop, 0, aopNew, 0, cNew);
            this.m_aop = aopNew;
            return true;
        }

        private void follow(int iPC) {
            Op[] aop = this.m_aop;
            Op op = aop[iPC];
            if (op.isReachable()) {
                return;
            }
            ArrayList<Integer> listBranches = new ArrayList<Integer>();
            do {
                op.markReachable(aop);
                if (op.branches(aop, listBranches)) {
                    Iterator iterator = listBranches.iterator();
                    while (iterator.hasNext()) {
                        int cJmp = (Integer)iterator.next();
                        this.follow(iPC + cJmp);
                    }
                    listBranches.clear();
                }
                if (!op.advances()) {
                    return;
                }
                try {
                    op = aop[++iPC];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalStateException("illegal op-code: " + String.valueOf(this));
                }
            } while (!op.isReachable());
        }

        protected void prepareOps() {
            assert (this.f_method.m_abOps == null);
            do {
                this.eliminateDeadCode();
            } while (this.eliminateRedundantCode());
        }

        private boolean eliminateRedundantCode() {
            this.addressAndSimulateOps();
            Op[] aop = this.ensureOps();
            boolean fMod = false;
            for (Op op : aop) {
                fMod |= op.checkRedundant(aop);
            }
            if (!fMod) {
                return false;
            }
            int cOld = aop.length;
            int cNew = 0;
            Op.Prefix opPrefix = null;
            for (int iOld = 0; iOld < cOld; ++iOld) {
                Op op = aop[iOld];
                if (op.isRedundant()) {
                    if (opPrefix == null) {
                        opPrefix = op.convertToPrefix();
                        continue;
                    }
                    opPrefix.append(op.convertToPrefix());
                    continue;
                }
                if (cNew < iOld) {
                    if (opPrefix == null) {
                        aop[cNew] = op;
                    } else {
                        aop[cNew] = opPrefix.append(op);
                        opPrefix = null;
                    }
                }
                ++cNew;
            }
            assert (cNew != cOld);
            Op[] aopNew = new Op[cNew];
            System.arraycopy(aop, 0, aopNew, 0, cNew);
            this.m_aop = aopNew;
            return true;
        }

        private void addressAndSimulateOps() {
            Op[] aop;
            for (Op op : aop = this.ensureOps()) {
                op.resetSimulation();
            }
            Scope scope = this.f_method.createInitialScope();
            int c = aop.length;
            for (int i = 0; i < c; ++i) {
                Op op;
                op = aop[i];
                op.initInfo(i, scope.getCurDepth(), scope.getGuardDepth(), scope.getGuardAllDepth());
                op.simulate(scope);
            }
            for (Op op : aop) {
                op.resolveAddresses(aop);
            }
            this.f_method.m_cVars = scope.getMaxVars();
            this.f_method.m_cScopes = scope.getMaxDepth();
        }

        protected void registerConstants(Op.ConstantRegistry registry) {
            for (Op op : this.ensureOps()) {
                op.registerConstants(registry);
            }
        }

        protected synchronized void ensureAssembled(Op.ConstantRegistry registry) {
            assert (this.f_method.m_abOps == null);
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream outData = new DataOutputStream(outBytes);
            try {
                Op[] aOp = this.ensureOps();
                Handy.writePackedLong(outData, aOp.length);
                for (Op op : aOp) {
                    op.write(outData, registry);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.f_method.m_abOps = outBytes.toByteArray();
            this.f_method.m_aconstLocal = registry.getConstantArray();
            this.f_method.markModified();
        }

        private Op[] ensureOps() {
            Op[] aop = this.m_aop;
            if (aop == null) {
                if (this.m_listOps == null) {
                    throw new UnsupportedOperationException("Method \"" + this.f_method.getIdentityConstant().getPathString() + "\" is neither native nor compiled");
                }
                aop = this.m_listOps.toArray(Op.NO_OPS);
                this.m_aop = aop;
            }
            return aop;
        }

        static class BlackHole
        extends Code {
            Code f_wrappee;

            BlackHole(Code wrappee) {
                super(wrappee.f_method, wrappee);
                this.f_wrappee = wrappee;
            }

            @Override
            public Code add(Op op) {
                return this;
            }

            @Override
            public Register lastRegister() {
                MethodStructure method = this.getMethodStructure();
                return new Register(method.getConstantPool().typeObject(), null, method);
            }

            @Override
            public boolean usesSuper() {
                return false;
            }

            @Override
            public Op[] getAssembledOps() {
                throw new IllegalStateException();
            }

            @Override
            public Code blackhole() {
                return this;
            }

            @Override
            public String toString() {
                return "<blackhole>";
            }
        }
    }

    protected class Source
    implements Cloneable {
        private int m_iFirstLine;
        private String m_sSrc;
        private StringConstant[] m_aconstSrc;
        private int[] m_anIndents;

        protected Source() {
        }

        protected Source(int iLine, String sSrc) {
            this.m_iFirstLine = iLine;
            this.m_sSrc = sSrc;
        }

        public boolean isPresent() {
            return this.m_sSrc != null || this.m_aconstSrc != null;
        }

        public String getText() {
            if (this.m_sSrc == null) {
                this.inflate();
            }
            return this.m_sSrc;
        }

        public int getLineNumber() {
            return this.m_iFirstLine;
        }

        public int getLineCount() {
            this.normalize();
            return this.m_aconstSrc == null ? 0 : this.m_aconstSrc.length;
        }

        public String[] renderLines(int iFirst, int cLines, boolean fTrim) {
            this.normalize();
            if (this.m_aconstSrc == null || iFirst < this.m_iFirstLine || iFirst >= this.m_iFirstLine + this.m_aconstSrc.length) {
                return null;
            }
            if ((iFirst -= this.m_iFirstLine) + cLines > this.m_aconstSrc.length) {
                cLines = this.m_aconstSrc.length;
            }
            int iLast = iFirst + cLines - 1;
            int cTrim = 0;
            if (fTrim) {
                cTrim = this.m_anIndents[iFirst];
                for (int iLine = iFirst + 1; iLine <= iLast && cTrim != 0; ++iLine) {
                    int nIndent = this.m_anIndents[iLine];
                    if (cTrim < 0 && nIndent < 0) {
                        if (cTrim >= nIndent) continue;
                        cTrim = nIndent;
                        continue;
                    }
                    if (cTrim > 0 && nIndent > 0) {
                        if (cTrim <= nIndent) continue;
                        cTrim = nIndent;
                        continue;
                    }
                    cTrim = 0;
                }
            }
            String[] asLine = new String[cLines];
            for (int iLine = iFirst; iLine <= iLast; ++iLine) {
                StringConstant constLine = this.m_aconstSrc[iLine];
                if (constLine == null) {
                    asLine[iLine - iFirst] = "";
                    continue;
                }
                int nIndent = this.m_anIndents[iLine] - cTrim;
                if (nIndent != 0) {
                    int c;
                    StringBuilder sb = new StringBuilder();
                    char ch = nIndent < 0 ? (char)'\t' : ' ';
                    int n = c = nIndent < 0 ? -nIndent : nIndent;
                    for (int i = 0; i < c; ++i) {
                        sb.append(ch);
                    }
                    sb.append(constLine.getValue());
                    asLine[iLine - iFirst] = sb.toString();
                    continue;
                }
                asLine[iLine - iFirst] = constLine.getValue();
            }
            return asLine;
        }

        protected void normalize() {
            if (this.m_aconstSrc == null && this.m_sSrc != null) {
                String[] asLine = Handy.parseDelimitedString(this.m_sSrc, '\n');
                int cLines = asLine.length;
                StringConstant[] aconstLine = new StringConstant[cLines];
                int[] anIndent = new int[cLines];
                ConstantPool pool = MethodStructure.this.getConstantPool();
                for (int iLine = 0; iLine < cLines; ++iLine) {
                    int ofEnd;
                    String sLine = asLine[iLine];
                    for (ofEnd = sLine.length(); ofEnd > 0 && Character.isWhitespace(sLine.charAt(ofEnd - 1)); --ofEnd) {
                    }
                    if (ofEnd <= 0) continue;
                    int ofBegin = 0;
                    char chBegin = sLine.charAt(ofBegin);
                    if (chBegin == ' ' || chBegin == '\t') {
                        while (sLine.charAt(++ofBegin) == chBegin) {
                        }
                    }
                    aconstLine[iLine] = pool.ensureStringConstant(sLine.substring(ofBegin, ofEnd));
                    anIndent[iLine] = chBegin == '\t' ? -ofBegin : ofBegin;
                }
                this.m_aconstSrc = aconstLine;
                this.m_anIndents = anIndent;
            }
        }

        protected void inflate() {
            if (this.m_sSrc == null && this.m_aconstSrc != null) {
                StringBuilder sb = new StringBuilder();
                int cLines = this.m_aconstSrc.length;
                for (int iLine = 0; iLine < cLines; ++iLine) {
                    StringConstant constLine;
                    int nIndent;
                    if (iLine > 0) {
                        sb.append('\n');
                    }
                    if ((nIndent = this.m_anIndents[iLine]) != 0) {
                        int c;
                        char ch = nIndent < 0 ? (char)'\t' : ' ';
                        int n = c = nIndent < 0 ? -nIndent : nIndent;
                        for (int i = 0; i < c; ++i) {
                            sb.append(ch);
                        }
                    }
                    if ((constLine = this.m_aconstSrc[iLine]) == null) continue;
                    sb.append(constLine.getValue());
                }
                this.m_sSrc = sb.toString();
            }
        }

        protected Source clone() {
            try {
                return (Source)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException();
            }
        }

        protected void disassemble(DataInput in) throws IOException {
            int cLines = Handy.readPackedInt(in);
            if (cLines > 0) {
                StringConstant[] aconstSrc = new StringConstant[cLines];
                int[] anIndents = new int[cLines];
                this.m_iFirstLine = Handy.readPackedInt(in);
                ConstantPool pool = MethodStructure.this.getConstantPool();
                for (int i = 0; i < cLines; ++i) {
                    anIndents[i] = Handy.readPackedInt(in);
                    aconstSrc[i] = (StringConstant)pool.getConstant(Handy.readIndex(in));
                }
                this.m_aconstSrc = aconstSrc;
                this.m_anIndents = anIndents;
            }
        }

        protected void registerConstants(ConstantPool pool) {
            this.normalize();
            if (this.m_aconstSrc != null) {
                this.m_aconstSrc = (StringConstant[])Constant.registerConstants(pool, this.m_aconstSrc);
            }
        }

        protected void assemble(DataOutput out) throws IOException {
            this.normalize();
            if (this.m_aconstSrc == null) {
                Handy.writePackedLong(out, 0L);
            } else {
                int cLines = this.m_aconstSrc.length;
                Handy.writePackedLong(out, cLines);
                if (cLines > 0) {
                    Handy.writePackedLong(out, this.m_iFirstLine);
                    for (int i = 0; i < cLines; ++i) {
                        Handy.writePackedLong(out, this.m_anIndents[i]);
                        Handy.writePackedLong(out, Constant.indexOf(this.m_aconstSrc[i]));
                    }
                }
            }
        }
    }

    public static enum ConcurrencySafety {
        Safe,
        Unsafe,
        Instance;

    }
}

