/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.VersionTree;

public interface ModuleRepository {
    public static final ModuleRepository[] NO_REPOS = new ModuleRepository[0];

    default public Set<String> getDomainNames() {
        Set<String> modules = this.getModuleNames();
        TreeSet<String> domains = new TreeSet<String>();
        for (String module : modules) {
            int of = module.indexOf(46);
            if (of < 0) continue;
            domains.add(module.substring(of + 1));
        }
        return domains;
    }

    default public Set<String> getModuleNames(String sDomain) {
        Set<String> modules = this.getModuleNames();
        TreeSet<String> names = new TreeSet<String>();
        for (String module : modules) {
            int of = module.indexOf(46);
            names.add(of < 0 ? module : module.substring(0, of));
        }
        return names;
    }

    public Set<String> getModuleNames();

    default public VersionTree<Boolean> getAvailableVersions(String sModule) {
        ModuleStructure module = this.loadModule(sModule);
        return module == null ? null : module.getVersions();
    }

    public ModuleStructure loadModule(String var1);

    default public ModuleStructure loadModule(String sModule, Version version, boolean fExact) {
        ModuleStructure module = this.loadModule(sModule);
        if (module == null || version == null) {
            return module;
        }
        Version useVersion = null;
        if (module.containsVersion(version)) {
            useVersion = version;
        } else {
            for (Version possibleVer : module.getVersions()) {
                if (!possibleVer.isSubstitutableFor(version)) continue;
                if (version.isSubstitutableFor(possibleVer)) {
                    useVersion = possibleVer;
                    break;
                }
                if (fExact || useVersion != null && !useVersion.isSubstitutableFor(possibleVer)) continue;
                useVersion = possibleVer;
            }
            if (useVersion == null) {
                return null;
            }
        }
        return module.extractVersion(useVersion);
    }

    public void storeModule(ModuleStructure var1) throws IOException;
}

