/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.FileStructure;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.Version;
import org.xvm.asm.VersionTree;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.NamedCondition;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;

public class ModuleStructure
extends ClassStructure {
    private LiteralConstant m_constDir;
    private LiteralConstant m_constTimestamp;
    private ModuleType m_moduletype = ModuleType.Primary;
    private VersionConstant m_constVersion;
    private VersionTree<Boolean> m_vtreeImportAllowVers;
    private List<Version> m_listImportPreferVers;
    private transient ModuleStructure m_moduleActual;
    private transient PackageStructure m_pkgImport;
    private transient byte[] m_abDigest;
    private transient Map<String, Boolean> m_mapCondNames;
    private transient Map<ModuleConstant, Boolean> m_mapDependencies;
    private transient VersionTree<Boolean> m_vtree;

    protected ModuleStructure(XvmStructure xsParent, ModuleConstant constId) {
        this(xsParent, Component.Format.MODULE.ordinal() << 0 | 0x100 | 0x800, constId, null);
    }

    protected ModuleStructure(XvmStructure xsParent, int nFlags, ModuleConstant constId, ConditionalConstant condition) {
        super(xsParent, nFlags, constId, condition);
        ModuleConstant idPrimary = xsParent.getFileStructure().getModuleId();
        if (idPrimary != null && !idPrimary.equals(constId)) {
            this.m_moduletype = ModuleType.Optional;
            this.m_vtreeImportAllowVers = new VersionTree();
            this.m_listImportPreferVers = new ArrayList<Version>();
        }
    }

    @Override
    public ModuleConstant getIdentityConstant() {
        return (ModuleConstant)super.getIdentityConstant();
    }

    public ModuleType getModuleType() {
        return this.m_moduletype;
    }

    public boolean isMainModule() {
        return this.m_moduletype == ModuleType.Primary && this.getIdentityConstant().equals(this.getFileStructure().getModuleId());
    }

    public boolean isFingerprint() {
        return switch (this.m_moduletype.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1, 2, 3 -> true;
            case 0, 4 -> false;
        };
    }

    public Map<ModuleConstant, ModuleType> getDependencyTypes() {
        if (!this.isRefined()) {
            if (this.getVersions().size() > 1) {
                throw new IllegalStateException("module contains unrefined versions");
            }
            if (this.getConditionalNames().containsValue(null)) {
                throw new IllegalStateException("module contains unrefined conditional names");
            }
        }
        HashMap<ModuleConstant, ModuleType> mapModuleTypes = new HashMap<ModuleConstant, ModuleType>();
        Consumer<Component> visitor = component -> {
            PackageStructure pkg;
            if (component instanceof PackageStructure && (pkg = (PackageStructure)component).isModuleImport()) {
                ModuleStructure module = pkg.getImportedModule();
                assert (module != null);
                mapModuleTypes.put(module.getIdentityConstant(), module.getModuleType());
            }
        };
        this.visitChildren(visitor, true, true);
        return mapModuleTypes;
    }

    public Map<ModuleConstant, Boolean> getDependencies() {
        Map<ModuleConstant, Boolean> mapDependencies = this.m_mapDependencies;
        if (mapDependencies == null) {
            mapDependencies = this.m_mapDependencies = this.collectModuleDependencies();
        }
        return mapDependencies;
    }

    protected Map<ModuleConstant, Boolean> collectModuleDependencies() {
        ListMap<ModuleConstant, Boolean> map = new ListMap<ModuleConstant, Boolean>();
        for (Map.Entry<ModuleConstant, ModuleType> entry : this.getDependencyTypes().entrySet()) {
            map.put(entry.getKey(), switch (entry.getValue().ordinal()) {
                default -> throw new MatchException(null, null);
                case 3, 4 -> Boolean.TRUE;
                case 1, 2 -> null;
                case 0 -> throw new IllegalStateException();
            });
        }
        return map;
    }

    public byte[] getDigest() {
        assert (!this.isFingerprint());
        byte[] abDigest = this.m_abDigest;
        if (abDigest == null) {
            try {
                DigestOutputStream dos = new DigestOutputStream(OutputStream.nullOutputStream(), MessageDigest.getInstance("SHA-256"));
                DataOutputStream out = new DataOutputStream(dos);
                this.assemble(out);
                this.assembleChildren(out);
                out.close();
                abDigest = this.m_abDigest = dos.getMessageDigest().digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return abDigest;
    }

    public boolean isRefined() {
        if (this.isFingerprint()) {
            return false;
        }
        if (this.isLinked()) {
            return true;
        }
        return true;
    }

    public boolean isLinked() {
        return !this.isFingerprint() || this.getFingerprintOrigin() != null;
    }

    public LiteralConstant getSourceDir() {
        return this.m_constDir;
    }

    public void setSourceDir(LiteralConstant constDir) {
        this.m_constDir = constDir;
        this.markModified();
    }

    public LiteralConstant getTimestamp() {
        return this.m_constTimestamp;
    }

    public void setTimestamp(LiteralConstant constTimestamp) {
        this.m_constTimestamp = constTimestamp;
        this.markModified();
    }

    public VersionConstant getVersionConstant() {
        assert (!this.isFingerprint());
        return this.m_constVersion;
    }

    public void setVersion(Version version) {
        assert (!this.isFingerprint());
        this.markModified();
        this.m_constVersion = this.getConstantPool().ensureVersionConstant(version);
    }

    public String getVersionString() {
        Version ver = this.getVersion();
        return ver == null ? null : ver.toString();
    }

    public VersionTree<Boolean> getFingerprintVersions() {
        assert (this.isFingerprint());
        return this.m_vtreeImportAllowVers;
    }

    public void setFingerprintVersions(VersionTree<Boolean> vtreeAllow) {
        assert (this.isFingerprint());
        this.m_vtreeImportAllowVers.clear();
        this.m_vtreeImportAllowVers.putAll(vtreeAllow);
        this.markModified();
    }

    public List<Version> getFingerprintVersionPrefs() {
        assert (this.isFingerprint());
        List<Version> list = this.m_listImportPreferVers;
        assert ((list = Collections.unmodifiableList(list)) != null);
        return list;
    }

    public void setFingerprintVersionPrefs(List<Version> listPrefer) {
        assert (this.isFingerprint());
        this.m_listImportPreferVers.clear();
        this.m_listImportPreferVers.addAll(listPrefer);
        this.markModified();
    }

    public void fingerprintOptional() {
        assert (this.isFingerprint());
    }

    public void fingerprintDesired() {
        assert (this.isFingerprint());
        if (this.m_moduletype == ModuleType.Optional) {
            this.m_moduletype = ModuleType.Desired;
            this.markModified();
        }
    }

    public void fingerprintRequired() {
        assert (this.isFingerprint());
        if (this.m_moduletype == ModuleType.Optional || this.m_moduletype == ModuleType.Desired) {
            this.m_moduletype = ModuleType.Required;
            this.markModified();
        }
    }

    public boolean isEmbeddedModule() {
        assert (this.m_moduletype == ModuleType.Embedded == (!this.isMainModule() && !this.isFingerprint()));
        return this.m_moduletype == ModuleType.Embedded;
    }

    public void setFingerprintOrigin(ModuleStructure moduleActual) {
        assert (this.isFingerprint());
        this.m_moduleActual = moduleActual;
    }

    public ModuleStructure getFingerprintOrigin() {
        return this.m_moduleActual;
    }

    public Map<ModuleConstant, String> collectDependencies() {
        HashMap<ModuleConstant, String> mapModulePaths = new HashMap<ModuleConstant, String>();
        mapModulePaths.put(this.getIdentityConstant(), "");
        this.collectDependencies("", mapModulePaths);
        return mapModulePaths;
    }

    public ClassStructure ensureSyntheticInterface(String sName) {
        ClassStructure clzInterface = (ClassStructure)this.getChild(sName);
        if (clzInterface == null) {
            clzInterface = this.createClass(Constants.Access.PUBLIC, Component.Format.INTERFACE, sName, null);
            clzInterface.setSynthetic(true);
        }
        return clzInterface;
    }

    public VersionTree<Boolean> getVersions() {
        VersionTree<Boolean> vtree = this.m_vtree;
        if (vtree == null) {
            this.m_vtree = vtree = new VersionTree();
            this.collectVersions(vtree);
        }
        return vtree;
    }

    protected void collectVersions(VersionTree vtree) {
        ModuleStructure module = this;
        do {
            Version version;
            if ((version = module.getVersion()) == null) continue;
            vtree.put(version, Boolean.TRUE);
        } while ((module = (ModuleStructure)module.getNextSibling()) != null);
    }

    public boolean containsVersion(Version ver) {
        return this.getVersions().contains(ver);
    }

    public Version getVersion() {
        VersionConstant constant = this.getVersionConstant();
        return constant == null ? null : constant.getVersion();
    }

    public Map<String, Boolean> getConditionalNames() {
        Map<String, Boolean> mapCondNames = this.m_mapCondNames;
        if (mapCondNames == null) {
            mapCondNames = this.m_mapCondNames = this.collectConditionalNames();
        }
        return mapCondNames;
    }

    protected Map<String, Boolean> collectConditionalNames() {
        HashMap<String, Boolean> mapConditions = new HashMap<String, Boolean>();
        Consumer<Component> visitor = component -> {
            ConditionalConstant constCond = component.getCondition();
            if (constCond != null) {
                for (ConditionalConstant condTerminal : constCond.terminals()) {
                    if (!(condTerminal instanceof NamedCondition)) continue;
                    NamedCondition condName = (NamedCondition)condTerminal;
                    mapConditions.put(condName.getName(), null);
                }
            }
        };
        visitor.accept(this);
        this.visitChildren(visitor, true, true);
        return mapConditions;
    }

    public boolean supportsVersion(Version ver, boolean fExact) {
        if (this.containsVersion(ver)) {
            return true;
        }
        if (!fExact) {
            return this.getVersions().findHighestVersion(ver) != null;
        }
        return false;
    }

    public void purgeVersion(Version ver) {
        if (ver == null) {
            throw new IllegalArgumentException("version required");
        }
        VersionTree<Boolean> vtree = this.getVersions();
        if (!vtree.contains(ver)) {
            return;
        }
        this.markModified();
    }

    public void purgeVersionsExcept(Version ver) {
        if (ver == null) {
            throw new IllegalArgumentException("version required");
        }
        VersionTree<Boolean> vtree = this.getVersions();
        if (!vtree.contains(ver = ver.normalize())) {
            throw new IllegalArgumentException("version " + String.valueOf(ver) + " does not exist in this module");
        }
        if (vtree.size() == 1) {
            return;
        }
        this.markModified();
    }

    public ModuleStructure extractVersion(Version version) {
        assert (this.isMainModule() && this.containsVersion(version));
        String sName = this.getName();
        ModuleConstant idModule = this.getConstantPool().ensureModuleConstant(sName, version);
        FileStructure fileClone = new FileStructure(sName);
        fileClone.removeChild(fileClone.getModule());
        fileClone.merge(this, false, true);
        ConstantPool pool = fileClone.getConstantPool();
        ModuleStructure moduleClone = fileClone.replaceModuleId(idModule);
        moduleClone.registerConstants(pool);
        moduleClone.registerChildrenConstants(pool);
        moduleClone.purgeVersionsExcept(version);
        return moduleClone;
    }

    @Override
    public String getName() {
        return this.getIdentityConstant().getName();
    }

    @Override
    public String getSimpleName() {
        return this.getIdentityConstant().getUnqualifiedName();
    }

    @Override
    public boolean isGloballyVisible() {
        return true;
    }

    @Override
    public boolean isPackageContainer() {
        return true;
    }

    @Override
    public ComponentResolver.ResolutionResult resolveName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector) {
        if (sName.equals(this.getSimpleName())) {
            collector.resolvedComponent(this);
            return ComponentResolver.ResolutionResult.RESOLVED;
        }
        return this.m_moduleActual == null ? super.resolveName(sName, access, collector) : this.m_moduleActual.resolveName(sName, access, collector);
    }

    @Override
    protected ModuleStructure cloneBody() {
        ModuleStructure that = (ModuleStructure)super.cloneBody();
        if (this.m_vtreeImportAllowVers != null) {
            that.m_vtreeImportAllowVers = new VersionTree();
            that.m_vtreeImportAllowVers.putAll(this.m_vtreeImportAllowVers);
        }
        if (this.m_listImportPreferVers != null) {
            that.m_listImportPreferVers = new ArrayList<Version>();
            that.m_listImportPreferVers.addAll(this.m_listImportPreferVers);
        }
        return that;
    }

    @Override
    public PackageStructure getImportedPackage(ModuleConstant idMainModule) {
        PackageStructure pkg = this.m_pkgImport;
        if (pkg == null) {
            ModuleStructure moduleMain = (ModuleStructure)idMainModule.getComponent();
            String sPath = moduleMain.collectDependencies().get(this.getIdentityConstant());
            assert (sPath != null);
            pkg = this.m_pkgImport = (PackageStructure)moduleMain.getChildByPath(sPath);
            assert (pkg.isModuleImport());
        }
        return pkg;
    }

    @Override
    protected void markModified() {
        super.markModified();
        this.m_abDigest = null;
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        super.disassemble(in);
        this.m_moduletype = ModuleType.valueOf(in.readUnsignedByte());
        ConstantPool pool = this.getConstantPool();
        if (this.isFingerprint()) {
            VersionTree<Boolean> vtreeAllow = new VersionTree<Boolean>();
            int c = Handy.readMagnitude(in);
            for (int i = 0; i < c; ++i) {
                VersionConstant constVer = (VersionConstant)pool.getConstant(Handy.readMagnitude(in));
                vtreeAllow.put(constVer.getVersion(), in.readBoolean());
            }
            ArrayList<Version> listPrefer = new ArrayList<Version>();
            int c2 = Handy.readMagnitude(in);
            for (int i = 0; i < c2; ++i) {
                VersionConstant constVer = (VersionConstant)pool.getConstant(Handy.readMagnitude(in));
                Version ver = constVer.getVersion();
                if (listPrefer.contains(ver)) continue;
                listPrefer.add(ver);
            }
            this.m_vtreeImportAllowVers = vtreeAllow;
            this.m_listImportPreferVers = listPrefer;
        } else if (in.readBoolean()) {
            this.m_constVersion = (VersionConstant)pool.getConstant(Handy.readMagnitude(in));
        }
        this.m_constDir = (LiteralConstant)this.getConstantPool().getConstant(Handy.readIndex(in));
        this.m_constTimestamp = (LiteralConstant)this.getConstantPool().getConstant(Handy.readIndex(in));
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        if (this.isFingerprint()) {
            for (Version ver : this.m_vtreeImportAllowVers) {
                pool.ensureVersionConstant(ver);
            }
            for (Version ver : this.m_listImportPreferVers) {
                pool.ensureVersionConstant(ver);
            }
        } else if (this.m_constVersion != null) {
            this.m_constVersion = (VersionConstant)pool.register(this.m_constVersion);
        }
        this.m_constDir = (LiteralConstant)pool.register(this.m_constDir);
        this.m_constTimestamp = (LiteralConstant)pool.register(this.m_constTimestamp);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        out.writeByte(this.m_moduletype.ordinal());
        ConstantPool pool = this.getConstantPool();
        if (this.isFingerprint()) {
            VersionTree<Boolean> vtreeAllow = this.m_vtreeImportAllowVers;
            Handy.writePackedLong(out, vtreeAllow.size());
            for (Version ver : vtreeAllow) {
                Handy.writePackedLong(out, pool.ensureVersionConstant(ver).getPosition());
                out.writeBoolean(vtreeAllow.get(ver));
            }
            List<Version> listPrefer = this.m_listImportPreferVers;
            Handy.writePackedLong(out, listPrefer.size());
            for (Version ver : listPrefer) {
                Handy.writePackedLong(out, pool.ensureVersionConstant(ver).getPosition());
            }
        } else if (this.m_constVersion == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Handy.writePackedLong(out, this.m_constVersion.getPosition());
        }
        Handy.writePackedLong(out, Constant.indexOf(this.m_constDir));
        Handy.writePackedLong(out, Constant.indexOf(this.m_constTimestamp));
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getDescription());
        sb.append(", module type=").append((Object)this.m_moduletype);
        if (this.isFingerprint()) {
            sb.append(", fingerprint=true");
            VersionTree<Boolean> vtreeAllow = this.m_vtreeImportAllowVers;
            List<Version> listPrefer = this.m_listImportPreferVers;
            if (!vtreeAllow.isEmpty() || !listPrefer.isEmpty()) {
                sb.append(", version={");
                boolean fFirst = true;
                for (Version ver : vtreeAllow) {
                    if (fFirst) {
                        sb.append(", ");
                        fFirst = false;
                    }
                    sb.append(vtreeAllow.get(ver) != false ? "allow " : "avoid ").append(ver);
                }
                for (Version ver : listPrefer) {
                    if (fFirst) {
                        sb.append(", ");
                        fFirst = false;
                    }
                    sb.append("prefer ").append(ver);
                }
                sb.append('}');
            }
        } else if (this.m_constVersion != null) {
            sb.append(", version={").append(this.m_constVersion.getVersion()).append('}');
        }
        sb.append(", source-dir=").append(this.m_constDir == null ? "none" : this.m_constDir.getValueString()).append(", timestamp=").append(this.m_constDir == null ? "none" : this.m_constTimestamp.getValueString());
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        ModuleStructure that;
        block5: {
            block4: {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof ModuleStructure)) break block4;
                that = (ModuleStructure)obj;
                if (super.equals(obj)) break block5;
            }
            return false;
        }
        return this.m_moduletype == that.m_moduletype && Handy.equals(this.m_vtreeImportAllowVers, that.m_vtreeImportAllowVers) && Handy.equals(this.m_listImportPreferVers, that.m_listImportPreferVers) && Handy.equals(this.m_constVersion, that.m_constVersion) && Handy.equals(this.m_constDir, that.m_constDir);
    }

    public static enum ModuleType {
        Primary,
        Optional,
        Desired,
        Required,
        Embedded;

        private static final ModuleType[] MODULE_TYPES;

        public static ModuleType valueOf(int i) {
            return MODULE_TYPES[i];
        }

        static {
            MODULE_TYPES = ModuleType.values();
        }
    }
}

