/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.xvm.asm.Annotation;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MultiMethodConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.ListMap;

public class MultiMethodStructure
extends Component {
    private Map<MethodConstant, MethodStructure> m_methodByConstant;
    private static final ThreadLocal<Boolean> s_tloIgnoreNative = ThreadLocal.withInitial(() -> Boolean.FALSE);

    protected MultiMethodStructure(XvmStructure xsParent, int nFlags, MultiMethodConstant constId, ConditionalConstant condition) {
        super(xsParent, nFlags, constId, condition);
        assert (Component.Format.fromFlags(nFlags) == Component.Format.MULTIMETHOD);
    }

    @Override
    public MultiMethodConstant getIdentityConstant() {
        return (MultiMethodConstant)super.getIdentityConstant();
    }

    @Override
    protected void assembleChildren(DataOutput out) throws IOException {
        if (this.getParent().getFormat() == Component.Format.CONST && !s_tloIgnoreNative.get().booleanValue()) {
            s_tloIgnoreNative.set(true);
            try {
                super.assembleChildren(out);
            }
            finally {
                s_tloIgnoreNative.set(false);
            }
        } else {
            super.assembleChildren(out);
        }
    }

    @Override
    public int getChildrenCount() {
        this.ensureChildren();
        Map<MethodConstant, MethodStructure> map = this.m_methodByConstant;
        return map == null ? 0 : (s_tloIgnoreNative.get() != false ? (int)map.values().stream().filter(m -> !m.isTransient()).count() : map.size());
    }

    @Override
    public boolean hasChildren() {
        return this.getChildrenCount() > 0;
    }

    @Override
    protected void replaceChildIdentityConstant(IdentityConstant idOld, IdentityConstant idNew) {
        MethodStructure child;
        assert (idOld instanceof MethodConstant);
        assert (idNew instanceof MethodConstant);
        Map<MethodConstant, MethodStructure> map = this.m_methodByConstant;
        if (map != null && (child = map.remove(idOld)) != null) {
            map.put((MethodConstant)idNew, child);
            idNew.resetCachedInfo();
        }
    }

    @Override
    public Map<String, Component> getChildByNameMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Component> ensureChildByNameMap() {
        return this.getChildByNameMap();
    }

    @Override
    protected boolean addChild(Component child) {
        MethodStructure method;
        MethodConstant id;
        assert (child instanceof MethodStructure);
        Map<MethodConstant, MethodStructure> kids = this.ensureMethodByConstantMap();
        MethodStructure sibling = kids.get(id = (method = (MethodStructure)child).getIdentityConstant());
        if (sibling == null) {
            kids.put(id, method);
        } else if (this.isSiblingAllowed()) {
            this.linkSibling(method, sibling);
        } else {
            return false;
        }
        this.markModified();
        return true;
    }

    @Override
    protected void adoptChildren(Component that) {
        assert (that instanceof MultiMethodStructure);
        super.adoptChildren(that);
        this.m_methodByConstant = ((MultiMethodStructure)that).m_methodByConstant;
    }

    @Override
    public void removeChild(Component child) {
        assert (child instanceof MethodStructure);
        assert (child.getParent() == this);
        Map<MethodConstant, MethodStructure> kids = this.ensureMethodByConstantMap();
        MethodStructure method = (MethodStructure)child;
        MethodConstant id = method.getIdentityConstant();
        MethodStructure sibling = kids.remove(id);
        this.unlinkSibling(kids, id, child, sibling);
    }

    @Override
    protected boolean areChildrenIdentical(Component that) {
        this.ensureChildren();
        return this.equalChildMaps(this.getMethodByConstantMap(), ((MultiMethodStructure)that).getMethodByConstantMap());
    }

    @Override
    public Component getChild(Constant constId) {
        assert (constId instanceof MethodConstant);
        MethodStructure firstSibling = this.getMethodByConstantMap().get(constId);
        return this.findLinkedChild(constId, firstSibling);
    }

    @Override
    public Collection<? extends Component> children() {
        return s_tloIgnoreNative.get() != false ? (Collection)this.methods().stream().filter(method -> !method.isTransient()).collect(Collectors.toList()) : this.methods();
    }

    @Override
    public List<Component> safeChildren() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (MethodConstant id : this.getMethodByConstantMap().keySet()) {
            MethodStructure method = (MethodStructure)this.getChild(id);
            if (method == null) continue;
            list.add(method);
        }
        return list;
    }

    @Override
    protected boolean canBeSeen(Constants.Access access) {
        for (MethodConstant id : this.getMethodByConstantMap().keySet()) {
            MethodStructure method = (MethodStructure)this.getChild(id);
            if (!method.canBeSeen(access)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAutoNarrowingAllowed() {
        return this.getParent().isAutoNarrowingAllowed();
    }

    @Override
    public MethodStructure findMethod(SignatureConstant sig) {
        for (MethodStructure method : this.methods()) {
            if (!method.getIdentityConstant().getSignature().equals(sig)) continue;
            return method;
        }
        return null;
    }

    @Override
    protected Component cloneBody() {
        MultiMethodStructure that = (MultiMethodStructure)super.cloneBody();
        that.m_methodByConstant = null;
        return that;
    }

    public MethodStructure createMethod(boolean fFunction, Constants.Access access, Annotation[] annotations, Parameter[] aReturns, Parameter[] aParams, boolean fHasCode, boolean fUsesSuper) {
        int nFlags = Component.Format.METHOD.ordinal() | access.FLAGS | (fFunction ? 2048 : 0);
        int cReturns = aReturns.length;
        int cParams = aParams.length;
        if (annotations == null) {
            annotations = Annotation.NO_ANNOTATIONS;
        }
        TypeConstant[] aconstReturns = new TypeConstant[cReturns];
        TypeConstant[] aconstParams = new TypeConstant[cParams];
        for (int i = 0; i < cReturns; ++i) {
            Parameter param = aReturns[i];
            if (param.isConditionalReturn() && (i > 0 || !param.getType().isEcstasy("Boolean"))) {
                throw new IllegalArgumentException("only the first return value can be conditional, and it must be a boolean");
            }
            aconstReturns[i] = param.getType();
        }
        boolean fPastTypeParams = false;
        for (int i = 0; i < cParams; ++i) {
            Parameter param = aParams[i];
            if (param.isTypeParameter()) {
                if (fPastTypeParams) {
                    throw new IllegalArgumentException("type params must come first (" + i + ")");
                }
                if (!param.getType().isEcstasy("Type")) {
                    throw new IllegalArgumentException("type params must be of type \"Type\" (" + String.valueOf(param.getType()) + ")");
                }
            } else {
                fPastTypeParams = true;
            }
            aconstParams[i] = param.getType();
        }
        MethodConstant constId = this.getConstantPool().ensureMethodConstant(this.getIdentityConstant(), this.getName(), aconstParams, aconstReturns);
        MethodStructure struct = new MethodStructure(this, nFlags, constId, null, annotations, aReturns, aParams, fHasCode, fUsesSuper);
        return this.addChild(struct) ? struct : null;
    }

    public MethodStructure createLambda(TypeConstant[] atypeParams, String[] asParams) {
        assert ("->".equals(this.getName()));
        int nMax = 0;
        for (MethodConstant id : this.ensureMethodByConstantMap().keySet()) {
            nMax = Math.max(nMax, id.getLambdaIndex());
        }
        ConstantPool pool = this.getConstantPool();
        int cParams = asParams == null ? 0 : asParams.length;
        Parameter[] aParams = Parameter.NO_PARAMS;
        if (cParams > 0) {
            int cTypes;
            aParams = new Parameter[cParams];
            int n = cTypes = atypeParams == null ? 0 : atypeParams.length;
            assert (cTypes == 0 || cTypes == cParams);
            for (int i = 0; i < cParams; ++i) {
                TypeConstant type = i < cTypes ? atypeParams[i] : pool.typeObject();
                aParams[i] = new Parameter(pool, type, asParams[i], null, false, i, false);
            }
        }
        MethodConstant id = new MethodConstant(pool, this.getIdentityConstant(), nMax + 1);
        int nFlags = Component.Format.METHOD.ordinal() | 0x300 | 0x800;
        MethodStructure struct = new MethodStructure(this, nFlags, id, null, Annotation.NO_ANNOTATIONS, Parameter.NO_PARAMS, aParams, true, false);
        return this.addChild(struct) ? struct : null;
    }

    public Collection<MethodStructure> methods() {
        Collection<MethodStructure> methods = this.getMethodByConstantMap().values();
        assert ((methods = Collections.unmodifiableCollection(methods)) != null);
        return methods;
    }

    public Map<MethodConstant, MethodStructure> getMethodByConstantMap() {
        this.ensureChildren();
        Map<MethodConstant, MethodStructure> map = this.m_methodByConstant;
        return map == null ? Collections.emptyMap() : map;
    }

    protected Map<MethodConstant, MethodStructure> ensureMethodByConstantMap() {
        this.ensureChildren();
        Map<MethodConstant, MethodStructure> map = this.m_methodByConstant;
        if (map == null) {
            map = new ListMap<MethodConstant, MethodStructure>();
            Iterator<Component> siblings = this.siblings();
            while (siblings.hasNext()) {
                ((MultiMethodStructure)siblings.next()).m_methodByConstant = map;
            }
            assert (this.m_methodByConstant == map);
        }
        return map;
    }
}

