/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.xvm.asm.Argument;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.Register;
import org.xvm.asm.Scope;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.op.Assert;
import org.xvm.asm.op.AssertM;
import org.xvm.asm.op.AssertV;
import org.xvm.asm.op.Call_00;
import org.xvm.asm.op.Call_01;
import org.xvm.asm.op.Call_0N;
import org.xvm.asm.op.Call_0T;
import org.xvm.asm.op.Call_10;
import org.xvm.asm.op.Call_11;
import org.xvm.asm.op.Call_1N;
import org.xvm.asm.op.Call_1T;
import org.xvm.asm.op.Call_N0;
import org.xvm.asm.op.Call_N1;
import org.xvm.asm.op.Call_NN;
import org.xvm.asm.op.Call_NT;
import org.xvm.asm.op.Call_T0;
import org.xvm.asm.op.Call_T1;
import org.xvm.asm.op.Call_TN;
import org.xvm.asm.op.Call_TT;
import org.xvm.asm.op.CatchEnd;
import org.xvm.asm.op.CatchStart;
import org.xvm.asm.op.Cmp;
import org.xvm.asm.op.Construct_0;
import org.xvm.asm.op.Construct_1;
import org.xvm.asm.op.Construct_N;
import org.xvm.asm.op.Construct_T;
import org.xvm.asm.op.Enter;
import org.xvm.asm.op.Exit;
import org.xvm.asm.op.FBind;
import org.xvm.asm.op.FinallyEnd;
import org.xvm.asm.op.FinallyStart;
import org.xvm.asm.op.GP_Add;
import org.xvm.asm.op.GP_And;
import org.xvm.asm.op.GP_Compl;
import org.xvm.asm.op.GP_Div;
import org.xvm.asm.op.GP_DivRem;
import org.xvm.asm.op.GP_ERangeE;
import org.xvm.asm.op.GP_ERangeI;
import org.xvm.asm.op.GP_IRangeE;
import org.xvm.asm.op.GP_IRangeI;
import org.xvm.asm.op.GP_Mod;
import org.xvm.asm.op.GP_Mul;
import org.xvm.asm.op.GP_Neg;
import org.xvm.asm.op.GP_Or;
import org.xvm.asm.op.GP_Shl;
import org.xvm.asm.op.GP_Shr;
import org.xvm.asm.op.GP_ShrAll;
import org.xvm.asm.op.GP_Sub;
import org.xvm.asm.op.GP_Xor;
import org.xvm.asm.op.GuardAll;
import org.xvm.asm.op.GuardEnd;
import org.xvm.asm.op.GuardStart;
import org.xvm.asm.op.IIP_Add;
import org.xvm.asm.op.IIP_And;
import org.xvm.asm.op.IIP_Dec;
import org.xvm.asm.op.IIP_Div;
import org.xvm.asm.op.IIP_Inc;
import org.xvm.asm.op.IIP_Mod;
import org.xvm.asm.op.IIP_Mul;
import org.xvm.asm.op.IIP_Or;
import org.xvm.asm.op.IIP_PostDec;
import org.xvm.asm.op.IIP_PostInc;
import org.xvm.asm.op.IIP_PreDec;
import org.xvm.asm.op.IIP_PreInc;
import org.xvm.asm.op.IIP_Shl;
import org.xvm.asm.op.IIP_Shr;
import org.xvm.asm.op.IIP_ShrAll;
import org.xvm.asm.op.IIP_Sub;
import org.xvm.asm.op.IIP_Xor;
import org.xvm.asm.op.IP_Add;
import org.xvm.asm.op.IP_And;
import org.xvm.asm.op.IP_Dec;
import org.xvm.asm.op.IP_Div;
import org.xvm.asm.op.IP_Inc;
import org.xvm.asm.op.IP_Mod;
import org.xvm.asm.op.IP_Mul;
import org.xvm.asm.op.IP_Or;
import org.xvm.asm.op.IP_PostDec;
import org.xvm.asm.op.IP_PostInc;
import org.xvm.asm.op.IP_PreDec;
import org.xvm.asm.op.IP_PreInc;
import org.xvm.asm.op.IP_Shl;
import org.xvm.asm.op.IP_Shr;
import org.xvm.asm.op.IP_ShrAll;
import org.xvm.asm.op.IP_Sub;
import org.xvm.asm.op.IP_Xor;
import org.xvm.asm.op.I_Get;
import org.xvm.asm.op.I_Set;
import org.xvm.asm.op.Invoke_00;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.Invoke_0N;
import org.xvm.asm.op.Invoke_0T;
import org.xvm.asm.op.Invoke_10;
import org.xvm.asm.op.Invoke_11;
import org.xvm.asm.op.Invoke_1N;
import org.xvm.asm.op.Invoke_1T;
import org.xvm.asm.op.Invoke_N0;
import org.xvm.asm.op.Invoke_N1;
import org.xvm.asm.op.Invoke_NN;
import org.xvm.asm.op.Invoke_NT;
import org.xvm.asm.op.Invoke_T0;
import org.xvm.asm.op.Invoke_T1;
import org.xvm.asm.op.Invoke_TN;
import org.xvm.asm.op.Invoke_TT;
import org.xvm.asm.op.IsEq;
import org.xvm.asm.op.IsGt;
import org.xvm.asm.op.IsGte;
import org.xvm.asm.op.IsLt;
import org.xvm.asm.op.IsLte;
import org.xvm.asm.op.IsNType;
import org.xvm.asm.op.IsNot;
import org.xvm.asm.op.IsNotEq;
import org.xvm.asm.op.IsNotNull;
import org.xvm.asm.op.IsNotZero;
import org.xvm.asm.op.IsNull;
import org.xvm.asm.op.IsType;
import org.xvm.asm.op.IsZero;
import org.xvm.asm.op.Jump;
import org.xvm.asm.op.JumpCond;
import org.xvm.asm.op.JumpEq;
import org.xvm.asm.op.JumpFalse;
import org.xvm.asm.op.JumpGt;
import org.xvm.asm.op.JumpGte;
import org.xvm.asm.op.JumpInt;
import org.xvm.asm.op.JumpIsA;
import org.xvm.asm.op.JumpLt;
import org.xvm.asm.op.JumpLte;
import org.xvm.asm.op.JumpNCond;
import org.xvm.asm.op.JumpNFirst;
import org.xvm.asm.op.JumpNSample;
import org.xvm.asm.op.JumpNType;
import org.xvm.asm.op.JumpNotEq;
import org.xvm.asm.op.JumpNotNull;
import org.xvm.asm.op.JumpNotZero;
import org.xvm.asm.op.JumpNull;
import org.xvm.asm.op.JumpTrue;
import org.xvm.asm.op.JumpType;
import org.xvm.asm.op.JumpVal;
import org.xvm.asm.op.JumpVal_N;
import org.xvm.asm.op.JumpZero;
import org.xvm.asm.op.L_Get;
import org.xvm.asm.op.L_Set;
import org.xvm.asm.op.Label;
import org.xvm.asm.op.Loop;
import org.xvm.asm.op.LoopEnd;
import org.xvm.asm.op.MBind;
import org.xvm.asm.op.Move;
import org.xvm.asm.op.MoveCast;
import org.xvm.asm.op.MoveRef;
import org.xvm.asm.op.MoveThis;
import org.xvm.asm.op.MoveType;
import org.xvm.asm.op.MoveVar;
import org.xvm.asm.op.NewCG_0;
import org.xvm.asm.op.NewCG_1;
import org.xvm.asm.op.NewCG_N;
import org.xvm.asm.op.NewC_0;
import org.xvm.asm.op.NewC_1;
import org.xvm.asm.op.NewC_N;
import org.xvm.asm.op.NewG_0;
import org.xvm.asm.op.NewG_1;
import org.xvm.asm.op.NewG_N;
import org.xvm.asm.op.NewG_T;
import org.xvm.asm.op.NewV_0;
import org.xvm.asm.op.NewV_1;
import org.xvm.asm.op.NewV_N;
import org.xvm.asm.op.New_0;
import org.xvm.asm.op.New_1;
import org.xvm.asm.op.New_N;
import org.xvm.asm.op.New_T;
import org.xvm.asm.op.Nop;
import org.xvm.asm.op.PIP_Add;
import org.xvm.asm.op.PIP_Dec;
import org.xvm.asm.op.PIP_Inc;
import org.xvm.asm.op.PIP_PostDec;
import org.xvm.asm.op.PIP_PostInc;
import org.xvm.asm.op.PIP_PreDec;
import org.xvm.asm.op.PIP_PreInc;
import org.xvm.asm.op.PIP_Sub;
import org.xvm.asm.op.P_Get;
import org.xvm.asm.op.P_Ref;
import org.xvm.asm.op.P_Set;
import org.xvm.asm.op.P_Var;
import org.xvm.asm.op.Redundant;
import org.xvm.asm.op.Return_0;
import org.xvm.asm.op.Return_1;
import org.xvm.asm.op.Return_N;
import org.xvm.asm.op.Return_T;
import org.xvm.asm.op.SynInit;
import org.xvm.asm.op.Throw;
import org.xvm.asm.op.Var;
import org.xvm.asm.op.Var_C;
import org.xvm.asm.op.Var_CN;
import org.xvm.asm.op.Var_D;
import org.xvm.asm.op.Var_DN;
import org.xvm.asm.op.Var_I;
import org.xvm.asm.op.Var_IN;
import org.xvm.asm.op.Var_M;
import org.xvm.asm.op.Var_MN;
import org.xvm.asm.op.Var_N;
import org.xvm.asm.op.Var_S;
import org.xvm.asm.op.Var_SN;
import org.xvm.asm.op.Var_T;
import org.xvm.asm.op.Var_TN;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public abstract class Op {
    public static final int OP_NOP = 0;
    public static final int OP_LINE_1 = 1;
    public static final int OP_LINE_2 = 2;
    public static final int OP_LINE_3 = 3;
    public static final int OP_LINE_N = 4;
    public static final int OP_ENTER = 5;
    public static final int OP_EXIT = 6;
    public static final int OP_GUARD = 7;
    public static final int OP_GUARD_END = 8;
    public static final int OP_CATCH = 9;
    public static final int OP_CATCH_END = 10;
    public static final int OP_GUARD_ALL = 11;
    public static final int OP_FINALLY = 12;
    public static final int OP_FINALLY_END = 13;
    public static final int OP_THROW = 14;
    public static final int OP_RSVD_0F = 15;
    public static final int OP_CALL_00 = 16;
    public static final int OP_CALL_01 = 17;
    public static final int OP_CALL_0N = 18;
    public static final int OP_CALL_0T = 19;
    public static final int OP_CALL_10 = 20;
    public static final int OP_CALL_11 = 21;
    public static final int OP_CALL_1N = 22;
    public static final int OP_CALL_1T = 23;
    public static final int OP_CALL_N0 = 24;
    public static final int OP_CALL_N1 = 25;
    public static final int OP_CALL_NN = 26;
    public static final int OP_CALL_NT = 27;
    public static final int OP_CALL_T0 = 28;
    public static final int OP_CALL_T1 = 29;
    public static final int OP_CALL_TN = 30;
    public static final int OP_CALL_TT = 31;
    public static final int OP_NVOK_00 = 32;
    public static final int OP_NVOK_01 = 33;
    public static final int OP_NVOK_0N = 34;
    public static final int OP_NVOK_0T = 35;
    public static final int OP_NVOK_10 = 36;
    public static final int OP_NVOK_11 = 37;
    public static final int OP_NVOK_1N = 38;
    public static final int OP_NVOK_1T = 39;
    public static final int OP_NVOK_N0 = 40;
    public static final int OP_NVOK_N1 = 41;
    public static final int OP_NVOK_NN = 42;
    public static final int OP_NVOK_NT = 43;
    public static final int OP_NVOK_T0 = 44;
    public static final int OP_NVOK_T1 = 45;
    public static final int OP_NVOK_TN = 46;
    public static final int OP_NVOK_TT = 47;
    public static final int OP_MBIND = 48;
    public static final int OP_FBIND = 49;
    public static final int OP_RSVD_32 = 50;
    public static final int OP_SYN_INIT = 51;
    public static final int OP_CONSTR_0 = 52;
    public static final int OP_CONSTR_1 = 53;
    public static final int OP_CONSTR_N = 54;
    public static final int OP_CONSTR_T = 55;
    public static final int OP_NEW_0 = 56;
    public static final int OP_NEW_1 = 57;
    public static final int OP_NEW_N = 58;
    public static final int OP_NEW_T = 59;
    public static final int OP_NEWG_0 = 60;
    public static final int OP_NEWG_1 = 61;
    public static final int OP_NEWG_N = 62;
    public static final int OP_NEWG_T = 63;
    public static final int OP_NEWC_0 = 64;
    public static final int OP_NEWC_1 = 65;
    public static final int OP_NEWC_N = 66;
    public static final int OP_NEWC_T = 67;
    public static final int OP_NEWCG_0 = 68;
    public static final int OP_NEWCG_1 = 69;
    public static final int OP_NEWCG_N = 70;
    public static final int OP_NEWCG_T = 71;
    public static final int OP_NEWV_0 = 72;
    public static final int OP_NEWV_1 = 73;
    public static final int OP_NEWV_N = 74;
    public static final int OP_NEWV_T = 75;
    public static final int OP_RETURN_0 = 76;
    public static final int OP_RETURN_1 = 77;
    public static final int OP_RETURN_N = 78;
    public static final int OP_RETURN_T = 79;
    public static final int OP_VAR = 80;
    public static final int OP_VAR_I = 81;
    public static final int OP_VAR_N = 82;
    public static final int OP_VAR_IN = 83;
    public static final int OP_VAR_D = 84;
    public static final int OP_VAR_DN = 85;
    public static final int OP_VAR_C = 86;
    public static final int OP_VAR_CN = 87;
    public static final int OP_VAR_S = 88;
    public static final int OP_VAR_SN = 89;
    public static final int OP_VAR_T = 90;
    public static final int OP_VAR_TN = 91;
    public static final int OP_VAR_M = 92;
    public static final int OP_VAR_MN = 93;
    public static final int OP_RSVD_5E = 94;
    public static final int OP_RSVD_5F = 95;
    public static final int OP_MOV = 96;
    public static final int OP_MOV_VAR = 97;
    public static final int OP_MOV_REF = 98;
    public static final int OP_MOV_THIS = 99;
    public static final int OP_MOV_THIS_A = 100;
    public static final int OP_MOV_TYPE = 101;
    public static final int OP_CAST = 102;
    public static final int OP_RSVD_67 = 103;
    public static final int OP_CMP = 104;
    public static final int OP_IS_ZERO = 105;
    public static final int OP_IS_NZERO = 106;
    public static final int OP_IS_NULL = 107;
    public static final int OP_IS_NNULL = 108;
    public static final int OP_IS_EQ = 109;
    public static final int OP_IS_NEQ = 110;
    public static final int OP_IS_LT = 111;
    public static final int OP_IS_LTE = 112;
    public static final int OP_IS_GT = 113;
    public static final int OP_IS_GTE = 114;
    public static final int OP_IS_NOT = 115;
    public static final int OP_IS_TYPE = 116;
    public static final int OP_IS_NTYPE = 117;
    public static final int OP_RSVD_76 = 118;
    public static final int OP_LOOP = 119;
    public static final int OP_LOOP_END = 120;
    public static final int OP_JMP = 121;
    public static final int OP_JMP_TRUE = 122;
    public static final int OP_JMP_FALSE = 123;
    public static final int OP_JMP_ZERO = 124;
    public static final int OP_JMP_NZERO = 125;
    public static final int OP_JMP_NULL = 126;
    public static final int OP_JMP_NNULL = 127;
    public static final int OP_JMP_EQ = 128;
    public static final int OP_JMP_NEQ = 129;
    public static final int OP_JMP_LT = 130;
    public static final int OP_JMP_LTE = 131;
    public static final int OP_JMP_GT = 132;
    public static final int OP_JMP_GTE = 133;
    public static final int OP_JMP_TYPE = 134;
    public static final int OP_JMP_NTYPE = 135;
    public static final int OP_JMP_COND = 136;
    public static final int OP_JMP_NCOND = 137;
    public static final int OP_JMP_NFIRST = 138;
    public static final int OP_JMP_NSAMPLE = 139;
    public static final int OP_JMP_INT = 140;
    public static final int OP_JMP_VAL = 141;
    public static final int OP_JMP_ISA = 142;
    public static final int OP_JMP_VAL_N = 143;
    public static final int OP_ASSERT = 144;
    public static final int OP_ASSERT_M = 145;
    public static final int OP_ASSERT_V = 146;
    public static final int OP_GP_ADD = 147;
    public static final int OP_GP_SUB = 148;
    public static final int OP_GP_MUL = 149;
    public static final int OP_GP_DIV = 150;
    public static final int OP_GP_MOD = 151;
    public static final int OP_GP_SHL = 152;
    public static final int OP_GP_SHR = 153;
    public static final int OP_GP_USHR = 154;
    public static final int OP_GP_AND = 155;
    public static final int OP_GP_OR = 156;
    public static final int OP_GP_XOR = 157;
    public static final int OP_GP_DIVREM = 158;
    public static final int OP_GP_IRANGEI = 159;
    public static final int OP_GP_ERANGEI = 160;
    public static final int OP_GP_IRANGEE = 161;
    public static final int OP_GP_ERANGEE = 162;
    public static final int OP_GP_NEG = 163;
    public static final int OP_GP_COMPL = 164;
    public static final int OP_L_GET = 165;
    public static final int OP_L_SET = 166;
    public static final int OP_P_GET = 167;
    public static final int OP_P_SET = 168;
    public static final int OP_P_VAR = 169;
    public static final int OP_P_REF = 170;
    public static final int OP_IP_INC = 171;
    public static final int OP_IP_DEC = 172;
    public static final int OP_IP_INCA = 173;
    public static final int OP_IP_DECA = 174;
    public static final int OP_IP_INCB = 175;
    public static final int OP_IP_DECB = 176;
    public static final int OP_IP_ADD = 177;
    public static final int OP_IP_SUB = 178;
    public static final int OP_IP_MUL = 179;
    public static final int OP_IP_DIV = 180;
    public static final int OP_IP_MOD = 181;
    public static final int OP_IP_SHL = 182;
    public static final int OP_IP_SHR = 183;
    public static final int OP_IP_USHR = 184;
    public static final int OP_IP_AND = 185;
    public static final int OP_IP_OR = 186;
    public static final int OP_IP_XOR = 187;
    public static final int OP_PIP_INC = 188;
    public static final int OP_PIP_DEC = 189;
    public static final int OP_PIP_INCA = 190;
    public static final int OP_PIP_DECA = 191;
    public static final int OP_PIP_INCB = 192;
    public static final int OP_PIP_DECB = 193;
    public static final int OP_PIP_ADD = 194;
    public static final int OP_PIP_SUB = 195;
    public static final int OP_PIP_MUL = 196;
    public static final int OP_PIP_DIV = 197;
    public static final int OP_PIP_MOD = 198;
    public static final int OP_PIP_SHL = 199;
    public static final int OP_PIP_SHR = 200;
    public static final int OP_PIP_USHR = 201;
    public static final int OP_PIP_AND = 202;
    public static final int OP_PIP_OR = 203;
    public static final int OP_PIP_XOR = 204;
    public static final int OP_I_GET = 205;
    public static final int OP_I_SET = 206;
    public static final int OP_IIP_INC = 207;
    public static final int OP_IIP_DEC = 208;
    public static final int OP_IIP_INCA = 209;
    public static final int OP_IIP_DECA = 210;
    public static final int OP_IIP_INCB = 211;
    public static final int OP_IIP_DECB = 212;
    public static final int OP_IIP_ADD = 213;
    public static final int OP_IIP_SUB = 214;
    public static final int OP_IIP_MUL = 215;
    public static final int OP_IIP_DIV = 216;
    public static final int OP_IIP_MOD = 217;
    public static final int OP_IIP_SHL = 218;
    public static final int OP_IIP_SHR = 219;
    public static final int OP_IIP_USHR = 220;
    public static final int OP_IIP_AND = 221;
    public static final int OP_IIP_OR = 222;
    public static final int OP_IIP_XOR = 223;
    public static final int OP_M_GET = 224;
    public static final int OP_M_SET = 225;
    public static final int OP_M_VAR = 226;
    public static final int OP_M_REF = 227;
    public static final int OP_MIP_INC = 228;
    public static final int OP_MIP_DEC = 229;
    public static final int OP_MIP_INCA = 230;
    public static final int OP_MIP_DECA = 231;
    public static final int OP_MIP_INCB = 232;
    public static final int OP_MIP_DECB = 233;
    public static final int OP_MIP_ADD = 234;
    public static final int OP_MIP_SUB = 235;
    public static final int OP_MIP_MUL = 236;
    public static final int OP_MIP_DIV = 237;
    public static final int OP_MIP_MOD = 238;
    public static final int OP_MIP_SHL = 239;
    public static final int OP_MIP_SHR = 240;
    public static final int OP_MIP_USHR = 241;
    public static final int OP_MIP_AND = 242;
    public static final int OP_MIP_OR = 243;
    public static final int OP_MIP_XOR = 244;
    public static final int OP_RSVD_F5 = 245;
    public static final int OP_RSVD_F6 = 246;
    public static final int OP_RSVD_F7 = 247;
    public static final int OP_RSVD_F8 = 248;
    public static final int OP_RSVD_F9 = 249;
    public static final int OP_RSVD_FA = 250;
    public static final int OP_RSVD_FB = 251;
    public static final int OP_RSVD_FC = 252;
    public static final int OP_RSVD_FD = 253;
    public static final int OP_RSVD_FE = 254;
    public static final int OP_RSVD_FF = 255;
    public static final int A_STACK = -1;
    public static final int A_IGNORE = -2;
    public static final int A_IGNORE_ASYNC = -3;
    public static final int A_DEFAULT = -4;
    public static final int A_THIS = -5;
    public static final int A_TARGET = -6;
    public static final int A_PUBLIC = -7;
    public static final int A_PROTECTED = -8;
    public static final int A_PRIVATE = -9;
    public static final int A_STRUCT = -10;
    public static final int A_CLASS = -11;
    public static final int A_SERVICE = -12;
    public static final int A_SUPER = -13;
    public static final int A_MULTI = -14;
    public static final int A_TUPLE = -15;
    public static final int A_LABEL = -16;
    public static final int CONSTANT_OFFSET = -16;
    public static final int R_NEXT = -1;
    public static final int R_RETURN = -2;
    public static final int R_EXCEPTION = -3;
    public static final int R_RETURN_EXCEPTION = -4;
    public static final int R_CALL = -5;
    public static final int R_RETURN_CALL = -6;
    public static final int R_REPEAT = -7;
    public static final int R_BLOCK = -8;
    public static final int R_PAUSE = -9;
    public static final int R_RESET = -10;
    public static final Op[] NO_OPS = new Op[0];
    public static int[] NO_ARGS = new int[0];
    private static final long REACHABLE_BIT = Long.MIN_VALUE;
    private static final long NECESSARY_BIT = 0x4000000000000000L;
    private static final long REDUNDANT_BIT = 0x2000000000000000L;
    private static final long RESERVED_BITS = 0x1FFFF00000000000L;
    private static final long GUARD_ALL_DEPTH_BITS = 0xFF000000000L;
    private static final long GUARD_ALL_DEPTH_SHIFT = 36L;
    private static final long GUARD_DEPTH_BITS = 0xFF0000000L;
    private static final long GUARD_DEPTH_SHIFT = 28L;
    private static final long SCOPE_DEPTH_BITS = 0xFF00000L;
    private static final long SCOPE_DEPTH_SHIFT = 20L;
    private static final long POSITION_BITS = 1048575L;
    private long m_lStruct;

    public void resolveCode(MethodStructure.Code code, Constant[] aconst) {
    }

    public void write(DataOutput out, ConstantRegistry registry) throws IOException {
        out.writeByte(this.getOpCode());
    }

    public Op ensureOp() {
        return this;
    }

    public int getOpCode() {
        throw new UnsupportedOperationException();
    }

    public abstract int process(Frame var1, int var2);

    public void initInfo(int nAddress, int nDepth, int nGuardDepth, int nGuardAllDepth) {
        assert (nAddress >= 0);
        assert ((long)nAddress <= 1048575L);
        assert (nDepth > 0);
        assert ((long)nDepth <= 0xFF00000L >>> 20);
        assert ((long)nGuardDepth <= 0xFF0000000L >>> 28);
        assert ((long)nGuardAllDepth <= 0xFF000000000L >>> 36);
        this.m_lStruct = (long)nAddress | (long)nDepth << 20 | (long)nGuardDepth << 28 | (long)nGuardAllDepth << 36;
    }

    public int getAddress() {
        return (int)(this.m_lStruct & 0xFFFFFL);
    }

    public int getDepth() {
        return (int)((this.m_lStruct & 0xFF00000L) >>> 20);
    }

    public int getGuardDepth() {
        return (int)((this.m_lStruct & 0xFF0000000L) >>> 28);
    }

    public int getGuardAllDepth() {
        return (int)((this.m_lStruct & 0xFF000000000L) >>> 36);
    }

    public boolean isReachable() {
        return (this.m_lStruct & Long.MIN_VALUE) != 0L;
    }

    public void markReachable(Op[] aop) {
        this.m_lStruct |= Long.MIN_VALUE;
    }

    public boolean isNecessary() {
        return (this.m_lStruct & 0x4000000000000000L) != 0L;
    }

    public void markNecessary() {
        this.m_lStruct |= 0x4000000000000000L;
    }

    public boolean isDiscardable() {
        return !this.isReachable() && !this.isNecessary();
    }

    public boolean isRedundant() {
        return (this.m_lStruct & 0x2000000000000000L) != 0L;
    }

    public void markRedundant() {
        this.m_lStruct |= 0x2000000000000000L;
    }

    public boolean checkRedundant(Op[] aop) {
        return false;
    }

    public Op findDestinationOp(Op[] aop, int ofJmp) {
        Op opPrefix;
        int iPC = this.getAddress() + ofJmp;
        while (true) {
            Op opActual;
            if ((opActual = (opPrefix = aop[iPC]).ensureOp()) == this) {
                // empty if block
            }
            if (!(opActual instanceof Jump)) break;
            Jump opJump = (Jump)opActual;
            iPC += opJump.getRelativeAddress();
        }
        if (!(opPrefix instanceof Label)) {
            aop[iPC] = opPrefix = new Label(iPC).append(opPrefix);
        }
        return opPrefix;
    }

    public Op findCorrespondingOp(Op[] aop, int nThat) {
        return this.findFirstUnmatchedOp(aop, this.getOpCode(), nThat);
    }

    public Op findFirstUnmatchedOp(Op[] aop, int nOpen, int nClose) {
        Op op;
        int iPC = this.getAddress();
        int cReq = 1;
        while (true) {
            int nOp;
            if ((nOp = (op = aop[++iPC]).ensureOp().getOpCode()) == nOpen) {
                ++cReq;
                continue;
            }
            if (nOp == nClose && --cReq == 0) break;
        }
        return op;
    }

    public Prefix convertToPrefix() {
        assert (this.isRedundant());
        return new Redundant(this);
    }

    public void resetSimulation() {
    }

    public void simulate(Scope scope) {
    }

    public boolean branches(Op[] aop, List<Integer> list) {
        return false;
    }

    public boolean advances() {
        return true;
    }

    public void registerConstants(ConstantRegistry registry) {
    }

    public void resolveAddresses(Op[] aop) {
    }

    protected int adjustRelativeAddress(Op[] aop, int of) {
        int nAddr = this.getAddress() + of;
        if (nAddr >= aop.length) {
            int nAdjust = nAddr - aop.length + 1;
            of -= nAdjust;
            nAddr -= nAdjust;
        }
        if (aop[nAddr - 1] instanceof Nop) {
            --of;
        }
        return of;
    }

    protected int calcRelativeAddress(Op opDest) {
        return opDest.getAddress() - this.getAddress();
    }

    public boolean contains(Op that) {
        return this == that;
    }

    public boolean usesSuper() {
        return false;
    }

    public boolean isEnter() {
        return false;
    }

    public boolean isExit() {
        return false;
    }

    protected int calcExits(Op opDest) {
        return Math.abs(opDest.getDepth() - this.getDepth() - (this.isEnter() ? 1 : 0) + (this.isExit() ? 1 : 0));
    }

    public void build(BuildContext bctx, CodeBuilder code) {
        throw new UnsupportedOperationException(this.toString());
    }

    public String toString() {
        return Op.toName(this.getOpCode());
    }

    protected static boolean isConstant(Argument arg) {
        return arg instanceof Constant;
    }

    public static void resetRegister(Argument arg) {
        if (arg instanceof Register) {
            Register reg = (Register)arg;
            reg.resetIndex();
        }
    }

    public static void resetRegisters(Argument[] aArg) {
        if (aArg != null) {
            for (Argument arg : aArg) {
                if (!(arg instanceof Register)) continue;
                Register reg = (Register)arg;
                reg.resetIndex();
            }
        }
    }

    public static void checkNextRegister(Scope scope, Argument arg, int nArg) {
        Register reg;
        if (arg == null) {
            scope.ensureVar(nArg);
        } else if (arg instanceof Register && (reg = (Register)arg).isUnknown()) {
            reg.assignIndex(scope.allocVar());
        }
    }

    public static void checkNextRegisters(Scope scope, Argument[] aArg, int[] anArg) {
        if (aArg == null) {
            for (int nArg : anArg) {
                scope.ensureVar(nArg);
            }
        } else {
            for (Argument arg : aArg) {
                Register reg;
                if (!(arg instanceof Register) || !(reg = (Register)arg).isUnknown()) continue;
                reg.assignIndex(scope.allocVar());
            }
        }
    }

    protected static boolean isReadable(Argument arg) {
        Register reg;
        return !(arg instanceof Register) || (reg = (Register)arg).isReadable();
    }

    protected static boolean isWritable(Argument arg) {
        Register reg;
        return arg instanceof Register && (reg = (Register)arg).isWritable();
    }

    protected static Argument registerArgument(Argument arg, ConstantRegistry registry) {
        return arg == null ? null : arg.registerConstants(registry);
    }

    protected static void registerArguments(Argument[] aArg, ConstantRegistry registry) {
        if (aArg != null) {
            int c = aArg.length;
            for (int i = 0; i < c; ++i) {
                aArg[i] = Op.registerArgument(aArg[i], registry);
            }
        }
    }

    protected static int encodeArgument(Argument arg, ConstantRegistry registry) {
        return arg instanceof Constant ? -16 - registry.indexOf((Constant)arg) : ((Register)arg).getIndex();
    }

    protected static int[] encodeArguments(Argument[] aArg, ConstantRegistry registry) {
        int c = aArg.length;
        int[] anArg = new int[c];
        for (int i = 0; i < c; ++i) {
            anArg[i] = Op.encodeArgument(aArg[i], registry);
        }
        return anArg;
    }

    public static boolean isDeferred(ObjectHandle handle) {
        return handle instanceof ObjectHandle.DeferredCallHandle;
    }

    public static boolean anyDeferred(ObjectHandle[] aHandle) {
        for (ObjectHandle h : aHandle) {
            if (h == null) {
                return false;
            }
            if (!(h instanceof ObjectHandle.DeferredCallHandle)) continue;
            return true;
        }
        return false;
    }

    protected static int jump(Frame frame, int iPCTo, int cExits) {
        while (cExits-- > 0) {
            frame.exitScope();
        }
        return iPCTo;
    }

    protected static int convertId(int id) {
        assert (id < 0);
        return -16 - id;
    }

    public static TypeConstant selectCommonType(TypeConstant type1, TypeConstant type2, ErrorListener errs) {
        if (type1 == null && type2 == null) {
            return null;
        }
        if (type1 != null && type2 != null) {
            if (type2.isAssignableTo(type1)) {
                return type1;
            }
            if (type1.isAssignableTo(type2)) {
                return type2;
            }
            if (type1.isTypeOfType() && type2.isTypeOfType()) {
                return type1.getConstantPool().typeType();
            }
            TypeInfo info1 = type1.ensureTypeInfo(errs);
            if (info1.getFormat() == Component.Format.ENUMVALUE && type2.isAssignableTo(info1.getExtends())) {
                return info1.getExtends();
            }
            TypeInfo info2 = type2.ensureTypeInfo(errs);
            if (info2.getFormat() == Component.Format.ENUMVALUE && type1.isAssignableTo(info2.getExtends())) {
                return info2.getExtends();
            }
            return null;
        }
        TypeConstant typeResult = type1 == null ? type2 : type1;
        TypeInfo typeinfo = typeResult.ensureTypeInfo(errs);
        return typeinfo.getFormat() == Component.Format.ENUMVALUE ? typeinfo.getExtends() : typeResult;
    }

    public static Op[] readOps(DataInput in, Constant[] aconst) throws IOException {
        int cOps = Handy.readMagnitude(in);
        Op[] aop = new Op[cOps];
        for (int i = 0; i < cOps; ++i) {
            aop[i] = Op.instantiate(in.readUnsignedByte(), in, aconst);
        }
        return aop;
    }

    public static Op instantiate(int nOp, DataInput in, Constant[] aconst) throws IOException {
        switch (nOp) {
            case 0: {
                return new Nop();
            }
            case 1: {
                return new Nop(1);
            }
            case 2: {
                return new Nop(2);
            }
            case 3: {
                return new Nop(3);
            }
            case 4: {
                return new Nop(in, aconst);
            }
            case 5: {
                return new Enter();
            }
            case 6: {
                return new Exit();
            }
            case 7: {
                return new GuardStart(in, aconst);
            }
            case 8: {
                return new GuardEnd(in, aconst);
            }
            case 9: {
                return new CatchStart(in, aconst);
            }
            case 10: {
                return new CatchEnd(in, aconst);
            }
            case 11: {
                return new GuardAll(in, aconst);
            }
            case 12: {
                return new FinallyStart(in, aconst);
            }
            case 13: {
                return new FinallyEnd();
            }
            case 14: {
                return new Throw(in, aconst);
            }
            case 144: {
                return new Assert(in, aconst);
            }
            case 145: {
                return new AssertM(in, aconst);
            }
            case 146: {
                return new AssertV(in, aconst);
            }
            case 76: {
                return new Return_0(in, aconst);
            }
            case 77: {
                return new Return_1(in, aconst);
            }
            case 78: {
                return new Return_N(in, aconst);
            }
            case 79: {
                return new Return_T(in, aconst);
            }
            case 48: {
                return new MBind(in, aconst);
            }
            case 49: {
                return new FBind(in, aconst);
            }
            case 119: {
                return new Loop();
            }
            case 120: {
                return new LoopEnd();
            }
            case 121: {
                return new Jump(in, aconst);
            }
            case 122: {
                return new JumpTrue(in, aconst);
            }
            case 123: {
                return new JumpFalse(in, aconst);
            }
            case 124: {
                return new JumpZero(in, aconst);
            }
            case 125: {
                return new JumpNotZero(in, aconst);
            }
            case 126: {
                return new JumpNull(in, aconst);
            }
            case 127: {
                return new JumpNotNull(in, aconst);
            }
            case 128: {
                return new JumpEq(in, aconst);
            }
            case 129: {
                return new JumpNotEq(in, aconst);
            }
            case 130: {
                return new JumpLt(in, aconst);
            }
            case 131: {
                return new JumpLte(in, aconst);
            }
            case 132: {
                return new JumpGt(in, aconst);
            }
            case 133: {
                return new JumpGte(in, aconst);
            }
            case 134: {
                return new JumpType(in, aconst);
            }
            case 135: {
                return new JumpNType(in, aconst);
            }
            case 136: {
                return new JumpCond(in, aconst);
            }
            case 137: {
                return new JumpNCond(in, aconst);
            }
            case 138: {
                return new JumpNFirst(in, aconst);
            }
            case 139: {
                return new JumpNSample(in, aconst);
            }
            case 140: {
                return new JumpInt(in, aconst);
            }
            case 141: {
                return new JumpVal(in, aconst);
            }
            case 142: {
                return new JumpIsA(in, aconst);
            }
            case 143: {
                return new JumpVal_N(in, aconst);
            }
            case 105: {
                return new IsZero(in, aconst);
            }
            case 106: {
                return new IsNotZero(in, aconst);
            }
            case 107: {
                return new IsNull(in, aconst);
            }
            case 108: {
                return new IsNotNull(in, aconst);
            }
            case 109: {
                return new IsEq(in, aconst);
            }
            case 110: {
                return new IsNotEq(in, aconst);
            }
            case 111: {
                return new IsLt(in, aconst);
            }
            case 112: {
                return new IsLte(in, aconst);
            }
            case 113: {
                return new IsGt(in, aconst);
            }
            case 114: {
                return new IsGte(in, aconst);
            }
            case 115: {
                return new IsNot(in, aconst);
            }
            case 116: {
                return new IsType(in, aconst);
            }
            case 117: {
                return new IsNType(in, aconst);
            }
            case 104: {
                return new Cmp(in, aconst);
            }
            case 80: {
                return new Var(in, aconst);
            }
            case 81: {
                return new Var_I(in, aconst);
            }
            case 82: {
                return new Var_N(in, aconst);
            }
            case 83: {
                return new Var_IN(in, aconst);
            }
            case 84: {
                return new Var_D(in, aconst);
            }
            case 85: {
                return new Var_DN(in, aconst);
            }
            case 86: {
                return new Var_C(in, aconst);
            }
            case 87: {
                return new Var_CN(in, aconst);
            }
            case 88: {
                return new Var_S(in, aconst);
            }
            case 89: {
                return new Var_SN(in, aconst);
            }
            case 90: {
                return new Var_T(in, aconst);
            }
            case 91: {
                return new Var_TN(in, aconst);
            }
            case 92: {
                return new Var_M(in, aconst);
            }
            case 93: {
                return new Var_MN(in, aconst);
            }
            case 96: {
                return new Move(in, aconst);
            }
            case 97: {
                return new MoveVar(in, aconst);
            }
            case 98: {
                return new MoveRef(in, aconst);
            }
            case 99: 
            case 100: {
                return new MoveThis(in, aconst, nOp);
            }
            case 101: {
                return new MoveType(in, aconst);
            }
            case 102: {
                return new MoveCast(in, aconst);
            }
            case 147: {
                return new GP_Add(in, aconst);
            }
            case 148: {
                return new GP_Sub(in, aconst);
            }
            case 149: {
                return new GP_Mul(in, aconst);
            }
            case 150: {
                return new GP_Div(in, aconst);
            }
            case 151: {
                return new GP_Mod(in, aconst);
            }
            case 152: {
                return new GP_Shl(in, aconst);
            }
            case 153: {
                return new GP_Shr(in, aconst);
            }
            case 154: {
                return new GP_ShrAll(in, aconst);
            }
            case 155: {
                return new GP_And(in, aconst);
            }
            case 156: {
                return new GP_Or(in, aconst);
            }
            case 157: {
                return new GP_Xor(in, aconst);
            }
            case 158: {
                return new GP_DivRem(in, aconst);
            }
            case 159: {
                return new GP_IRangeI(in, aconst);
            }
            case 160: {
                return new GP_ERangeI(in, aconst);
            }
            case 161: {
                return new GP_IRangeE(in, aconst);
            }
            case 162: {
                return new GP_ERangeE(in, aconst);
            }
            case 163: {
                return new GP_Neg(in, aconst);
            }
            case 164: {
                return new GP_Compl(in, aconst);
            }
            case 171: {
                return new IP_Inc(in, aconst);
            }
            case 172: {
                return new IP_Dec(in, aconst);
            }
            case 173: {
                return new IP_PostInc(in, aconst);
            }
            case 174: {
                return new IP_PostDec(in, aconst);
            }
            case 175: {
                return new IP_PreInc(in, aconst);
            }
            case 176: {
                return new IP_PreDec(in, aconst);
            }
            case 177: {
                return new IP_Add(in, aconst);
            }
            case 178: {
                return new IP_Sub(in, aconst);
            }
            case 179: {
                return new IP_Mul(in, aconst);
            }
            case 180: {
                return new IP_Div(in, aconst);
            }
            case 181: {
                return new IP_Mod(in, aconst);
            }
            case 182: {
                return new IP_Shl(in, aconst);
            }
            case 183: {
                return new IP_Shr(in, aconst);
            }
            case 184: {
                return new IP_ShrAll(in, aconst);
            }
            case 185: {
                return new IP_And(in, aconst);
            }
            case 186: {
                return new IP_Or(in, aconst);
            }
            case 187: {
                return new IP_Xor(in, aconst);
            }
            case 165: {
                return new L_Get(in, aconst);
            }
            case 166: {
                return new L_Set(in, aconst);
            }
            case 167: {
                return new P_Get(in, aconst);
            }
            case 168: {
                return new P_Set(in, aconst);
            }
            case 169: {
                return new P_Var(in, aconst);
            }
            case 170: {
                return new P_Ref(in, aconst);
            }
            case 188: {
                return new PIP_Inc(in, aconst);
            }
            case 189: {
                return new PIP_Dec(in, aconst);
            }
            case 190: {
                return new PIP_PostInc(in, aconst);
            }
            case 191: {
                return new PIP_PostDec(in, aconst);
            }
            case 192: {
                return new PIP_PreInc(in, aconst);
            }
            case 193: {
                return new PIP_PreDec(in, aconst);
            }
            case 194: {
                return new PIP_Add(in, aconst);
            }
            case 195: {
                return new PIP_Sub(in, aconst);
            }
            case 205: {
                return new I_Get(in, aconst);
            }
            case 206: {
                return new I_Set(in, aconst);
            }
            case 207: {
                return new IIP_Inc(in, aconst);
            }
            case 208: {
                return new IIP_Dec(in, aconst);
            }
            case 209: {
                return new IIP_PostInc(in, aconst);
            }
            case 211: {
                return new IIP_PreInc(in, aconst);
            }
            case 210: {
                return new IIP_PostDec(in, aconst);
            }
            case 212: {
                return new IIP_PreDec(in, aconst);
            }
            case 213: {
                return new IIP_Add(in, aconst);
            }
            case 214: {
                return new IIP_Sub(in, aconst);
            }
            case 215: {
                return new IIP_Mul(in, aconst);
            }
            case 216: {
                return new IIP_Div(in, aconst);
            }
            case 217: {
                return new IIP_Mod(in, aconst);
            }
            case 218: {
                return new IIP_Shl(in, aconst);
            }
            case 219: {
                return new IIP_Shr(in, aconst);
            }
            case 220: {
                return new IIP_ShrAll(in, aconst);
            }
            case 221: {
                return new IIP_And(in, aconst);
            }
            case 222: {
                return new IIP_Or(in, aconst);
            }
            case 223: {
                return new IIP_Xor(in, aconst);
            }
            case 16: {
                return new Call_00(in, aconst);
            }
            case 17: {
                return new Call_01(in, aconst);
            }
            case 18: {
                return new Call_0N(in, aconst);
            }
            case 19: {
                return new Call_0T(in, aconst);
            }
            case 20: {
                return new Call_10(in, aconst);
            }
            case 21: {
                return new Call_11(in, aconst);
            }
            case 22: {
                return new Call_1N(in, aconst);
            }
            case 23: {
                return new Call_1T(in, aconst);
            }
            case 24: {
                return new Call_N0(in, aconst);
            }
            case 25: {
                return new Call_N1(in, aconst);
            }
            case 26: {
                return new Call_NN(in, aconst);
            }
            case 27: {
                return new Call_NT(in, aconst);
            }
            case 28: {
                return new Call_T0(in, aconst);
            }
            case 29: {
                return new Call_T1(in, aconst);
            }
            case 30: {
                return new Call_TN(in, aconst);
            }
            case 31: {
                return new Call_TT(in, aconst);
            }
            case 32: {
                return new Invoke_00(in, aconst);
            }
            case 33: {
                return new Invoke_01(in, aconst);
            }
            case 34: {
                return new Invoke_0N(in, aconst);
            }
            case 35: {
                return new Invoke_0T(in, aconst);
            }
            case 36: {
                return new Invoke_10(in, aconst);
            }
            case 37: {
                return new Invoke_11(in, aconst);
            }
            case 38: {
                return new Invoke_1N(in, aconst);
            }
            case 39: {
                return new Invoke_1T(in, aconst);
            }
            case 40: {
                return new Invoke_N0(in, aconst);
            }
            case 41: {
                return new Invoke_N1(in, aconst);
            }
            case 42: {
                return new Invoke_NN(in, aconst);
            }
            case 43: {
                return new Invoke_NT(in, aconst);
            }
            case 44: {
                return new Invoke_T0(in, aconst);
            }
            case 45: {
                return new Invoke_T1(in, aconst);
            }
            case 46: {
                return new Invoke_TN(in, aconst);
            }
            case 47: {
                return new Invoke_TT(in, aconst);
            }
            case 56: {
                return new New_0(in, aconst);
            }
            case 57: {
                return new New_1(in, aconst);
            }
            case 58: {
                return new New_N(in, aconst);
            }
            case 59: {
                return new New_T(in, aconst);
            }
            case 60: {
                return new NewG_0(in, aconst);
            }
            case 61: {
                return new NewG_1(in, aconst);
            }
            case 62: {
                return new NewG_N(in, aconst);
            }
            case 63: {
                return new NewG_T(in, aconst);
            }
            case 64: {
                return new NewC_0(in, aconst);
            }
            case 65: {
                return new NewC_1(in, aconst);
            }
            case 66: {
                return new NewC_N(in, aconst);
            }
            case 68: {
                return new NewCG_0(in, aconst);
            }
            case 69: {
                return new NewCG_1(in, aconst);
            }
            case 70: {
                return new NewCG_N(in, aconst);
            }
            case 72: {
                return new NewV_0(in, aconst);
            }
            case 73: {
                return new NewV_1(in, aconst);
            }
            case 74: {
                return new NewV_N(in, aconst);
            }
            case 52: {
                return new Construct_0(in, aconst);
            }
            case 53: {
                return new Construct_1(in, aconst);
            }
            case 54: {
                return new Construct_N(in, aconst);
            }
            case 55: {
                return new Construct_T(in, aconst);
            }
            case 51: {
                return new SynInit();
            }
        }
        throw new IllegalStateException("op=" + Handy.byteToHexString(nOp));
    }

    public static String toName(int nOp) {
        switch (nOp) {
            case 0: {
                return "NOP";
            }
            case 1: {
                return "LINE_1";
            }
            case 2: {
                return "LINE_2";
            }
            case 3: {
                return "LINE_3";
            }
            case 4: {
                return "LINE_N";
            }
            case 5: {
                return "ENTER";
            }
            case 6: {
                return "EXIT";
            }
            case 7: {
                return "GUARD";
            }
            case 8: {
                return "GUARD_E";
            }
            case 9: {
                return "CATCH";
            }
            case 10: {
                return "CATCH_E";
            }
            case 11: {
                return "GUARD_ALL";
            }
            case 12: {
                return "FINALLY";
            }
            case 13: {
                return "FINALLY_E";
            }
            case 14: {
                return "THROW";
            }
            case 144: {
                return "ASSERT";
            }
            case 145: {
                return "ASSERT_M";
            }
            case 146: {
                return "ASSERT_V";
            }
            case 76: {
                return "RETURN_0";
            }
            case 77: {
                return "RETURN_1";
            }
            case 78: {
                return "RETURN_N";
            }
            case 79: {
                return "RETURN_T";
            }
            case 48: {
                return "BIND_M";
            }
            case 49: {
                return "BIND_F";
            }
            case 119: {
                return "LOOP";
            }
            case 120: {
                return "LOOP_END";
            }
            case 121: {
                return "JMP";
            }
            case 122: {
                return "JMP_TRUE";
            }
            case 123: {
                return "JMP_FALSE";
            }
            case 124: {
                return "JMP_ZERO";
            }
            case 125: {
                return "JMP_NZERO";
            }
            case 126: {
                return "JMP_NULL";
            }
            case 127: {
                return "JMP_NNULL";
            }
            case 128: {
                return "JMP_EQ";
            }
            case 129: {
                return "JMP_NEQ";
            }
            case 130: {
                return "JMP_LT";
            }
            case 131: {
                return "JMP_LTE";
            }
            case 132: {
                return "JMP_GT";
            }
            case 133: {
                return "JMP_GTE";
            }
            case 134: {
                return "JMP_TYPE";
            }
            case 135: {
                return "JMP_NTYPE";
            }
            case 136: {
                return "JMP_COND";
            }
            case 137: {
                return "JMP_NCOND";
            }
            case 138: {
                return "JMP_NFIRST";
            }
            case 139: {
                return "JMP_NSAMPLE";
            }
            case 140: {
                return "JMP_INT";
            }
            case 141: {
                return "JMP_VAL";
            }
            case 142: {
                return "JMP_ISA";
            }
            case 143: {
                return "JMP_VAL_N";
            }
            case 105: {
                return "IS_ZERO";
            }
            case 106: {
                return "IS_NZERO";
            }
            case 107: {
                return "IS_NULL";
            }
            case 108: {
                return "IS_NNULL";
            }
            case 109: {
                return "IS_EQ";
            }
            case 110: {
                return "IS_NEQ";
            }
            case 111: {
                return "IS_LT";
            }
            case 112: {
                return "IS_LTE";
            }
            case 113: {
                return "IS_GT";
            }
            case 114: {
                return "IS_GTE";
            }
            case 115: {
                return "IS_NOT";
            }
            case 116: {
                return "IS_TYPE";
            }
            case 117: {
                return "IS_NTYPE";
            }
            case 104: {
                return "CMP";
            }
            case 80: {
                return "VAR";
            }
            case 81: {
                return "VAR_I";
            }
            case 82: {
                return "VAR_N";
            }
            case 83: {
                return "VAR_IN";
            }
            case 84: {
                return "VAR_D";
            }
            case 85: {
                return "VAR_DN";
            }
            case 86: {
                return "VAR_C";
            }
            case 87: {
                return "VAR_CN";
            }
            case 88: {
                return "VAR_S";
            }
            case 89: {
                return "VAR_SN";
            }
            case 90: {
                return "VAR_T";
            }
            case 91: {
                return "VAR_TN";
            }
            case 92: {
                return "VAR_M";
            }
            case 93: {
                return "VAR_MN";
            }
            case 96: {
                return "MOV";
            }
            case 97: {
                return "MOV_VAR";
            }
            case 98: {
                return "MOV_REF";
            }
            case 99: {
                return "MOV_THIS";
            }
            case 100: {
                return "MOV_THIS_A";
            }
            case 101: {
                return "MOV_TYPE";
            }
            case 102: {
                return "CAST";
            }
            case 147: {
                return "GP_ADD";
            }
            case 148: {
                return "GP_SUB";
            }
            case 149: {
                return "GP_MUL";
            }
            case 150: {
                return "GP_DIV";
            }
            case 151: {
                return "GP_MOD";
            }
            case 152: {
                return "GP_SHL";
            }
            case 153: {
                return "GP_SHR";
            }
            case 154: {
                return "GP_USHR";
            }
            case 155: {
                return "GP_AND";
            }
            case 156: {
                return "GP_OR";
            }
            case 157: {
                return "GP_XOR";
            }
            case 158: {
                return "GP_DIVREM";
            }
            case 159: {
                return "GP_IRANGEI";
            }
            case 160: {
                return "GP_ERANGEI";
            }
            case 161: {
                return "GP_IRANGEE";
            }
            case 162: {
                return "GP_ERANGEE";
            }
            case 163: {
                return "GP_NEG";
            }
            case 164: {
                return "GP_COMPL";
            }
            case 165: {
                return "L_GET";
            }
            case 166: {
                return "L_SET";
            }
            case 167: {
                return "P_GET";
            }
            case 168: {
                return "P_SET";
            }
            case 169: {
                return "P_VAR";
            }
            case 170: {
                return "P_REF";
            }
            case 171: {
                return "IP_INC";
            }
            case 172: {
                return "IP_DEC";
            }
            case 173: {
                return "IP_INCA";
            }
            case 174: {
                return "IP_DECA";
            }
            case 175: {
                return "IP_INCB";
            }
            case 176: {
                return "IP_DECB";
            }
            case 177: {
                return "IP_ADD";
            }
            case 178: {
                return "IP_SUB";
            }
            case 179: {
                return "IP_MUL";
            }
            case 180: {
                return "IP_DIV";
            }
            case 181: {
                return "IP_MOD";
            }
            case 182: {
                return "IP_SHL";
            }
            case 183: {
                return "IP_SHR";
            }
            case 184: {
                return "IP_USHR";
            }
            case 185: {
                return "IP_AND";
            }
            case 186: {
                return "IP_OR";
            }
            case 187: {
                return "IP_XOR";
            }
            case 188: {
                return "PIP_INC";
            }
            case 189: {
                return "PIP_DEC";
            }
            case 190: {
                return "PIP_INCA";
            }
            case 191: {
                return "PIP_DECA";
            }
            case 192: {
                return "PIP_INCB";
            }
            case 193: {
                return "PIP_DECB";
            }
            case 194: {
                return "PIP_ADD";
            }
            case 195: {
                return "PIP_SUB";
            }
            case 205: {
                return "I_GET";
            }
            case 206: {
                return "I_SET";
            }
            case 207: {
                return "IIP_INC";
            }
            case 208: {
                return "IIP_DEC";
            }
            case 211: {
                return "IIP_INCB";
            }
            case 209: {
                return "IIP_INCA";
            }
            case 212: {
                return "IIP_DECB";
            }
            case 210: {
                return "IIP_DECA";
            }
            case 213: {
                return "IIP_ADD";
            }
            case 214: {
                return "IIP_SUB";
            }
            case 215: {
                return "IIP_MUL";
            }
            case 216: {
                return "IIP_DIV";
            }
            case 16: {
                return "CALL_00";
            }
            case 17: {
                return "CALL_01";
            }
            case 18: {
                return "CALL_0N";
            }
            case 19: {
                return "CALL_0T";
            }
            case 20: {
                return "CALL_10";
            }
            case 21: {
                return "CALL_11";
            }
            case 22: {
                return "CALL_1N";
            }
            case 23: {
                return "CALL_1T";
            }
            case 24: {
                return "CALL_N0";
            }
            case 25: {
                return "CALL_N1";
            }
            case 26: {
                return "CALL_NN";
            }
            case 27: {
                return "CALL_NT";
            }
            case 28: {
                return "CALL_T0";
            }
            case 29: {
                return "CALL_T1";
            }
            case 30: {
                return "CALL_TN";
            }
            case 31: {
                return "CALL_TT";
            }
            case 32: {
                return "NVOK_00";
            }
            case 33: {
                return "NVOK_01";
            }
            case 34: {
                return "NVOK_0N";
            }
            case 35: {
                return "NVOK_0T";
            }
            case 36: {
                return "NVOK_10";
            }
            case 37: {
                return "NVOK_11";
            }
            case 38: {
                return "NVOK_1N";
            }
            case 39: {
                return "NVOK_1T";
            }
            case 40: {
                return "NVOK_N0";
            }
            case 41: {
                return "NVOK_N1";
            }
            case 42: {
                return "NVOK_NN";
            }
            case 43: {
                return "NVOK_NT";
            }
            case 44: {
                return "NVOK_T0";
            }
            case 45: {
                return "NVOK_T1";
            }
            case 46: {
                return "NVOK_TN";
            }
            case 47: {
                return "NVOK_TT";
            }
            case 56: {
                return "NEW_0";
            }
            case 57: {
                return "NEW_1";
            }
            case 58: {
                return "NEW_N";
            }
            case 59: {
                return "NEW_T";
            }
            case 60: {
                return "NEWG_0";
            }
            case 61: {
                return "NEWG_1";
            }
            case 62: {
                return "NEWG_N";
            }
            case 63: {
                return "NEWG_T";
            }
            case 64: {
                return "NEWC_0";
            }
            case 65: {
                return "NEWC_1";
            }
            case 66: {
                return "NEWC_N";
            }
            case 67: {
                return "NEWC_T";
            }
            case 68: {
                return "NEWCG_0";
            }
            case 69: {
                return "NEWCG_1";
            }
            case 70: {
                return "NEWCG_N";
            }
            case 71: {
                return "NEWCG_T";
            }
            case 72: {
                return "NEWV_0";
            }
            case 73: {
                return "NEWV_1";
            }
            case 74: {
                return "NEWV_N";
            }
            case 52: {
                return "CONSTR_0";
            }
            case 53: {
                return "CONSTR_1";
            }
            case 54: {
                return "CONSTR_N";
            }
            case 55: {
                return "CONSTR_T";
            }
            case 51: {
                return "SYN_INIT";
            }
        }
        throw new IllegalStateException("op=" + Handy.byteToHexString(nOp));
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int c = Handy.readMagnitude(in);
        int[] ai = new int[c];
        for (int i = 0; i < c; ++i) {
            ai[i] = Handy.readPackedInt(in);
        }
        return ai;
    }

    public static void writeIntArray(DataOutput out, int[] ai) throws IOException {
        int c = ai.length;
        Handy.writePackedLong(out, c);
        for (int i = 0; i < c; ++i) {
            Handy.writePackedLong(out, ai[i]);
        }
    }

    public static abstract class Prefix
    extends Op {
        private Op m_op;

        public Op getNextOp() {
            return this.m_op;
        }

        public Op getSuffix() {
            Op op;
            Op op2 = this.m_op;
            if (op2 instanceof Prefix) {
                Prefix opPrefix = (Prefix)op2;
                op = opPrefix.getSuffix();
            } else {
                op = op2;
            }
            return op;
        }

        public Prefix append(Op op) {
            assert (op != this);
            if (this.m_op == null) {
                this.m_op = op;
            } else {
                Op op2 = this.m_op;
                if (op2 instanceof Prefix) {
                    Prefix opPrefix = (Prefix)op2;
                    opPrefix.append(op);
                } else {
                    throw new IllegalStateException();
                }
            }
            return this;
        }

        @Override
        public void resolveCode(MethodStructure.Code code, Constant[] aconst) {
            this.m_op.resolveCode(code, aconst);
        }

        @Override
        public void write(DataOutput out, ConstantRegistry registry) throws IOException {
            this.m_op.write(out, registry);
        }

        @Override
        public Op ensureOp() {
            if (this.m_op == null) {
                throw new IllegalStateException("prefix requires a suffix: " + String.valueOf(this));
            }
            return this.m_op.ensureOp();
        }

        @Override
        public int getOpCode() {
            return this.m_op.getOpCode();
        }

        @Override
        public int process(Frame frame, int iPC) {
            return this.m_op.process(frame, iPC);
        }

        @Override
        public void initInfo(int nAddress, int nDepth, int nGuardDepth, int nGuardAllDepth) {
            super.initInfo(nAddress, nDepth, nGuardDepth, nGuardAllDepth);
            this.m_op.initInfo(nAddress, nDepth, nGuardDepth, nGuardAllDepth);
        }

        @Override
        public int getAddress() {
            return this.m_op.getAddress();
        }

        @Override
        public int getDepth() {
            return this.m_op.getDepth();
        }

        @Override
        public boolean isReachable() {
            return this.m_op.isReachable();
        }

        @Override
        public void markReachable(Op[] aop) {
            super.markReachable(aop);
            this.m_op.markReachable(aop);
        }

        @Override
        public boolean isNecessary() {
            return this.m_op.isNecessary();
        }

        @Override
        public void markNecessary() {
            super.markNecessary();
            this.m_op.markNecessary();
        }

        @Override
        public boolean isDiscardable() {
            return this.m_op.isDiscardable();
        }

        @Override
        public boolean isRedundant() {
            return this.m_op.isRedundant();
        }

        @Override
        public void markRedundant() {
            super.markRedundant();
            this.m_op.markRedundant();
        }

        @Override
        public boolean checkRedundant(Op[] aop) {
            boolean fRedundant = this.m_op.checkRedundant(aop);
            if (fRedundant) {
                super.markRedundant();
            }
            return fRedundant;
        }

        @Override
        public Prefix convertToPrefix() {
            if (this.m_op != null) {
                this.m_op = this.m_op.convertToPrefix();
            }
            return this;
        }

        @Override
        public void resetSimulation() {
            this.m_op.resetSimulation();
        }

        @Override
        public void simulate(Scope scope) {
            this.m_op.simulate(scope);
        }

        @Override
        public boolean branches(Op[] aop, List<Integer> list) {
            return this.m_op.branches(aop, list);
        }

        @Override
        public boolean advances() {
            return this.m_op.advances();
        }

        @Override
        public void registerConstants(ConstantRegistry registry) {
            this.m_op.registerConstants(registry);
        }

        @Override
        public void resolveAddresses(Op[] aop) {
            this.m_op.resolveAddresses(aop);
        }

        @Override
        public boolean contains(Op that) {
            return this == that || this.m_op != null && this.m_op.contains(that);
        }

        @Override
        public boolean usesSuper() {
            return this.m_op != null && this.m_op.usesSuper();
        }

        @Override
        public boolean isEnter() {
            return this.m_op != null && this.m_op.isEnter();
        }

        @Override
        public boolean isExit() {
            return this.m_op != null && this.m_op.isExit();
        }
    }

    public static class ConstantRegistry
    implements BinaryAST.ConstantResolver {
        private final MethodStructure f_method;
        private final ConstantPool f_pool;
        private Map<Constant, Integer> m_mapConstants;
        private Constant[] m_aconst;
        private final ArrayList<RegisterAST> m_listRegs = new ArrayList();
        private final Stack<Integer> m_stackScopes = new Stack();
        private RegisterAST[] m_aregParams = BinaryAST.NO_REGS;
        private final RegisterAST[] m_aregSpecial = new RegisterAST[16];

        public ConstantRegistry(MethodStructure method, ConstantPool pool) {
            this.f_method = method;
            this.f_pool = pool;
            int cParams = this.f_method.getParamCount();
            if (cParams > 0) {
                RegisterAST[] aReg = new RegisterAST[cParams];
                for (int i = 0; i < cParams; ++i) {
                    Parameter param = this.f_method.getParam(i);
                    aReg[i] = new RegisterAST(param.getType(), param.getNameConstant());
                }
                this.init(aReg);
            }
        }

        @Override
        public Constant register(Constant constant) {
            this.ensureRegistering();
            if (constant == null) {
                return null;
            }
            if (constant.containsUnresolved()) {
                throw new IllegalStateException("Unresolved constant: " + String.valueOf(constant));
            }
            constant = this.f_pool.register(constant);
            if (this.m_mapConstants == null) {
                this.m_mapConstants = new HashMap<Constant, Integer>();
            }
            this.m_mapConstants.compute(constant, (k, count) -> count == null ? 1 : 1 + count);
            return constant;
        }

        public Constant[] getConstantArray() {
            this.ensureOptimized();
            return this.m_aconst;
        }

        @Override
        public Constant getConstant(int id) {
            return this.getConstantArray()[id];
        }

        @Override
        public TypeConstant typeForName(String name) {
            return this.f_pool.getImplicitlyImportedIdentity(name).getType();
        }

        @Override
        public int indexOf(Constant constant) {
            Integer index;
            this.ensureOptimized();
            Map<Constant, Integer> map = this.m_mapConstants;
            Integer n = index = map == null ? null : map.get(constant);
            if (index == null) {
                throw new IllegalArgumentException("missing constant: " + String.valueOf(constant));
            }
            return index;
        }

        @Override
        public void init(RegisterAST[] params) {
            assert (params != null && Arrays.stream(params).allMatch(Objects::nonNull));
            assert (this.m_aregParams == BinaryAST.NO_REGS || this.m_aregParams.length == params.length);
            assert (this.m_stackScopes.empty());
            this.m_aregParams = params;
            this.m_listRegs.clear();
            for (RegisterAST reg : params) {
                this.register(reg);
            }
        }

        @Override
        public void enter() {
            this.m_stackScopes.push(this.m_listRegs.size());
        }

        @Override
        public void register(RegisterAST reg) {
            block6: {
                int regId;
                block5: {
                    assert (reg != null);
                    regId = reg.getRegId();
                    if (regId >= 0) break block5;
                    switch (regId) {
                        case -13: 
                        case -12: 
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -7: 
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: 
                        case -2: {
                            break block6;
                        }
                        default: {
                            throw new IllegalArgumentException("regId=" + regId);
                        }
                    }
                }
                assert (!reg.isRegIdAssigned() || regId == this.m_listRegs.size());
                regId = this.m_listRegs.size();
                reg.setRegId(regId);
                this.m_listRegs.add(reg);
            }
        }

        @Override
        public RegisterAST getRegister(int regId) {
            RegisterAST reg;
            RegisterAST registerAST = reg = regId >= 0 ? this.m_listRegs.get(regId) : this.m_aregSpecial[-1 - regId];
            if (reg == null) {
                TypeConstant type = null;
                String name = null;
                TypeConstant typeThis = this.f_method.getContainingClass().getFormalType();
                switch (regId) {
                    case -3: 
                    case -2: {
                        type = this.f_pool.typeObject();
                        name = "_";
                        break;
                    }
                    case -4: {
                        type = this.f_pool.typeObject();
                        name = "?";
                        break;
                    }
                    case -5: {
                        assert (!(this.f_method.isConstructor() || this.f_method.isValidator() || this.f_method.isStatic()));
                        type = typeThis;
                        name = "this";
                        break;
                    }
                    case -6: {
                        assert (!(this.f_method.isConstructor() || this.f_method.isValidator() || this.f_method.isStatic()));
                        type = typeThis;
                        name = "this:target";
                        break;
                    }
                    case -7: {
                        assert (!(this.f_method.isConstructor() || this.f_method.isValidator() || this.f_method.isStatic()));
                        type = this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.PUBLIC);
                        name = "this:public";
                        break;
                    }
                    case -8: {
                        assert (!(this.f_method.isConstructor() || this.f_method.isValidator() || this.f_method.isStatic()));
                        type = this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.PROTECTED);
                        name = "this:protected";
                        break;
                    }
                    case -9: {
                        assert (!(this.f_method.isConstructor() || this.f_method.isValidator() || this.f_method.isStatic()));
                        type = this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.PRIVATE);
                        name = "this:private";
                        break;
                    }
                    case -10: {
                        assert (this.f_method.isConstructor() || this.f_method.isValidator() || !this.f_method.isStatic());
                        type = this.f_pool.ensureIntersectionTypeConstant(this.f_pool.typeStruct(), this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.STRUCT));
                        name = "this:struct";
                        break;
                    }
                    case -11: {
                        type = this.f_pool.ensureParameterizedTypeConstant(this.f_pool.typeClass(), this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.PUBLIC), this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.PROTECTED), this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.PRIVATE), this.f_pool.ensureIntersectionTypeConstant(this.f_pool.typeStruct(), this.f_pool.ensureAccessTypeConstant(typeThis, Constants.Access.STRUCT)));
                        name = "this:class";
                        break;
                    }
                    case -12: {
                        type = this.f_pool.typeService();
                        name = "this:service";
                        break;
                    }
                    case -13: {
                        SignatureConstant sigSuper;
                        assert (this.f_method.isSuperAllowed());
                        MethodConstant idMethod = this.f_method.getIdentityConstant();
                        Constants.Access access = idMethod.isTopLevel() ? Constants.Access.PROTECTED : Constants.Access.PRIVATE;
                        TypeConstant typeCtx = this.f_pool.ensureAccessTypeConstant(typeThis, access);
                        TypeInfo infoType = typeCtx.ensureTypeInfo();
                        MethodInfo infoMethod = infoType.getMethodById(idMethod);
                        SignatureConstant signatureConstant = sigSuper = infoMethod == null ? null : infoMethod.getSuper(infoType);
                        if (sigSuper == null) {
                            if (this.f_method.isConstructor() && this.f_method.getContainingClass().containsAnnotation(this.f_pool.clzOverride())) {
                                sigSuper = idMethod.getSignature();
                            } else {
                                return null;
                            }
                        }
                        type = sigSuper.asFunctionType();
                        name = "super";
                    }
                }
                if (type == null) {
                    throw new IllegalStateException("missing register " + regId);
                }
                this.m_aregSpecial[-1 - regId] = reg = new RegisterAST(regId, type, name == null ? null : this.f_pool.ensureStringConstant(name));
            }
            return reg;
        }

        @Override
        public void exit() {
            int cPrev = this.m_stackScopes.pop();
            int cCur = this.m_listRegs.size();
            assert (cCur >= cPrev);
            while (cCur > cPrev) {
                this.m_listRegs.remove(--cCur);
            }
        }

        private void ensureRegistering() {
            if (this.m_aconst != null) {
                throw new IllegalStateException("constants are no longer being registered");
            }
        }

        private synchronized void ensureOptimized() {
            if (this.m_aconst == null) {
                if (this.f_method.m_aconstLocal != null && this.m_mapConstants == null) {
                    this.m_aconst = this.f_method.m_aconstLocal;
                } else {
                    Map<Constant, Integer> mapConstants = this.m_mapConstants;
                    if (mapConstants == null) {
                        this.m_aconst = Constant.NO_CONSTS;
                    } else {
                        Constant[] aconst = mapConstants.keySet().toArray(Constant.NO_CONSTS);
                        Arrays.sort(aconst, Constants.DEBUG ? Comparator.naturalOrder() : (o1, o2) -> (Integer)mapConstants.get(o2) - (Integer)mapConstants.get(o1));
                        this.m_aconst = aconst;
                        int c = aconst.length;
                        for (int i = 0; i < c; ++i) {
                            mapConstants.put(aconst[i], i);
                        }
                    }
                }
            }
        }

        public String toString() {
            return "Resolver for " + this.f_method.getIdentityConstant().getPathString();
        }
    }
}

