/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.TypeSystem;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.xException;
import org.xvm.util.Handy;

public abstract class OpCallable
extends Op {
    protected int m_nFunctionId;
    protected int m_nRetValue = -2;
    protected int[] m_anRetValue;
    protected Argument m_argFunction;
    protected Argument m_argReturn;
    protected Argument[] m_aArgReturn;

    protected OpCallable(Argument argFunction) {
        this.m_argFunction = argFunction;
    }

    protected OpCallable(DataInput in, Constant[] aconst) throws IOException {
        this.m_nFunctionId = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argFunction != null) {
            this.m_nFunctionId = OpCallable.encodeArgument(this.m_argFunction, registry);
        }
        Handy.writePackedLong(out, this.m_nFunctionId);
    }

    @Override
    public boolean usesSuper() {
        return this.m_nFunctionId == -13;
    }

    protected boolean isMultiReturn() {
        return false;
    }

    @Override
    public void resetSimulation() {
        if (this.isMultiReturn()) {
            OpCallable.resetRegisters(this.m_aArgReturn);
        } else {
            OpCallable.resetRegister(this.m_argReturn);
        }
    }

    @Override
    public void simulate(Scope scope) {
        if (this.isMultiReturn()) {
            OpCallable.checkNextRegisters(scope, this.m_aArgReturn, this.m_anRetValue);
        } else {
            OpCallable.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argFunction = OpCallable.registerArgument(this.m_argFunction, registry);
        if (this.isMultiReturn()) {
            OpCallable.registerArguments(this.m_aArgReturn, registry);
        } else {
            this.m_argReturn = OpCallable.registerArgument(this.m_argReturn, registry);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getFunctionString() + "(" + this.getParamsString() + ") -> " + this.getReturnsString();
    }

    protected String getFunctionString() {
        return Argument.toIdString(this.m_argFunction, this.m_nFunctionId);
    }

    protected String getParamsString() {
        return "";
    }

    protected static String getParamsString(int[] anArgValue, Argument[] aArgValue) {
        StringBuilder sb = new StringBuilder();
        int cArgNums = anArgValue == null ? 0 : anArgValue.length;
        int cArgRefs = aArgValue == null ? 0 : aArgValue.length;
        int c = Math.max(cArgNums, cArgRefs);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Argument.toIdString(i < cArgRefs ? aArgValue[i] : null, i < cArgNums ? anArgValue[i] : 1000000000));
        }
        return sb.toString();
    }

    protected String getReturnsString() {
        if (this.m_anRetValue != null || this.m_aArgReturn != null) {
            StringBuilder sb = new StringBuilder();
            int cArgNums = this.m_anRetValue == null ? 0 : this.m_anRetValue.length;
            int cArgRefs = this.m_aArgReturn == null ? 0 : this.m_aArgReturn.length;
            int c = Math.max(cArgNums, cArgRefs);
            for (int i = 0; i < c; ++i) {
                sb.append(i == 0 ? "(" : ", ").append(Argument.toIdString(i < cArgRefs ? this.m_aArgReturn[i] : null, i < cArgNums ? this.m_anRetValue[i] : 1000000000));
            }
            return sb.append(')').toString();
        }
        if (this.m_nRetValue != -2 || this.m_argReturn != null) {
            return Argument.toIdString(this.m_argReturn, this.m_nRetValue);
        }
        return "void";
    }

    protected MethodStructure getChildConstructor(Frame frame, ObjectHandle hParent) {
        ClassStructure clzParentC;
        IdentityConstant idParent;
        IdentityConstant idParentR = hParent.getTemplate().getClassConstant();
        ServiceContext context = frame.f_context;
        MethodStructure constructor = (MethodStructure)context.getOpInfo(this, Category.Constructor);
        if (constructor != null && (idParent = (IdentityConstant)context.getOpInfo(this, Category.TargetClass)).equals(idParentR)) {
            return constructor;
        }
        constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return null;
        }
        ClassStructure clzTargetC = (ClassStructure)constructor.getParent().getParent();
        if (clzTargetC.isVirtualChild() && (clzParentC = (ClassStructure)clzTargetC.getParent()).getFormat() != Component.Format.ANNOTATION && !idParentR.equals(clzParentC.getIdentityConstant())) {
            ClassStructure clzParentR = (ClassStructure)idParentR.getComponent();
            ClassStructure clzChild = clzParentR.getVirtualChild(clzTargetC.getSimpleName());
            if (clzChild == null) {
                return null;
            }
            TypeInfo infoTarget = clzChild.getFormalType().ensureAccess(Constants.Access.PROTECTED).ensureTypeInfo();
            MethodInfo infoConstr = infoTarget.getMethodBySignature(constructor.getIdentityConstant().getSignature(), true);
            if (infoConstr == null) {
                return null;
            }
            constructor = infoConstr.getTopmostMethodStructure(infoTarget);
        }
        context.setOpInfo(this, Category.TargetClass, idParentR);
        context.setOpInfo(this, Category.Constructor, constructor);
        return constructor;
    }

    protected MethodStructure getTypeConstructor(Frame frame, xRTType.TypeHandle hType) {
        IdentityConstant idTarget;
        TypeConstant typeR = hType.getDataType();
        IdentityConstant idTargetR = typeR.getSingleUnderlyingClass(false);
        ServiceContext context = frame.f_context;
        MethodStructure constructor = (MethodStructure)context.getOpInfo(this, Category.Constructor);
        if (constructor != null && (idTarget = (IdentityConstant)context.getOpInfo(this, Category.TargetClass)).equals(idTargetR)) {
            return constructor;
        }
        constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return null;
        }
        ClassStructure clzTargetC = (ClassStructure)constructor.getParent().getParent();
        IdentityConstant idTargetC = clzTargetC.getIdentityConstant();
        if (!idTargetR.equals(idTargetC)) {
            TypeInfo infoTarget = typeR.ensureTypeInfo();
            MethodInfo info = infoTarget.getMethodBySignature(constructor.getIdentityConstant().getSignature(), true);
            if (info == null) {
                return null;
            }
            constructor = info.getTopmostMethodStructure(infoTarget);
        }
        context.setOpInfo(this, Category.TargetClass, idTargetR);
        context.setOpInfo(this, Category.Constructor, constructor);
        return constructor;
    }

    protected int reportMissingConstructor(Frame frame, ObjectHandle hParent) {
        MethodStructure constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return -3;
        }
        IdentityConstant idParent = hParent instanceof xRTType.TypeHandle ? ((xRTType.TypeHandle)hParent).getDataType().getSingleUnderlyingClass(false) : hParent.getType().getSingleUnderlyingClass(false);
        return frame.raiseException("Missing constructor \"" + constructor.getIdentityConstant().getPathString() + "\" at class " + idParent.getValueString());
    }

    protected int reportNonExtendable(Frame frame, MethodStructure constructor) {
        return frame.raiseException(xException.unsupported(frame, "Class \"" + constructor.getContainingClass().getIdentityConstant().getPathString() + "\" is not extendable"));
    }

    protected MethodStructure getConstructor(Frame frame) {
        assert (frame.f_function.isConstructor());
        ServiceContext context = frame.f_context;
        MethodStructure constructor = (MethodStructure)context.getOpInfo(this, Category.Function);
        IdentityConstant idPrev = (IdentityConstant)context.getOpInfo(this, Category.TargetClass);
        IdentityConstant idThis = frame.getThis().getTemplate().getClassConstant();
        if (constructor != null && idPrev.equals(idThis)) {
            return constructor;
        }
        ConstantPool pool = frame.poolContext();
        GenericTypeResolver resolver = frame.getGenericsResolver(false);
        MethodConstant idCtor = (MethodConstant)frame.getConstant(this.m_nFunctionId);
        IdentityConstant idTarget = idCtor.getNamespace();
        TypeConstant typeTarget = idTarget.getFormalType().resolveGenerics(pool, resolver);
        if (typeTarget.isVirtualChild()) {
            TypeConstant typeVirtTarget;
            String sNameTarget;
            TypeConstant typeThis = frame.getThis().getType();
            if (!typeThis.isVirtualChild()) {
                frame.raiseException("Not a virtual child: \"" + typeTarget.getValueString() + "\"");
                return null;
            }
            String sNameCurrent = frame.f_function.getIdentityConstant().getNamespace().getName();
            if (!sNameCurrent.equals(sNameTarget = idTarget.getName()) && (typeVirtTarget = typeTarget.ensureVirtualParent(typeThis.getParentType(), true)) != typeTarget) {
                constructor = pool.ensureAccessTypeConstant(typeVirtTarget, Constants.Access.PROTECTED).findCallable(idCtor.getSignature().resolveGenericTypes(pool, resolver));
            }
        }
        if (constructor == null) {
            constructor = (MethodStructure)idCtor.getComponent();
            if (constructor == null) {
                constructor = pool.ensureAccessTypeConstant(typeTarget, Constants.Access.PRIVATE).findCallable(idCtor.getSignature().resolveGenericTypes(pool, resolver));
            }
            if (constructor == null) {
                frame.raiseException("Unresolvable constructor \"" + idCtor.getValueString() + "\" for " + typeTarget.getValueString());
                return null;
            }
        }
        context.setOpInfo(this, Category.Function, constructor);
        context.setOpInfo(this, Category.TargetClass, idThis);
        return constructor;
    }

    protected MethodStructure getMethodStructure(Frame frame) {
        ServiceContext context = frame.f_context;
        MethodConstant idFunction = (MethodConstant)frame.getConstant(this.m_nFunctionId);
        MethodStructure function = (MethodStructure)context.getOpInfo(this, Category.Function);
        IdentityConstant idTarget = idFunction.getNamespace();
        switch (idTarget.getFormat()) {
            case Module: 
            case Package: 
            case Class: {
                if (function != null) break;
                ConstantPool pool = frame.poolContext();
                GenericTypeResolver resolver = frame.getGenericsResolver(false);
                TypeConstant typeTarget = idTarget.getFormalType().resolveGenerics(pool, resolver);
                function = (MethodStructure)idFunction.getComponent();
                if (function == null) {
                    function = pool.ensureAccessTypeConstant(typeTarget, Constants.Access.PRIVATE).findCallable(idFunction.getSignature().resolveGenericTypes(pool, resolver));
                }
                if (function == null) {
                    frame.raiseException("Unresolvable or ambiguous function \"" + idFunction.getValueString() + "\" for " + typeTarget.getValueString());
                    return null;
                }
                context.setOpInfo(this, Category.Function, function);
                context.setOpInfo(this, Category.Template, context.f_container.getTemplate(typeTarget));
                break;
            }
            case FormalTypeChild: 
            case Property: 
            case TypeParameter: 
            case DynamicFormal: {
                GenericTypeResolver resolver = frame.getGenericsResolver(true);
                TypeConstant typeTarget = ((FormalConstant)idTarget).resolve(resolver);
                TypeConstant typePrev = (TypeConstant)context.getOpInfo(this, Category.TargetType);
                if (function != null && typeTarget.equals(typePrev)) break;
                function = typeTarget.findCallable(idFunction.getSignature());
                if (function == null) {
                    frame.raiseException("Unresolvable or ambiguous function \"" + idFunction.getValueString() + "\" for " + typeTarget.getValueString());
                    return null;
                }
                context.setOpInfo(this, Category.Function, function);
                context.setOpInfo(this, Category.TargetType, typeTarget);
                context.setOpInfo(this, Category.Template, typeTarget.isSingleDefiningConstant() ? context.f_container.getTemplate(typeTarget) : context.f_container.getTemplate(function.getContainingClass().getIdentityConstant()));
                break;
            }
            case Method: {
                if (function != null) break;
                function = (MethodStructure)idFunction.getComponent();
                assert (!function.isNative());
                context.setOpInfo(this, Category.Function, function);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return function;
    }

    protected ClassTemplate getNativeTemplate(Frame frame, MethodStructure function) {
        assert (function == frame.f_context.getOpInfo(this, Category.Function));
        return (ClassTemplate)frame.f_context.getOpInfo(this, Category.Template);
    }

    protected int constructChild(Frame frame, MethodStructure constructor, ObjectHandle hParent, TypeConstant typeChild, ObjectHandle[] ahVar) {
        TypeConstant typeTarget;
        ConstantPool pool = frame.poolContext();
        ClassStructure structChild = (ClassStructure)constructor.getParent().getParent();
        TypeConstant typeParent = hParent.getComposition().getInceptionType().removeAccess();
        if (structChild.isVirtualChild()) {
            typeTarget = pool.ensureVirtualChildTypeConstant(typeParent, structChild.getName());
            if (typeChild != null) {
                if (typeChild.isParamsSpecified()) {
                    typeTarget = pool.ensureParameterizedTypeConstant(typeTarget, typeChild.getParamTypesArray());
                }
                if (typeChild.isAnnotated()) {
                    typeTarget = typeTarget.adoptAnnotations(pool, typeChild);
                }
            }
        } else {
            typeTarget = typeChild == null ? (structChild.isInnerChild() ? pool.ensureInnerChildTypeConstant(typeParent, (ClassConstant)structChild.getIdentityConstant()) : structChild.getCanonicalType()) : typeChild;
        }
        TypeComposition clzTarget = typeTarget.ensureClass(frame);
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
        }
        return clzTarget.getTemplate().construct(frame, constructor, clzTarget, hParent, ahVar, this.m_nRetValue);
    }

    protected int constructChild(Frame frame, MethodStructure constructor, ObjectHandle hParent, ObjectHandle[] ahVar) {
        return this.constructChild(frame, constructor, hParent, null, ahVar);
    }

    protected void checkReturnRegister(Frame frame, MethodStructure method) {
        assert (!this.isMultiReturn());
        if (frame.isNextRegister(this.m_nRetValue)) {
            int nMethodId = this.m_nFunctionId;
            if (nMethodId == -13) {
                nMethodId = frame.poolContext().getConstant(method.getIdentityConstant()).getPosition();
            }
            frame.introduceMethodReturnVar(this.m_nRetValue, nMethodId, 0);
        }
    }

    protected void checkReturnTupleRegister(Frame frame, MethodStructure method) {
        assert (!this.isMultiReturn());
        if (frame.isNextRegister(this.m_nRetValue)) {
            int nMethodId = this.m_nFunctionId;
            if (nMethodId == -13) {
                nMethodId = frame.poolContext().getConstant(method.getIdentityConstant()).getPosition();
            }
            frame.introduceMethodReturnVar(this.m_nRetValue, nMethodId, 0);
        }
    }

    protected void checkReturnRegisters(Frame frame, MethodStructure method) {
        assert (this.isMultiReturn());
        int nMethodId = this.m_nFunctionId;
        if (nMethodId == -13) {
            nMethodId = frame.poolContext().getConstant(method.getIdentityConstant()).getPosition();
        }
        int[] anRet = this.m_anRetValue;
        int c = anRet.length;
        for (int i = 0; i < c; ++i) {
            if (!frame.isNextRegister(anRet[i])) continue;
            frame.introduceMethodReturnVar(anRet[i], nMethodId, i);
        }
    }

    protected void buildCall(BuildContext bctx, CodeBuilder code, int[] anArgValue) {
        MethodTypeDesc mdCall;
        boolean fSpecial;
        SignatureConstant sigCall;
        JitMethodDesc jmdCall;
        ClassDesc cdTarget;
        TypeSystem ts = bctx.typeSystem;
        if (this.m_nFunctionId == -13) {
            MethodBody body = bctx.callChain[1];
            cdTarget = body.getIdentity().getType().ensureClassDesc(ts);
            jmdCall = body.getJitDesc(bctx.typeSystem);
            sigCall = body.getSignature();
            fSpecial = true;
        } else if (this.m_nFunctionId <= -16) {
            MethodConstant idMethod = (MethodConstant)bctx.getConstant(this.m_nFunctionId);
            IdentityConstant idTarget = idMethod.getClassIdentity();
            MethodInfo infoMethod = idTarget.getType().ensureTypeInfo().getMethodById(idMethod);
            cdTarget = idTarget.getType().ensureClassDesc(ts);
            jmdCall = infoMethod.getJitDesc(ts);
            sigCall = infoMethod.getSignature();
            fSpecial = false;
        } else {
            BuildContext.Slot slotFn = bctx.getSlot(this.m_nFunctionId);
            throw new UnsupportedOperationException("function call " + String.valueOf(slotFn.type()));
        }
        Object methodName = sigCall.getName();
        if (jmdCall.isOptimized) {
            mdCall = jmdCall.optimizedMD;
            methodName = (String)methodName + "$p";
        } else {
            mdCall = jmdCall.standardMD;
        }
        bctx.loadCtx(code);
        bctx.loadArguments(code, jmdCall, anArgValue);
        if (fSpecial) {
            code.invokespecial(cdTarget, (String)methodName, mdCall);
        } else {
            code.invokestatic(cdTarget, (String)methodName, mdCall);
        }
        int cReturns = sigCall.getReturnCount();
        if (cReturns > 0) {
            int[] nArray;
            if (this.isMultiReturn()) {
                nArray = this.m_anRetValue;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.m_nRetValue;
            }
            int[] anVar = nArray;
            bctx.assignReturns(code, jmdCall, cReturns, anVar);
        }
    }

    protected void buildNew(BuildContext bctx, CodeBuilder code, int[] anArgValue) {
        MethodTypeDesc md;
        TypeSystem ts = bctx.typeSystem;
        MethodConstant idCtor = (MethodConstant)bctx.getConstant(this.m_nFunctionId);
        IdentityConstant idTarget = idCtor.getNamespace();
        TypeConstant typeTarget = idTarget.getType();
        TypeInfo infoTarget = typeTarget.ensureAccess(Constants.Access.PRIVATE).ensureTypeInfo();
        MethodInfo infoCtor = infoTarget.getMethodById(idCtor);
        if (infoCtor == null) {
            throw new RuntimeException("Unresolvable constructor \"" + idCtor.getValueString() + "\" for " + typeTarget.getValueString());
        }
        String sJitTarget = typeTarget.ensureJitClassName(ts);
        ClassDesc cdTarget = ClassDesc.of(sJitTarget);
        JitMethodDesc jmdNew = Builder.convertConstructToNew(infoTarget, sJitTarget, infoCtor.getJitDesc(ts));
        boolean fOptimized = jmdNew.isOptimized;
        Object sJitNew = idCtor.ensureJitMethodName(ts).replace("construct", "$new");
        if (fOptimized) {
            md = jmdNew.optimizedMD;
            sJitNew = (String)sJitNew + "$p";
        } else {
            md = jmdNew.standardMD;
        }
        bctx.loadCtx(code);
        bctx.loadArguments(code, jmdNew, anArgValue);
        code.invokestatic(cdTarget, (String)sJitNew, md);
        bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, typeTarget, cdTarget, ""));
    }

    protected void buildConstruct(BuildContext bctx, CodeBuilder code, int[] anArgValue) {
        MethodTypeDesc md;
        TypeSystem ts = bctx.typeSystem;
        MethodConstant idCtor = (MethodConstant)bctx.getConstant(this.m_nFunctionId);
        IdentityConstant idTarget = idCtor.getNamespace();
        TypeConstant typeTarget = idTarget.getType();
        TypeInfo infoTarget = typeTarget.ensureAccess(Constants.Access.PRIVATE).ensureTypeInfo();
        MethodInfo infoCtor = infoTarget.getMethodById(idCtor);
        if (infoCtor == null) {
            throw new RuntimeException("Unresolvable constructor \"" + idCtor.getValueString() + "\" for " + typeTarget.getValueString());
        }
        String sJitTarget = typeTarget.ensureJitClassName(ts);
        ClassDesc cdTarget = ClassDesc.of(sJitTarget);
        JitMethodDesc jmdCtor = infoCtor.getJitDesc(ts);
        boolean fOptimized = jmdCtor.isOptimized;
        Object sJitCtor = idCtor.ensureJitMethodName(ts);
        if (fOptimized) {
            md = jmdCtor.optimizedMD;
            sJitCtor = (String)sJitCtor + "$p";
        } else {
            md = jmdCtor.standardMD;
        }
        bctx.loadCtx(code);
        bctx.loadCtorCtx(code);
        bctx.loadThis(code);
        bctx.loadArguments(code, jmdCtor, anArgValue);
        code.invokestatic(cdTarget, (String)sJitCtor, md);
    }

    static enum Category {
        Function,
        Template,
        TargetClass,
        TargetType,
        Constructor;

    }
}

