/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.Op;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.Label;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public abstract class OpCondJump
extends Op {
    protected int m_nType;
    protected int m_nArg;
    protected int m_nArg2;
    protected int m_ofJmp;
    protected TypeConstant m_typeCommon;
    private Argument m_argVal;
    private Argument m_argVal2;
    private Op m_opDest;
    protected transient int m_cExits;

    protected OpCondJump(Argument arg, Op op) {
        assert (!this.hasSecondArgument() && !this.isBinaryOp());
        this.m_argVal = arg;
        this.m_opDest = op;
    }

    protected OpCondJump(Argument arg, Argument arg2, Op op) {
        assert (this.hasSecondArgument() && !this.isBinaryOp());
        this.m_argVal = arg;
        this.m_argVal2 = arg2;
        this.m_opDest = op;
    }

    protected OpCondJump(TypeConstant type, Argument arg, Argument arg2, Op op) {
        assert (this.isBinaryOp());
        this.m_typeCommon = type;
        this.m_argVal = arg;
        this.m_argVal2 = arg2;
        this.m_opDest = op;
    }

    protected OpCondJump(DataInput in, Constant[] aconst) throws IOException {
        if (this.isBinaryOp()) {
            this.m_nType = Handy.readPackedInt(in);
        }
        this.m_nArg = Handy.readPackedInt(in);
        if (this.hasSecondArgument()) {
            this.m_nArg2 = Handy.readPackedInt(in);
        }
        this.m_ofJmp = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_typeCommon != null) {
            this.m_nType = OpCondJump.encodeArgument(this.m_typeCommon, registry);
            this.m_typeCommon = null;
        }
        if (this.m_argVal != null) {
            this.m_nArg = OpCondJump.encodeArgument(this.m_argVal, registry);
        }
        if (this.m_argVal2 != null) {
            this.m_nArg2 = OpCondJump.encodeArgument(this.m_argVal2, registry);
        }
        if (this.isBinaryOp()) {
            Handy.writePackedLong(out, this.m_nType);
        }
        Handy.writePackedLong(out, this.m_nArg);
        if (this.hasSecondArgument()) {
            Handy.writePackedLong(out, this.m_nArg2);
        }
        Handy.writePackedLong(out, this.m_ofJmp);
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        if (this.m_opDest == null) {
            this.m_ofJmp = this.adjustRelativeAddress(aop, this.m_ofJmp);
            this.m_opDest = aop[this.getAddress() + this.m_ofJmp];
        } else {
            this.m_ofJmp = this.calcRelativeAddress(this.m_opDest);
        }
        this.m_cExits = this.calcExits(this.m_opDest);
    }

    protected boolean isBinaryOp() {
        return false;
    }

    protected boolean hasSecondArgument() {
        return this.isBinaryOp();
    }

    @Override
    public int process(Frame frame, int iPC) {
        return this.isBinaryOp() ? this.processBinaryOp(frame, iPC) : this.processUnaryOp(frame, iPC);
    }

    protected int processUnaryOp(Frame frame, int iPC) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nArg);
            return OpCondJump.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.completeUnaryOp(frameCaller, iPC, frameCaller.popStack())) : this.completeUnaryOp(frame, iPC, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int processBinaryOp(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nArg, this.m_nArg2}, 2);
            TypeConstant typeCommon = this.calculateCommonType(frame);
            if (OpCondJump.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.completeBinaryOp(frame, iPC, typeCommon, ahArg[0], ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.completeBinaryOp(frame, iPC, typeCommon, ahArg[0], ahArg[1]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected TypeConstant calculateCommonType(Frame frame) {
        TypeConstant typeCommon = this.m_typeCommon;
        if (typeCommon == null) {
            this.m_typeCommon = typeCommon = (TypeConstant)frame.getConstant(this.m_nType);
        }
        return frame.resolveType(typeCommon);
    }

    protected int completeUnaryOp(Frame frame, int iPC, ObjectHandle hValue) {
        throw new UnsupportedOperationException();
    }

    protected int completeBinaryOp(Frame frame, int iPC, TypeConstant type, ObjectHandle hValue1, ObjectHandle hValue2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markReachable(Op[] aop) {
        super.markReachable(aop);
        this.m_opDest = this.findDestinationOp(aop, this.m_ofJmp);
        this.m_ofJmp = this.calcRelativeAddress(this.m_opDest);
    }

    @Override
    public boolean checkRedundant(Op[] aop) {
        if (this.m_ofJmp == 1) {
            this.markRedundant();
            return true;
        }
        return false;
    }

    @Override
    public boolean branches(Op[] aop, List<Integer> list) {
        list.add(this.getRelativeAddress());
        return true;
    }

    public int getRelativeAddress() {
        return this.m_ofJmp;
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        if (this.isBinaryOp()) {
            this.m_typeCommon = (TypeConstant)OpCondJump.registerArgument(this.m_typeCommon, registry);
        }
        this.m_argVal = OpCondJump.registerArgument(this.m_argVal, registry);
        if (this.hasSecondArgument()) {
            this.m_argVal2 = OpCondJump.registerArgument(this.m_argVal2, registry);
        }
    }

    protected String getArgDesc() {
        return Argument.toIdString(this.m_argVal, this.m_nArg);
    }

    protected String getArg2Desc() {
        assert (this.hasSecondArgument());
        return Argument.toIdString(this.m_argVal2, this.m_nArg2);
    }

    protected String getLabelDesc() {
        Op op = this.m_opDest;
        if (op instanceof Label) {
            Label label = (Label)op;
            return label.getName();
        }
        if (this.m_ofJmp != 0) {
            return (this.m_ofJmp > 0 ? "+" : "") + this.m_ofJmp;
        }
        if (this.m_opDest != null) {
            return "-> " + String.valueOf(this.m_opDest);
        }
        return "???";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpCondJump.toName(this.getOpCode())).append(' ');
        if (this.isBinaryOp()) {
            sb.append(Argument.toIdString(this.m_typeCommon, this.m_nType)).append(", ");
        }
        sb.append(this.getArgDesc());
        if (this.hasSecondArgument()) {
            sb.append(", ").append(this.getArg2Desc());
        }
        sb.append(", ").append(this.getLabelDesc());
        return sb.toString();
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        if (this.isBinaryOp()) {
            this.buildBinary(bctx, code);
        } else {
            this.buildUnary(bctx, code);
        }
    }

    protected void buildBinary(BuildContext bctx, CodeBuilder code) {
        BuildContext.Slot slot1 = bctx.loadArgument(code, this.m_nArg);
        BuildContext.Slot slot2 = bctx.loadArgument(code, this.m_nArg2);
        TypeConstant typeCommon = OpCondJump.selectCommonType(slot1.type(), slot2.type(), ErrorListener.BLACKHOLE);
        ClassDesc cdCommon = JitTypeDesc.getPrimitiveClass(typeCommon);
        assert (((TypeConstant)bctx.getConstant(this.m_nType)).removeAutoNarrowing().equals(typeCommon));
        if (cdCommon.isPrimitive()) {
            String desc;
            java.lang.classfile.Label lblJump = bctx.ensureLabel(code, this.getAddress() + this.m_ofJmp);
            block10 : switch (desc = cdCommon.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    switch (this.getOpCode()) {
                        case 128: {
                            code.if_icmpeq(lblJump);
                            break block10;
                        }
                        case 129: {
                            code.if_icmpne(lblJump);
                            break block10;
                        }
                        case 132: {
                            code.if_icmpgt(lblJump);
                            break block10;
                        }
                        case 133: {
                            code.if_icmpge(lblJump);
                            break block10;
                        }
                        case 130: {
                            code.if_icmplt(lblJump);
                            break block10;
                        }
                        case 131: {
                            code.if_icmple(lblJump);
                            break block10;
                        }
                    }
                    throw new IllegalStateException();
                }
                case "J": 
                case "F": 
                case "D": {
                    switch (desc) {
                        case "J": {
                            code.lcmp();
                            break;
                        }
                        case "F": {
                            code.fcmpl();
                            break;
                        }
                        case "D": {
                            code.dcmpl();
                        }
                    }
                    switch (this.getOpCode()) {
                        case 128: {
                            code.ifeq(lblJump);
                            break block10;
                        }
                        case 129: {
                            code.ifne(lblJump);
                            break block10;
                        }
                        case 132: {
                            code.ifgt(lblJump);
                            break block10;
                        }
                        case 133: {
                            code.ifge(lblJump);
                            break block10;
                        }
                        case 130: {
                            code.iflt(lblJump);
                            break block10;
                        }
                        case 131: {
                            code.ifle(lblJump);
                            break block10;
                        }
                    }
                    throw new IllegalStateException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            throw new UnsupportedOperationException("Non primitive " + OpCondJump.toName(this.getOpCode()));
        }
    }

    protected void buildUnary(BuildContext bctx, CodeBuilder code) {
        java.lang.classfile.Label lblJump = bctx.ensureLabel(code, this.getAddress() + this.m_ofJmp);
        int op = this.getOpCode();
        switch (op) {
            case 136: 
            case 137: {
                bctx.loadCtx(code);
                code.getfield(Builder.CD_Ctx, "container", Builder.CD_Container);
                bctx.loadArgument(code, this.m_nArg);
                code.invokevirtual(Builder.CD_Container, "isSpecified", MethodTypeDesc.of(ConstantDescs.CD_boolean, Builder.CD_JavaString));
                if (op == 136) {
                    code.ifne(lblJump);
                } else {
                    code.ifeq(lblJump);
                }
                return;
            }
        }
        BuildContext.Slot slot = bctx.loadArgument(code, this.m_nArg);
        ClassDesc cd = slot.cd();
        if (cd.isPrimitive()) {
            String desc;
            if (slot instanceof BuildContext.DoubleSlot) {
                BuildContext.DoubleSlot doubleSlot = (BuildContext.DoubleSlot)slot;
                assert (doubleSlot.flavor() == JitFlavor.MultiSlotPrimitive);
                code.iload(doubleSlot.extSlot());
                switch (op) {
                    case 126: {
                        code.ifne(lblJump);
                        break;
                    }
                    case 127: {
                        code.ifeq(lblJump);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return;
            }
            Builder.defaultLoad(code, cd);
            block17 : switch (desc = cd.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    switch (this.getOpCode()) {
                        case 124: {
                            code.if_icmpeq(lblJump);
                            break block17;
                        }
                        case 125: {
                            code.if_icmpne(lblJump);
                            break block17;
                        }
                    }
                    throw new IllegalStateException();
                }
                case "J": 
                case "F": 
                case "D": {
                    switch (desc) {
                        case "J": {
                            code.lcmp();
                            break;
                        }
                        case "F": {
                            code.fcmpl();
                            break;
                        }
                        case "D": {
                            code.dcmpl();
                        }
                    }
                    switch (op) {
                        case 124: {
                            code.ifeq(lblJump);
                            break block17;
                        }
                        case 125: {
                            code.ifne(lblJump);
                            break block17;
                        }
                    }
                    throw new IllegalStateException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            switch (op) {
                case 126: 
                case 127: {
                    Builder.loadNull(code);
                    if (op == 126) {
                        code.ifeq(lblJump);
                        break;
                    }
                    code.ifne(lblJump);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

