/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public abstract class OpGeneral
extends Op {
    protected int m_nTarget;
    protected int m_nArgValue;
    protected int m_nRetValue;
    private Argument m_argTarget;
    private Argument m_argValue;
    private Argument m_argReturn;

    protected OpGeneral(Argument argTarget, Argument argReturn) {
        assert (!this.isBinaryOp());
        assert (argTarget != null && argReturn != null);
        this.m_argTarget = argTarget;
        this.m_argReturn = argReturn;
    }

    protected OpGeneral(Argument argTarget, Argument argValue, Argument argReturn) {
        assert (this.isBinaryOp());
        assert (argTarget != null && argValue != null && argReturn != null);
        this.m_argTarget = argTarget;
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    protected OpGeneral(DataInput in, Constant[] aconst) throws IOException {
        this.m_nTarget = Handy.readPackedInt(in);
        if (this.isBinaryOp()) {
            this.m_nArgValue = Handy.readPackedInt(in);
        }
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = OpGeneral.encodeArgument(this.m_argTarget, registry);
            if (this.isBinaryOp()) {
                this.m_nArgValue = OpGeneral.encodeArgument(this.m_argValue, registry);
            }
            this.m_nRetValue = OpGeneral.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        if (this.isBinaryOp()) {
            Handy.writePackedLong(out, this.m_nArgValue);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    protected boolean isBinaryOp() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        return this.isBinaryOp() ? this.processBinaryOp(frame) : this.processUnaryOp(frame);
    }

    protected int processUnaryOp(Frame frame) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            if (frame.isNextRegister(this.m_nRetValue)) {
                frame.introduceVarCopy(this.m_nRetValue, this.m_nTarget);
            }
            return OpGeneral.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.completeUnary(frameCaller, frameCaller.popStack())) : this.completeUnary(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int completeUnary(Frame frame, ObjectHandle hTarget) {
        throw new UnsupportedOperationException();
    }

    protected int processBinaryOp(Frame frame) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nTarget, this.m_nArgValue}, 2);
            if (frame.isNextRegister(this.m_nRetValue)) {
                frame.introduceVarCopy(this.m_nRetValue, this.m_nTarget);
            }
            if (OpGeneral.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.completeBinary(frameCaller, ahArg[0], ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.completeBinary(frame, ahArg[0], ahArg[1]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int completeBinary(Frame frame, ObjectHandle hTarget, ObjectHandle hArg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetSimulation() {
        OpGeneral.resetRegister(this.m_argReturn);
    }

    @Override
    public void simulate(Scope scope) {
        OpGeneral.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argTarget = OpGeneral.registerArgument(this.m_argTarget, registry);
        if (this.isBinaryOp()) {
            this.m_argValue = OpGeneral.registerArgument(this.m_argValue, registry);
        }
        this.m_argReturn = OpGeneral.registerArgument(this.m_argReturn, registry);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpGeneral.toName(this.getOpCode())).append(' ').append(Argument.toIdString(this.m_argTarget, this.m_nTarget));
        if (this.isBinaryOp()) {
            sb.append(", ").append(Argument.toIdString(this.m_argValue, this.m_nArgValue));
        }
        sb.append(", ").append(Argument.toIdString(this.m_argReturn, this.m_nRetValue));
        return sb.toString();
    }
}

