/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.TypeSystem;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.util.Handy;

public abstract class OpInPlace
extends Op {
    protected int m_nTarget;
    protected int m_nRetValue;
    private Argument m_argTarget;
    private Argument m_argReturn;

    protected OpInPlace(Argument argTarget) {
        assert (!this.isAssignOp());
        this.m_argTarget = argTarget;
    }

    protected OpInPlace(Argument argTarget, Argument argReturn) {
        assert (this.isAssignOp());
        this.m_argTarget = argTarget;
        this.m_argReturn = argReturn;
    }

    protected OpInPlace(DataInput in, Constant[] aconst) throws IOException {
        this.m_nTarget = Handy.readPackedInt(in);
        if (this.isAssignOp()) {
            this.m_nRetValue = Handy.readPackedInt(in);
        }
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = OpInPlace.encodeArgument(this.m_argTarget, registry);
            if (this.isAssignOp()) {
                this.m_nRetValue = OpInPlace.encodeArgument(this.m_argReturn, registry);
            }
        }
        Handy.writePackedLong(out, this.m_nTarget);
        if (this.isAssignOp()) {
            Handy.writePackedLong(out, this.m_nRetValue);
        }
    }

    protected boolean isAssignOp() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            int nTarget = this.m_nTarget;
            if (nTarget >= 0) {
                if (frame.isDynamicVar(nTarget)) {
                    xRef.RefHandle hVar = frame.getDynamicVar(nTarget);
                    if (hVar == null) {
                        return -7;
                    }
                    if (this.isAssignOp() && frame.isNextRegister(this.m_nRetValue)) {
                        frame.introduceRefTypeVar(nTarget);
                    }
                    return this.completeWithVar(frame, hVar);
                }
                ObjectHandle hTarget = frame.getArgument(nTarget);
                if (this.isAssignOp() && frame.isNextRegister(this.m_nRetValue)) {
                    frame.introduceVarCopy(this.m_nRetValue, nTarget);
                }
                return OpInPlace.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.completeWithRegister(frameCaller, frameCaller.popStack())) : this.completeWithRegister(frame, hTarget);
            }
            if (this.isAssignOp() && frame.isNextRegister(this.m_nRetValue)) {
                frame.introduceVarCopy(this.m_nRetValue, nTarget);
            }
            PropertyConstant idProp = (PropertyConstant)frame.getConstant(nTarget);
            return this.completeWithProperty(frame, idProp);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int completeWithRegister(Frame frame, ObjectHandle hTarget) {
        throw new UnsupportedOperationException();
    }

    protected int completeWithVar(Frame frame, xRef.RefHandle hTarget) {
        throw new UnsupportedOperationException();
    }

    protected int completeWithProperty(Frame frame, PropertyConstant idProp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetSimulation() {
        if (this.isAssignOp()) {
            OpInPlace.resetRegister(this.m_argReturn);
        }
    }

    @Override
    public void simulate(Scope scope) {
        if (this.isAssignOp()) {
            OpInPlace.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argTarget = OpInPlace.registerArgument(this.m_argTarget, registry);
        if (this.isAssignOp()) {
            this.m_argReturn = OpInPlace.registerArgument(this.m_argReturn, registry);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(' ').append(this.getTargetString());
        if (this.isAssignOp()) {
            sb.append(", ").append(this.getReturnString());
        }
        return sb.toString();
    }

    protected String getTargetString() {
        return Argument.toIdString(this.m_argTarget, this.m_nTarget);
    }

    protected String getReturnString() {
        return Argument.toIdString(this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        int nTarget = this.m_nTarget;
        if (nTarget >= 0) {
            BuildContext.Slot slot = bctx.getSlot(nTarget);
            if (slot.cd().isPrimitive()) {
                assert (slot.isSingle());
                this.buildPrimitiveLocal(code, slot);
                if (this.isAssignOp()) {
                    bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, slot.type()));
                }
            } else {
                JitMethodDesc jmd = this.buildOpCallLocal(bctx, code, slot);
                if (this.isAssignOp()) {
                    bctx.assignReturns(code, jmd, 1, new int[]{this.m_nRetValue});
                }
            }
        } else {
            PropertyConstant idProp = (PropertyConstant)bctx.getConstant(nTarget);
            TypeConstant typeProp = idProp.getType();
            if (typeProp.isPrimitive()) {
                this.buildPrimitiveProperty(bctx, code, idProp);
                if (this.isAssignOp()) {
                    bctx.ensureSlot(this.m_nRetValue, idProp.getType());
                }
            }
        }
    }

    protected void buildPrimitiveLocal(CodeBuilder code, BuildContext.Slot slot) {
        block10 : switch (slot.cd().descriptorString()) {
            case "I": 
            case "S": 
            case "B": 
            case "C": 
            case "Z": {
                switch (this.getOpCode()) {
                    case 172: {
                        code.iinc(slot.slot(), -1);
                        break block10;
                    }
                    case 171: {
                        code.iinc(slot.slot(), 1);
                        break block10;
                    }
                    case 174: {
                        code.iload(slot.slot()).iinc(slot.slot(), -1);
                        break block10;
                    }
                    case 173: {
                        code.iload(slot.slot()).iinc(slot.slot(), 1);
                        break block10;
                    }
                    case 176: {
                        code.iinc(slot.slot(), -1).iload(slot.slot());
                        break block10;
                    }
                    case 175: {
                        code.iinc(slot.slot(), 1).iload(slot.slot());
                        break block10;
                    }
                }
                throw new IllegalStateException();
            }
            case "J": {
                code.lload(slot.slot());
                switch (this.getOpCode()) {
                    case 172: {
                        code.lconst_1().lsub();
                        break;
                    }
                    case 171: {
                        code.lconst_1().ladd();
                        break;
                    }
                    case 174: {
                        code.dup2().lconst_1().lsub();
                        break;
                    }
                    case 173: {
                        code.dup2().lconst_1().ladd();
                        break;
                    }
                    case 176: {
                        code.lconst_1().lsub().dup2();
                        break;
                    }
                    case 175: {
                        code.lconst_1().ladd().dup2();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                code.lstore(slot.slot());
                break;
            }
            case "F": {
                code.fload(slot.slot());
                switch (this.getOpCode()) {
                    case 172: {
                        code.fconst_1().fsub();
                        break;
                    }
                    case 171: {
                        code.fconst_1().fadd();
                        break;
                    }
                    case 174: {
                        code.dup2().fconst_1().fsub();
                        break;
                    }
                    case 173: {
                        code.dup2().fconst_1().fadd();
                        break;
                    }
                    case 176: {
                        code.fconst_1().fsub().dup2();
                        break;
                    }
                    case 175: {
                        code.fconst_1().fadd().dup2();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                code.fstore(slot.slot());
                break;
            }
            case "D": {
                code.dload(slot.slot());
                switch (this.getOpCode()) {
                    case 172: {
                        code.dconst_1().dsub();
                        break;
                    }
                    case 171: {
                        code.dconst_1().dadd();
                        break;
                    }
                    case 174: {
                        code.dup2().dconst_1().dsub();
                        break;
                    }
                    case 173: {
                        code.dup2().dconst_1().dadd();
                        break;
                    }
                    case 176: {
                        code.dconst_1().dsub().dup2();
                        break;
                    }
                    case 175: {
                        code.dconst_1().dadd().dup2();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                code.dstore(slot.slot());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected JitMethodDesc buildOpCallLocal(BuildContext bctx, CodeBuilder code, BuildContext.Slot slot) {
        String sName;
        String sOp = switch (this.getOpCode()) {
            case 172 -> {
                sName = "prevValue";
                yield null;
            }
            case 171 -> {
                sName = "nextValue";
                yield null;
            }
            case 174 -> {
                sName = "postDecrement";
                yield "#--";
            }
            case 173 -> {
                sName = "postIncrement";
                yield "#++";
            }
            case 176 -> {
                sName = "preDecrement";
                yield "--#";
            }
            case 175 -> {
                sName = "preIncrement";
                yield "++#";
            }
            default -> throw new IllegalStateException();
        };
        TypeInfo info = slot.type().ensureTypeInfo();
        MethodInfo method = info.findOpMethod(sName, sOp, 0);
        String sJitName = method.getIdentity().ensureJitMethodName(bctx.typeSystem);
        JitMethodDesc jmd = method.getJitDesc(bctx.typeSystem);
        assert (!jmd.isOptimized);
        code.aload(slot.slot());
        bctx.loadCtx(code);
        code.invokevirtual(slot.cd(), sJitName, jmd.standardMD);
        return jmd;
    }

    protected void buildPrimitiveProperty(BuildContext bctx, CodeBuilder code, PropertyConstant idProp) {
        TypeSystem ts = bctx.typeSystem;
        PropertyInfo infoProp = idProp.getPropertyInfo();
        TypeConstant type = infoProp.getType();
        JitMethodDesc jmdGet = infoProp.getGetterJitDesc(ts);
        JitMethodDesc jmdSet = infoProp.getSetterJitDesc(ts);
        JitParamDesc pd = jmdGet.optimizedReturns[0];
        ClassDesc cd = pd.cd;
        assert (jmdGet.isOptimized || jmdSet.isOptimized);
        MethodTypeDesc mdGet = jmdGet.optimizedMD;
        MethodTypeDesc mdSet = jmdSet.optimizedMD;
        String sGetName = infoProp.getGetterId().ensureJitMethodName(ts) + "$p";
        String sSetName = infoProp.getSetterId().ensureJitMethodName(ts) + "$p";
        BuildContext.Slot slotTarget = bctx.loadThis(code);
        bctx.loadCtx(code);
        code.invokevirtual(slotTarget.cd(), sGetName, mdGet);
        int op = this.getOpCode();
        block8 : switch (cd.descriptorString()) {
            case "I": 
            case "S": 
            case "B": 
            case "C": 
            case "Z": {
                switch (op) {
                    case 171: 
                    case 172: {
                        code.iconst_1();
                        if (op == 172) {
                            code.isub();
                        } else {
                            code.iadd();
                        }
                        this.buildSetProperty(bctx, code, slotTarget, type, cd, sSetName, mdSet);
                        break block8;
                    }
                    case 173: 
                    case 174: {
                        code.dup();
                        bctx.pushTempVar(code, type, cd);
                        code.iconst_1();
                        if (op == 174) {
                            code.isub();
                        } else {
                            code.iadd();
                        }
                        this.buildSetProperty(bctx, code, slotTarget, type, cd, sSetName, mdSet);
                        bctx.popTempVar(code);
                        break block8;
                    }
                    case 175: 
                    case 176: {
                        code.iconst_1();
                        if (op == 176) {
                            code.isub();
                        } else {
                            code.iadd();
                        }
                        code.dup();
                        this.buildSetProperty(bctx, code, slotTarget, type, cd, sSetName, mdSet);
                        break block8;
                    }
                }
                throw new IllegalStateException();
            }
            case "J": {
                switch (op) {
                    case 171: 
                    case 172: {
                        code.lconst_1();
                        if (op == 172) {
                            code.lsub();
                        } else {
                            code.ladd();
                        }
                        this.buildSetProperty(bctx, code, slotTarget, type, cd, sSetName, mdSet);
                        break block8;
                    }
                    case 173: 
                    case 174: {
                        code.dup2();
                        bctx.pushTempVar(code, type, cd);
                        code.lconst_1();
                        if (op == 174) {
                            code.lsub();
                        } else {
                            code.ladd();
                        }
                        this.buildSetProperty(bctx, code, slotTarget, type, cd, sSetName, mdSet);
                        bctx.popTempVar(code);
                        break block8;
                    }
                    case 175: 
                    case 176: {
                        code.lconst_1();
                        if (op == 176) {
                            code.lsub();
                        } else {
                            code.ladd();
                        }
                        code.dup2();
                        this.buildSetProperty(bctx, code, slotTarget, type, cd, sSetName, mdSet);
                        break block8;
                    }
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void buildSetProperty(BuildContext bctx, CodeBuilder code, BuildContext.Slot slotTarget, TypeConstant type, ClassDesc cd, String sSetName, MethodTypeDesc mdSet) {
        bctx.pushTempVar(code, type, cd);
        bctx.loadThis(code);
        bctx.loadCtx(code);
        bctx.popTempVar(code);
        code.invokevirtual(slotTarget.cd(), sSetName, mdSet);
    }
}

