/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.util.Handy;

public abstract class OpInPlaceAssign
extends Op {
    protected int m_nTarget;
    protected int m_nArgValue;
    private Argument m_argTarget;
    private Argument m_argValue;

    protected OpInPlaceAssign(Argument argTarget, Argument argValue) {
        this.m_argTarget = argTarget;
        this.m_argValue = argValue;
    }

    protected OpInPlaceAssign(DataInput in, Constant[] aconst) throws IOException {
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nArgValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = OpInPlaceAssign.encodeArgument(this.m_argTarget, registry);
            this.m_nArgValue = OpInPlaceAssign.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nArgValue);
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            int nTarget = this.m_nTarget;
            if (nTarget >= 0) {
                if (frame.isDynamicVar(nTarget)) {
                    xRef.RefHandle hVar = frame.getDynamicVar(nTarget);
                    if (hVar == null) {
                        return -7;
                    }
                    ObjectHandle hValue = frame.getArgument(this.m_nArgValue);
                    return OpInPlaceAssign.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.completeWithVar(frameCaller, hVar, frameCaller.popStack())) : this.completeWithVar(frame, hVar, hValue);
                }
                ObjectHandle hTarget = frame.getArgument(nTarget);
                ObjectHandle hValue = frame.getArgument(this.m_nArgValue);
                if (OpInPlaceAssign.isDeferred(hTarget) || OpInPlaceAssign.isDeferred(hValue)) {
                    ObjectHandle[] ahArg = new ObjectHandle[]{hTarget, hValue};
                    Frame.Continuation stepNext = frameCaller -> this.completeWithRegister(frameCaller, ahArg[0], ahArg[1]);
                    return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
                }
                return this.completeWithRegister(frame, hTarget, hValue);
            }
            PropertyConstant idProp = (PropertyConstant)frame.getConstant(nTarget);
            ObjectHandle hTarget = frame.getThis();
            ObjectHandle hValue = frame.getArgument(this.m_nArgValue);
            return OpInPlaceAssign.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.completeWithProperty(frameCaller, hTarget, idProp, frameCaller.popStack())) : this.completeWithProperty(frame, hTarget, idProp, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int completeWithRegister(Frame frame, ObjectHandle hTarget, ObjectHandle hValue) {
        throw new UnsupportedOperationException();
    }

    protected int completeWithVar(Frame frame, xRef.RefHandle hTarget, ObjectHandle hValue) {
        throw new UnsupportedOperationException();
    }

    protected int completeWithProperty(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argTarget = OpInPlaceAssign.registerArgument(this.m_argTarget, registry);
        this.m_argValue = OpInPlaceAssign.registerArgument(this.m_argValue, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }
}

