/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public abstract class OpIndex
extends Op {
    protected int m_nTarget;
    protected int m_nIndex;
    protected int m_nRetValue;
    private Argument m_argTarget;
    private Argument m_argIndex;
    private Argument m_argReturn;

    protected OpIndex(Argument argTarget, Argument argIndex) {
        assert (!this.isAssignOp());
        this.m_argTarget = argTarget;
        this.m_argIndex = argIndex;
    }

    protected OpIndex(Argument argTarget, Argument argIndex, Argument argReturn) {
        assert (this.isAssignOp());
        this.m_argTarget = argTarget;
        this.m_argIndex = argIndex;
        this.m_argReturn = argReturn;
    }

    protected OpIndex(DataInput in, Constant[] aconst) throws IOException {
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nIndex = Handy.readPackedInt(in);
        if (this.isAssignOp()) {
            this.m_nRetValue = Handy.readPackedInt(in);
        }
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = OpIndex.encodeArgument(this.m_argTarget, registry);
            this.m_nIndex = OpIndex.encodeArgument(this.m_argIndex, registry);
            if (this.isAssignOp()) {
                this.m_nRetValue = OpIndex.encodeArgument(this.m_argReturn, registry);
            }
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nIndex);
        if (this.isAssignOp()) {
            Handy.writePackedLong(out, this.m_nRetValue);
        }
    }

    protected boolean isAssignOp() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nTarget, this.m_nIndex}, 2);
            if (OpIndex.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg[0], ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, ahArg[0], ahArg[1]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle hIndex) {
        throw new UnsupportedOperationException();
    }

    protected CallChain getOpChain(Frame frame, TypeConstant typeTarget) {
        TypeConstant typePrevTarget;
        ServiceContext ctx = frame.f_context;
        CallChain chain = (CallChain)ctx.getOpInfo(this, Category.Chain);
        if (chain != null && typeTarget.equals(typePrevTarget = (TypeConstant)ctx.getOpInfo(this, Category.Type))) {
            return chain;
        }
        return null;
    }

    protected void saveOpChain(Frame frame, TypeConstant typeTarget, CallChain chain) {
        ServiceContext ctx = frame.f_context;
        ctx.setOpInfo(this, Category.Chain, chain);
        ctx.setOpInfo(this, Category.Type, typeTarget);
    }

    @Override
    public void resetSimulation() {
        if (this.isAssignOp()) {
            OpIndex.resetRegister(this.m_argReturn);
        }
    }

    @Override
    public void simulate(Scope scope) {
        if (this.isAssignOp()) {
            OpIndex.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argTarget = OpIndex.registerArgument(this.m_argTarget, registry);
        this.m_argIndex = OpIndex.registerArgument(this.m_argIndex, registry);
        if (this.isAssignOp()) {
            this.m_argReturn = OpIndex.registerArgument(this.m_argReturn, registry);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argIndex, this.m_nIndex) + ", " + Argument.toIdString(this.m_argReturn, this.m_nRetValue);
    }

    static enum Category {
        Chain,
        Type;

    }
}

