/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpIndex;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public abstract class OpIndexInPlace
extends OpIndex {
    protected int m_nValue;
    private Argument m_argValue;

    protected OpIndexInPlace(Argument argTarget, Argument argIndex, Argument argValue) {
        super(argTarget, argIndex);
        this.m_argValue = argValue;
    }

    protected OpIndexInPlace(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nValue = OpIndexInPlace.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nValue);
    }

    @Override
    protected boolean isAssignOp() {
        return false;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nTarget, this.m_nIndex, this.m_nValue}, 3);
            if (OpIndexInPlace.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg[0], (ObjectHandle.JavaLong)ahArg[1], ahArg[2]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, ahArg[0], (ObjectHandle.JavaLong)ahArg[1], ahArg[2]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hTarget, ObjectHandle.JavaLong hIndex, ObjectHandle hValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = OpIndexInPlace.registerArgument(this.m_argValue, registry);
    }
}

