/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.PropertyComposition;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.xException;
import org.xvm.util.Handy;

public abstract class OpInvocable
extends Op {
    protected int m_nTarget;
    protected int m_nMethodId;
    protected int m_nRetValue = -2;
    protected int[] m_anRetValue;
    protected Argument m_argTarget;
    protected MethodConstant m_constMethod;
    protected Argument m_argReturn;
    protected Argument[] m_aArgReturn;

    protected OpInvocable(Argument argTarget, MethodConstant constMethod) {
        this.m_argTarget = argTarget;
        this.m_constMethod = constMethod;
    }

    protected OpInvocable(DataInput in, Constant[] aconst) throws IOException {
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nMethodId = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = OpInvocable.encodeArgument(this.m_argTarget, registry);
            this.m_nMethodId = OpInvocable.encodeArgument(this.m_constMethod, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nMethodId);
    }

    protected boolean isMultiReturn() {
        return false;
    }

    @Override
    public void resetSimulation() {
        if (this.isMultiReturn()) {
            OpInvocable.resetRegisters(this.m_aArgReturn);
        } else {
            OpInvocable.resetRegister(this.m_argReturn);
        }
    }

    @Override
    public void simulate(Scope scope) {
        if (this.isMultiReturn()) {
            OpInvocable.checkNextRegisters(scope, this.m_aArgReturn, this.m_anRetValue);
        } else {
            OpInvocable.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argTarget = OpInvocable.registerArgument(this.m_argTarget, registry);
        this.m_constMethod = (MethodConstant)OpInvocable.registerArgument(this.m_constMethod, registry);
        if (this.isMultiReturn()) {
            OpInvocable.registerArguments(this.m_aArgReturn, registry);
        } else {
            this.m_argReturn = OpInvocable.registerArgument(this.m_argReturn, registry);
        }
    }

    protected CallChain getCallChain(Frame frame, ObjectHandle hTarget) {
        PropertyConstant idProp;
        ServiceContext context = frame.f_context;
        CallChain chain = (CallChain)context.getOpInfo(this, Category.Chain);
        TypeComposition clazzPrev = (TypeComposition)context.getOpInfo(this, Category.Composition);
        TypeComposition clazz = hTarget.getComposition();
        if (chain != null && clazz == clazzPrev) {
            return chain;
        }
        context.setOpInfo(this, Category.Composition, clazz);
        MethodConstant idMethod = (MethodConstant)frame.getConstant(this.m_nMethodId);
        MethodStructure method = (MethodStructure)idMethod.getComponent();
        this.m_constMethod = idMethod;
        if (method != null && method.getAccess() == Constants.Access.PRIVATE) {
            chain = new CallChain(method);
            context.setOpInfo(this, Category.Chain, chain);
            return chain;
        }
        if (idMethod.getName().equals("construct")) {
            chain = new CallChain.VirtualConstructorChain(frame.poolContext(), idMethod, hTarget);
            context.setOpInfo(this, Category.Chain, chain);
            return chain;
        }
        PropertyConstant propertyConstant = idProp = clazz instanceof PropertyComposition ? null : this.checkPropertyAccessor(idMethod);
        if (idProp == null) {
            Object nid = idMethod.resolveNestedIdentity(frame.poolContext(), frame.getGenericsResolver(true));
            chain = clazz.getMethodCallChain(nid);
            if (chain.isEmpty()) {
                xRef.RefHandle hRef;
                chain = hTarget instanceof xRef.RefHandle && (hRef = (xRef.RefHandle)hTarget).isProperty() ? hRef.getReferentHolder().getComposition().getMethodCallChain(nid) : clazz.getMethodCallChain(idMethod.resolveNestedIdentity(frame.poolContext(), null));
            }
        } else {
            CallChain callChain = chain = "get".equals(idMethod.getName()) ? clazz.getPropertyGetterChain(idProp) : clazz.getPropertySetterChain(idProp);
        }
        if (chain.isEmpty()) {
            return new CallChain.ExceptionChain(xException.makeHandle(frame, "Missing method \"" + idMethod.getValueString() + "\" on " + hTarget.getType().getValueString()));
        }
        context.setOpInfo(this, Category.Chain, chain);
        return chain;
    }

    protected void checkReturnRegister(Frame frame, ObjectHandle hTarget) {
        assert (!this.isMultiReturn());
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceMethodReturnVar(this.m_nRetValue, this.m_nMethodId, 0);
        }
    }

    protected void checkReturnTupleRegister(Frame frame, ObjectHandle hTarget) {
        assert (!this.isMultiReturn());
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceMethodReturnVar(this.m_nRetValue, this.m_nMethodId, -1);
        }
    }

    protected void checkReturnRegisters(Frame frame, ObjectHandle hTarget) {
        assert (this.isMultiReturn());
        int[] anRet = this.m_anRetValue;
        int c = anRet.length;
        for (int i = 0; i < c; ++i) {
            if (!frame.isNextRegister(anRet[i])) continue;
            frame.introduceMethodReturnVar(anRet[i], this.m_nMethodId, i);
        }
    }

    private PropertyConstant checkPropertyAccessor(MethodConstant idMethod) {
        IdentityConstant idParent = idMethod.getNamespace();
        if (idParent instanceof PropertyConstant) {
            PropertyConstant idProp = (PropertyConstant)idParent;
            SignatureConstant sig = idMethod.getSignature();
            String sName = sig.getName();
            if ("get".equals(sName) && sig.getRawReturns()[0].isA(idProp.getType())) {
                return idProp;
            }
            if ("set".equals(sName) && sig.getRawParams()[0].isA(idProp.getType())) {
                return idProp;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getTargetString() + "." + this.getMethodString() + "(" + this.getParamsString() + ") -> " + this.getReturnsString();
    }

    protected String getTargetString() {
        return Argument.toIdString(this.m_argTarget, this.m_nTarget);
    }

    protected String getMethodString() {
        return Argument.toIdString(this.m_constMethod, this.m_nMethodId);
    }

    protected String getParamsString() {
        return "";
    }

    protected static String getParamsString(int[] anArgValue, Argument[] aArgValue) {
        StringBuilder sb = new StringBuilder();
        int cArgNums = anArgValue == null ? 0 : anArgValue.length;
        int cArgRefs = aArgValue == null ? 0 : aArgValue.length;
        int c = Math.max(cArgNums, cArgRefs);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Argument.toIdString(i < cArgRefs ? aArgValue[i] : null, i < cArgNums ? anArgValue[i] : 1000000000));
        }
        return sb.toString();
    }

    protected String getReturnsString() {
        if (this.m_anRetValue != null || this.m_aArgReturn != null) {
            StringBuilder sb = new StringBuilder();
            int cArgNums = this.m_anRetValue == null ? 0 : this.m_anRetValue.length;
            int cArgRefs = this.m_aArgReturn == null ? 0 : this.m_aArgReturn.length;
            int c = Math.max(cArgNums, cArgRefs);
            for (int i = 0; i < c; ++i) {
                sb.append(i == 0 ? "(" : ", ").append(Argument.toIdString(i < cArgRefs ? this.m_aArgReturn[i] : null, i < cArgNums ? this.m_anRetValue[i] : 1000000000));
            }
            return sb.append(')').toString();
        }
        if (this.m_nRetValue != -2 || this.m_argReturn != null) {
            return Argument.toIdString(this.m_argReturn, this.m_nRetValue);
        }
        return "void";
    }

    protected void buildInvoke(BuildContext bctx, CodeBuilder code, int[] anArgValue) {
        MethodTypeDesc md;
        BuildContext.Slot targetSlot = bctx.loadArgument(code, this.m_nTarget);
        if (!targetSlot.isSingle()) {
            throw new UnsupportedOperationException("Multislot invoke");
        }
        ClassDesc cdTarget = targetSlot.cd();
        MethodConstant idMethod = (MethodConstant)bctx.getConstant(this.m_nMethodId);
        MethodInfo infoMethod = targetSlot.type().ensureTypeInfo().getMethodById(idMethod);
        JitMethodDesc jmd = infoMethod.getJitDesc(bctx.typeSystem);
        Object methodName = idMethod.ensureJitMethodName(bctx.typeSystem);
        boolean fOptimized = jmd.isOptimized;
        if (cdTarget.isPrimitive()) {
            bctx.builder.box(code, targetSlot.type(), cdTarget);
            cdTarget = targetSlot.type().ensureClassDesc(bctx.typeSystem);
        }
        if (fOptimized) {
            md = jmd.optimizedMD;
            methodName = (String)methodName + "$p";
        } else {
            md = jmd.standardMD;
        }
        bctx.loadCtx(code);
        bctx.loadArguments(code, jmd, anArgValue);
        if (infoMethod.getHead().getImplementation().getExistence() == MethodBody.Existence.Interface) {
            code.invokeinterface(cdTarget, (String)methodName, md);
        } else {
            code.invokevirtual(cdTarget, (String)methodName, md);
        }
        int cReturns = infoMethod.getSignature().getReturnCount();
        if (cReturns > 0) {
            int[] nArray;
            if (this.isMultiReturn()) {
                nArray = this.m_anRetValue;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.m_nRetValue;
            }
            int[] anVar = nArray;
            bctx.assignReturns(code, jmd, cReturns, anVar);
        }
    }

    static enum Category {
        Chain,
        Composition;

    }
}

