/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.op.Label;
import org.xvm.runtime.Frame;
import org.xvm.util.Handy;

public abstract class OpJump
extends Op {
    protected int m_ofJmp;
    private Op m_opDest;
    protected transient int m_cExits;

    protected OpJump(Op op) {
        this.m_opDest = op;
    }

    protected OpJump(DataInput in, Constant[] aconst) throws IOException {
        this.m_ofJmp = Handy.readPackedInt(in);
        assert (this.m_ofJmp > 0);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        out.writeByte(this.getOpCode());
        Handy.writePackedLong(out, this.m_ofJmp);
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        if (this.m_opDest == null) {
            this.m_ofJmp = this.adjustRelativeAddress(aop, this.m_ofJmp);
            this.m_opDest = aop[this.getAddress() + this.m_ofJmp];
        } else {
            this.m_ofJmp = this.calcRelativeAddress(this.m_opDest);
        }
        assert (this.m_ofJmp > 0 || !this.isReachable() && this.m_ofJmp == 0);
        this.m_cExits = this.calcExits(this.m_opDest);
    }

    @Override
    public int process(Frame frame, int iPC) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markReachable(Op[] aop) {
        super.markReachable(aop);
        this.m_opDest = this.findDestinationOp(aop, this.m_ofJmp);
        this.m_ofJmp = this.calcRelativeAddress(this.m_opDest);
        assert (this.m_ofJmp > 0);
    }

    @Override
    public boolean branches(Op[] aop, List<Integer> list) {
        list.add(this.m_ofJmp);
        return true;
    }

    @Override
    public boolean advances() {
        return false;
    }

    public int getRelativeAddress() {
        return this.m_ofJmp;
    }

    protected String getLabelDesc() {
        return OpJump.getLabelDesc(this.m_opDest, this.m_ofJmp);
    }

    public static String getLabelDesc(Op opDest, int ofJmp) {
        if (opDest instanceof Label) {
            return ((Label)opDest).getName();
        }
        if (ofJmp != 0) {
            return (ofJmp > 0 ? "+" : "") + ofJmp;
        }
        if (opDest != null) {
            return "-> " + String.valueOf(opDest);
        }
        return "???";
    }

    @Override
    public String toString() {
        return OpJump.toName(this.getOpCode()) + " " + this.getLabelDesc();
    }
}

