/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.util.Handy;

public abstract class OpMove
extends Op {
    protected int m_nFromValue;
    protected int m_nToValue;
    protected Argument m_argFrom;
    protected Argument m_argTo;

    protected OpMove(Argument argFrom, Argument argTo) {
        this.m_argFrom = argFrom;
        this.m_argTo = argTo;
    }

    protected OpMove(DataInput in, Constant[] aconst) throws IOException {
        this.m_nFromValue = Handy.readPackedInt(in);
        this.m_nToValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argFrom != null) {
            this.m_nFromValue = OpMove.encodeArgument(this.m_argFrom, registry);
            this.m_nToValue = OpMove.encodeArgument(this.m_argTo, registry);
        }
        Handy.writePackedLong(out, this.m_nFromValue);
        Handy.writePackedLong(out, this.m_nToValue);
    }

    @Override
    public void resetSimulation() {
        OpMove.resetRegister(this.m_argTo);
    }

    @Override
    public void simulate(Scope scope) {
        OpMove.checkNextRegister(scope, this.m_argTo, this.m_nToValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argFrom = OpMove.registerArgument(this.m_argFrom, registry);
        this.m_argTo = OpMove.registerArgument(this.m_argTo, registry);
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_argFrom, this.m_nFromValue) + ", " + Argument.toIdString(this.m_argTo, this.m_nToValue);
    }
}

