/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpProperty;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public abstract class OpPropInPlace
extends OpProperty {
    protected int m_nTarget;
    protected int m_nRetValue;
    private Argument m_argTarget;
    private Argument m_argReturn;

    protected OpPropInPlace(PropertyConstant idProp, Argument argTarget) {
        super(idProp);
        assert (!this.isAssignOp());
        this.m_argTarget = argTarget;
    }

    protected OpPropInPlace(PropertyConstant idProp, Argument argTarget, Argument argReturn) {
        super(idProp);
        assert (this.isAssignOp());
        this.m_argTarget = argTarget;
        this.m_argReturn = argReturn;
    }

    protected OpPropInPlace(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTarget = Handy.readPackedInt(in);
        if (this.isAssignOp()) {
            this.m_nRetValue = Handy.readPackedInt(in);
        }
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = OpPropInPlace.encodeArgument(this.m_argTarget, registry);
            if (this.isAssignOp()) {
                this.m_nRetValue = OpPropInPlace.encodeArgument(this.m_argReturn, registry);
            }
        }
        Handy.writePackedLong(out, this.m_nTarget);
        if (this.isAssignOp()) {
            Handy.writePackedLong(out, this.m_nRetValue);
        }
    }

    protected boolean isAssignOp() {
        return true;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            if (this.isAssignOp() && frame.isNextRegister(this.m_nRetValue)) {
                frame.introduceVarCopy(this.m_nRetValue, this.m_nPropId);
            }
            return OpPropInPlace.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.processProperty(frameCaller, frameCaller.popStack())) : this.processProperty(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int processProperty(Frame frame, ObjectHandle hTarget) {
        PropertyConstant idProp = (PropertyConstant)frame.getConstant(this.m_nPropId);
        return this.complete(frame, hTarget, idProp);
    }

    protected int complete(Frame frame, ObjectHandle hTarget, PropertyConstant idProp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetSimulation() {
        if (this.isAssignOp()) {
            OpPropInPlace.resetRegister(this.m_argReturn);
        }
    }

    @Override
    public void simulate(Scope scope) {
        if (this.isAssignOp()) {
            OpPropInPlace.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argTarget = OpPropInPlace.registerArgument(this.m_argTarget, registry);
        if (this.isAssignOp()) {
            this.m_argReturn = OpPropInPlace.registerArgument(this.m_argReturn, registry);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argReturn, this.m_nTarget);
    }
}

