/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpProperty;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public abstract class OpPropInPlaceAssign
extends OpProperty {
    protected int m_nTarget;
    protected int m_nValue;
    private Argument m_argTarget;
    private Argument m_argValue;

    protected OpPropInPlaceAssign(PropertyConstant idProp, Argument argTarget, Argument argVal) {
        super(idProp);
        this.m_argTarget = argTarget;
        this.m_argValue = argVal;
    }

    protected OpPropInPlaceAssign(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = OpPropInPlaceAssign.encodeArgument(this.m_argTarget, registry);
            this.m_nValue = OpPropInPlaceAssign.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nValue);
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nTarget, this.m_nValue}, 2);
            if (OpPropInPlaceAssign.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.processProperty(frameCaller, ahArg[0], ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.processProperty(frame, ahArg[0], ahArg[1]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int processProperty(Frame frame, ObjectHandle hTarget, ObjectHandle hValue) {
        PropertyConstant idProp = (PropertyConstant)frame.getConstant(this.m_nPropId);
        return this.complete(frame, hTarget, idProp, hValue);
    }

    protected int complete(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, ObjectHandle hValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argTarget = OpPropInPlaceAssign.registerArgument(this.m_argTarget, registry);
        this.m_argValue = OpPropInPlaceAssign.registerArgument(this.m_argValue, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argValue, this.m_nValue);
    }
}

