/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.util.Handy;

public abstract class OpProperty
extends Op {
    protected int m_nPropId;
    protected PropertyConstant m_idProp;

    protected OpProperty(PropertyConstant idProp) {
        this.m_idProp = idProp;
    }

    protected OpProperty(DataInput in, Constant[] aconst) throws IOException {
        this.m_nPropId = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_idProp != null) {
            this.m_nPropId = OpProperty.encodeArgument(this.m_idProp, registry);
        }
        Handy.writePackedLong(out, this.m_nPropId);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_idProp = (PropertyConstant)OpProperty.registerArgument(this.m_idProp, registry);
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_idProp, this.m_nPropId);
    }
}

