/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import org.xvm.asm.Op;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;

public abstract class OpReturn
extends Op {
    protected boolean m_fCallFinally;
    protected int m_ixAllGuard;

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
    }

    @Override
    public boolean advances() {
        return false;
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        super.resolveAddresses(aop);
        int nGuardAllDepth = this.getGuardAllDepth();
        if (nGuardAllDepth > 0) {
            Op opFinally = this.findFirstUnmatchedOp(aop, 11, 12);
            assert (opFinally.getGuardAllDepth() == nGuardAllDepth);
            this.m_ixAllGuard = opFinally.getGuardDepth() + nGuardAllDepth - 1;
            this.m_fCallFinally = true;
        }
    }

    public void buildReturn(BuildContext bctx, CodeBuilder code, int[] anRet) {
        int cRets = anRet.length;
        assert (cRets > 0);
        JitMethodDesc jmd = bctx.jmd;
        boolean fOptimized = bctx.isOptimized;
        block6: for (int i = cRets - 1; i >= 0; --i) {
            int iOpt = fOptimized ? jmd.getOptimizedReturnIndex(i) : -1;
            JitParamDesc pdRet = fOptimized ? jmd.optimizedReturns[iOpt] : jmd.standardReturns[i];
            BuildContext.Slot slot = bctx.loadArgument(code, anRet[i], pdRet);
            ClassDesc cd = slot.cd();
            if (i == 0) {
                switch (pdRet.flavor) {
                    case MultiSlotPrimitive: {
                        assert (fOptimized);
                        if (cd.isPrimitive()) {
                            code.iconst_0();
                            Builder.storeToContext(code, ConstantDescs.CD_boolean, 0);
                            Builder.addReturn(code, cd);
                            break;
                        }
                        assert (slot.type().isOnlyNullable());
                        code.pop().iconst_1();
                        Builder.storeToContext(code, ConstantDescs.CD_boolean, 0);
                        Builder.defaultLoad(code, pdRet.cd);
                        Builder.addReturn(code, pdRet.cd);
                        break;
                    }
                    default: {
                        Builder.addReturn(code, cd);
                        break;
                    }
                }
                continue;
            }
            switch (pdRet.flavor) {
                case MultiSlotPrimitive: {
                    assert (fOptimized);
                    JitParamDesc pdExt = jmd.optimizedReturns[iOpt + 1];
                    if (cd.isPrimitive()) {
                        Builder.storeToContext(code, cd, pdRet.altIndex);
                        code.iconst_0();
                        Builder.storeToContext(code, ConstantDescs.CD_boolean, pdExt.altIndex);
                        continue block6;
                    }
                    assert (slot.type().isOnlyNullable());
                    Builder.defaultLoad(code, pdRet.cd);
                    Builder.storeToContext(code, cd, pdRet.altIndex);
                    code.iconst_1();
                    Builder.storeToContext(code, ConstantDescs.CD_boolean, pdExt.altIndex);
                    continue block6;
                }
                default: {
                    Builder.storeToContext(code, cd, pdRet.altIndex);
                }
            }
        }
    }
}

