/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.Label;
import java.lang.constant.ClassDesc;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.Op;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.javajit.TypeSystem;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public abstract class OpTest
extends Op {
    protected int m_nType;
    protected int m_nValue1;
    protected int m_nValue2;
    protected int m_nRetValue;
    protected TypeConstant m_typeCommon;
    protected Argument m_argVal1;
    protected Argument m_argVal2;
    protected Argument m_argReturn;

    protected OpTest(Argument arg, Argument argReturn) {
        assert (!this.isBinaryOp() && !this.hasSecondArgument());
        this.m_argVal1 = arg;
        this.m_argReturn = argReturn;
    }

    protected OpTest(Argument arg1, Argument arg2, Argument argReturn) {
        assert (this.hasSecondArgument() && !this.isBinaryOp());
        this.m_argVal1 = arg1;
        this.m_argVal2 = arg2;
        this.m_argReturn = argReturn;
    }

    protected OpTest(TypeConstant type, Argument arg1, Argument arg2, Argument argReturn) {
        assert (this.isBinaryOp());
        this.m_typeCommon = type;
        this.m_argVal1 = arg1;
        this.m_argVal2 = arg2;
        this.m_argReturn = argReturn;
    }

    protected OpTest(DataInput in, Constant[] aconst) throws IOException {
        if (this.isBinaryOp()) {
            this.m_nType = Handy.readPackedInt(in);
        }
        this.m_nValue1 = Handy.readPackedInt(in);
        if (this.hasSecondArgument()) {
            this.m_nValue2 = Handy.readPackedInt(in);
        }
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_typeCommon != null) {
            this.m_nType = OpTest.encodeArgument(this.m_typeCommon, registry);
            this.m_typeCommon = null;
        }
        if (this.m_argVal1 != null) {
            this.m_nValue1 = OpTest.encodeArgument(this.m_argVal1, registry);
        }
        if (this.m_argVal2 != null) {
            this.m_nValue2 = OpTest.encodeArgument(this.m_argVal2, registry);
        }
        if (this.m_argReturn != null) {
            this.m_nRetValue = OpTest.encodeArgument(this.m_argReturn, registry);
        }
        if (this.isBinaryOp()) {
            Handy.writePackedLong(out, this.m_nType);
        }
        Handy.writePackedLong(out, this.m_nValue1);
        if (this.hasSecondArgument()) {
            Handy.writePackedLong(out, this.m_nValue2);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    protected boolean isBinaryOp() {
        return false;
    }

    protected boolean hasSecondArgument() {
        return this.isBinaryOp();
    }

    @Override
    public int process(Frame frame, int iPC) {
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, this.getResultType(frame));
        }
        return this.isBinaryOp() ? this.processBinaryOp(frame) : this.processUnaryOp(frame);
    }

    protected int processUnaryOp(Frame frame) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nValue1);
            return OpTest.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.completeUnaryOp(frameCaller, frameCaller.popStack())) : this.completeUnaryOp(frame, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int processBinaryOp(Frame frame) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nValue1, this.m_nValue2}, 2);
            TypeConstant typeCommon = this.calculateCommonType(frame);
            if (OpTest.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.completeBinaryOp(frame, typeCommon, ahArg[0], ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.completeBinaryOp(frame, typeCommon, ahArg[0], ahArg[1]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected TypeConstant calculateCommonType(Frame frame) {
        TypeConstant typeCommon = this.m_typeCommon;
        if (typeCommon == null) {
            this.m_typeCommon = typeCommon = (TypeConstant)frame.getConstant(this.m_nType);
        }
        return frame.resolveType(typeCommon);
    }

    protected int completeUnaryOp(Frame frame, ObjectHandle hValue) {
        throw new UnsupportedOperationException();
    }

    protected int completeBinaryOp(Frame frame, TypeConstant type, ObjectHandle hValue1, ObjectHandle hValue2) {
        throw new UnsupportedOperationException();
    }

    protected TypeConstant getResultType(Frame frame) {
        return frame.poolContext().typeBoolean();
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        if (this.isBinaryOp()) {
            this.m_typeCommon = (TypeConstant)OpTest.registerArgument(this.m_typeCommon, registry);
        }
        this.m_argVal1 = OpTest.registerArgument(this.m_argVal1, registry);
        if (this.hasSecondArgument()) {
            this.m_argVal2 = OpTest.registerArgument(this.m_argVal2, registry);
        }
        this.m_argReturn = OpTest.registerArgument(this.m_argReturn, registry);
    }

    @Override
    public void resetSimulation() {
        OpTest.resetRegister(this.m_argReturn);
    }

    @Override
    public void simulate(Scope scope) {
        OpTest.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(' ');
        if (this.isBinaryOp()) {
            sb.append(Argument.toIdString(this.m_typeCommon, this.m_nType)).append(", ");
        }
        sb.append(Argument.toIdString(this.m_argVal1, this.m_nValue1));
        if (this.hasSecondArgument()) {
            sb.append(", ").append(Argument.toIdString(this.m_argVal2, this.m_nValue2));
        }
        return sb.append(", ").append(Argument.toIdString(this.m_argReturn, this.m_nRetValue)).toString();
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        Label lblEnd;
        Label lblTrue;
        TypeSystem ts = bctx.typeSystem;
        BuildContext.Slot slot1 = bctx.loadArgument(code, this.m_nValue1);
        BuildContext.Slot slot2 = bctx.loadArgument(code, this.m_nValue2);
        TypeConstant typeCommon = OpTest.selectCommonType(slot1.type(), slot2.type(), ErrorListener.BLACKHOLE);
        assert (typeCommon.equals(bctx.getConstant(this.m_nType)));
        if (typeCommon.isPrimitive()) {
            String desc;
            ClassDesc cdCommon = JitTypeDesc.getPrimitiveClass(typeCommon);
            lblTrue = code.newLabel();
            lblEnd = code.newLabel();
            block10 : switch (desc = cdCommon.descriptorString()) {
                case "I": 
                case "S": 
                case "B": 
                case "C": 
                case "Z": {
                    switch (this.getOpCode()) {
                        case 104: {
                            code.isub();
                            bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, typeCommon));
                            return;
                        }
                        case 109: {
                            code.if_icmpeq(lblTrue);
                            break block10;
                        }
                        case 110: {
                            code.if_icmpne(lblTrue);
                            break block10;
                        }
                        case 113: {
                            code.if_icmpgt(lblTrue);
                            break block10;
                        }
                        case 114: {
                            code.if_icmpge(lblTrue);
                            break block10;
                        }
                        case 111: {
                            code.if_icmplt(lblTrue);
                            break block10;
                        }
                        case 112: {
                            code.if_icmple(lblTrue);
                            break block10;
                        }
                    }
                    throw new IllegalStateException();
                }
                case "J": 
                case "F": 
                case "D": {
                    switch (desc) {
                        case "J": {
                            code.lcmp();
                            break;
                        }
                        case "F": {
                            code.fcmpl();
                            break;
                        }
                        case "D": {
                            code.dcmpl();
                        }
                    }
                    switch (this.getOpCode()) {
                        case 104: {
                            bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, typeCommon));
                            return;
                        }
                        case 109: {
                            code.ifeq(lblTrue);
                            break block10;
                        }
                        case 110: {
                            code.ifne(lblTrue);
                            break block10;
                        }
                        case 113: {
                            code.ifgt(lblTrue);
                            break block10;
                        }
                        case 114: {
                            code.ifge(lblTrue);
                            break block10;
                        }
                        case 111: {
                            code.iflt(lblTrue);
                            break block10;
                        }
                        case 112: {
                            code.ifle(lblTrue);
                            break block10;
                        }
                    }
                    throw new IllegalStateException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            SignatureConstant sigEquals = bctx.pool().sigEquals();
            MethodInfo method = typeCommon.ensureTypeInfo().getMethodBySignature(sigEquals);
            JitMethodDesc jmd = method.getJitDesc(ts);
            throw new UnsupportedOperationException("call equals");
        }
        code.iconst_0().goto_(lblEnd).labelBinding(lblTrue).iconst_1().labelBinding(lblEnd);
        bctx.storeValue(code, bctx.ensureSlot(this.m_nRetValue, bctx.pool().typeBoolean()));
    }
}

