/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.Register;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.util.Handy;

public abstract class OpVar
extends Op {
    protected transient Register m_reg;
    protected transient int m_nVar = -1;
    protected int m_nType;

    protected OpVar(Register reg) {
        assert (reg != null);
        this.m_reg = reg;
    }

    protected OpVar(DataInput in, Constant[] aconst) throws IOException {
        if (this.isTypeAware()) {
            this.m_nType = Handy.readPackedInt(in);
        }
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.isTypeAware()) {
            this.m_nType = OpVar.encodeArgument(this.getRegisterType(), registry);
            Handy.writePackedLong(out, this.m_nType);
        }
    }

    protected String getName(Constant[] aconst) {
        return null;
    }

    protected String getName(Constant[] aconst, StringConstant constName, int nNameId) {
        if (constName != null) {
            return constName.getValue();
        }
        if (aconst != null) {
            return ((StringConstant)aconst[OpVar.convertId(nNameId)]).getValue();
        }
        try {
            ServiceContext context;
            if (nNameId <= -16 && (context = ServiceContext.getCurrentContext()) != null) {
                return ((StringConstant)context.getCurrentFrame().localConstants()[OpVar.convertId(nNameId)]).getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "?";
    }

    protected TypeConstant getType(Constant[] aconst) {
        return this.m_reg == null ? (TypeConstant)aconst[OpVar.convertId(this.m_nType)] : this.m_reg.getType();
    }

    protected boolean isTypeAware() {
        return true;
    }

    protected TypeComposition getArrayClass(Frame frame, TypeConstant typeList) {
        ServiceContext context = frame.f_context;
        TypeComposition clzArray = (TypeComposition)context.getOpInfo(this, Category.Composition);
        TypeConstant typePrev = (TypeConstant)context.getOpInfo(this, Category.Type);
        if (clzArray == null || !typeList.equals(typePrev)) {
            TypeConstant typeEl = typeList.resolveGenericType("Element");
            clzArray = xArray.INSTANCE.ensureParameterizedClass(context.f_container, typeEl);
            context.setOpInfo(this, Category.Composition, clzArray);
            context.setOpInfo(this, Category.Type, typeList);
        }
        return clzArray;
    }

    public TypeConstant getRegisterType() {
        return this.m_reg.isVar() ? this.m_reg.ensureRegType(!this.m_reg.isWritable()) : this.m_reg.getType();
    }

    public Register getRegister() {
        return this.m_reg;
    }

    @Override
    public void resetSimulation() {
        OpVar.resetRegister(this.m_reg);
    }

    @Override
    public void simulate(Scope scope) {
        this.m_nVar = this.m_reg == null ? scope.allocVar() : this.m_reg.assignIndex(scope.allocVar());
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_reg.registerConstants(registry);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        String sName = this.getName(null);
        if (sName != null) {
            sb.append(' ').append(sName).append(',');
        }
        if (this.isTypeAware()) {
            sb.append(' ').append(Argument.toIdString(null, this.m_nType)).append(',');
        }
        sb.append(' ');
        if (this.m_reg == null) {
            sb.append('#').append(this.m_nVar);
        } else {
            sb.append(this.m_reg);
        }
        return sb.toString();
    }

    static enum Category {
        Composition,
        Type;

    }
}

