/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.List;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constants;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.PackageConstant;
import org.xvm.asm.constants.SingletonConstant;

public class PackageStructure
extends ClassStructure {
    protected PackageStructure(XvmStructure xsParent, int nFlags, PackageConstant constId, ConditionalConstant condition) {
        super(xsParent, nFlags, constId, condition);
    }

    public PackageConstant getPackageConstant() {
        return (PackageConstant)this.getIdentityConstant();
    }

    public boolean isModuleImport() {
        return this.findContribution(Component.Composition.Import) != null;
    }

    public ModuleStructure getImportedModule() {
        Component.Contribution contrib = this.findContribution(Component.Composition.Import);
        return contrib == null ? null : (ModuleStructure)this.getFileStructure().getChild(contrib.getModuleConstant());
    }

    public SingletonConstant getModuleInjector() {
        Component.Contribution contrib = this.findContribution(Component.Composition.Import);
        return contrib == null ? null : contrib.getInjector();
    }

    public List<Component.Injection> getModuleInjections() {
        Component.Contribution contrib = this.findContribution(Component.Composition.Import);
        return contrib == null ? null : contrib.getInjections();
    }

    public void setImportedModule(ModuleStructure module) {
        assert (module != null);
        assert (module.getFileStructure() == this.getFileStructure());
        assert (!this.isModuleImport());
        assert (this.getChildByNameMap().isEmpty());
        this.addImport(module.getIdentityConstant());
    }

    public void setImportedModuleInjector(SingletonConstant constInjector, List<Component.Injection> listInject) {
        assert (this.isModuleImport());
        assert (listInject == null || constInjector != null);
        this.findContribution(Component.Composition.Import).addInjector(constInjector, listInject);
    }

    @Override
    public boolean isPackageContainer() {
        return !this.isModuleImport();
    }

    @Override
    public boolean isClassContainer() {
        return !this.isModuleImport();
    }

    @Override
    public boolean isMethodContainer() {
        return !this.isModuleImport();
    }

    @Override
    public ComponentResolver.ResolutionResult resolveName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector) {
        Component.Contribution contrib = this.findContribution(Component.Composition.Import);
        return contrib == null ? super.resolveName(sName, access, collector) : contrib.getModuleConstant().getComponent().resolveName(sName, access, collector);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof PackageStructure && super.equals(obj);
    }
}

