/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import org.xvm.asm.Annotation;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Register;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.util.Handy;

public class Parameter
extends XvmStructure
implements Cloneable {
    public static final Parameter[] NO_PARAMS = new Parameter[0];
    private Annotation[] m_aAnnotations;
    private TypeConstant m_constType;
    private StringConstant m_constName;
    private Constant m_constDefault;
    private final int f_iParam;
    private final boolean f_fOrdinary;
    private transient boolean m_fHasDefault;
    private transient boolean m_fImplicitDeref;
    private transient Register m_regDeref;

    public Parameter(ConstantPool pool, DataInput in, boolean fReturn, int index, boolean fSpecial) throws IOException {
        super(pool);
        int cAnnos = Handy.readPackedInt(in);
        Annotation[] aAnnos = cAnnos == 0 ? Annotation.NO_ANNOTATIONS : new Annotation[cAnnos];
        for (int i = 0; i < cAnnos; ++i) {
            aAnnos[i] = (Annotation)pool.getConstant(Handy.readMagnitude(in));
        }
        int iType = Handy.readMagnitude(in);
        int iName = fReturn ? Handy.readIndex(in) : Handy.readMagnitude(in);
        int iDefault = Handy.readIndex(in);
        this.m_aAnnotations = aAnnos;
        this.m_constType = (TypeConstant)pool.getConstant(iType);
        this.m_constName = (StringConstant)pool.getConstant(iName);
        this.m_constDefault = pool.getConstant(iDefault);
        this.f_iParam = fReturn ? -1 - index : index;
        this.f_fOrdinary = !fSpecial;
    }

    public Parameter(ConstantPool pool, TypeConstant constType, String sName, Constant constDefault, boolean fReturn, int index, boolean fSpecial) {
        super(pool);
        if (constType == null) {
            throw new IllegalArgumentException("parameter type required");
        }
        if (sName == null && !fReturn) {
            throw new IllegalArgumentException("parameter name required");
        }
        this.m_aAnnotations = Annotation.NO_ANNOTATIONS;
        this.m_constType = constType;
        this.m_constName = sName == null ? null : pool.ensureStringConstant(sName);
        this.m_constDefault = constDefault;
        this.f_iParam = fReturn ? -1 - index : index;
        this.f_fOrdinary = !fSpecial;
    }

    public int getIndex() {
        int iParam = this.f_iParam;
        return iParam >= 0 ? iParam : -1 - iParam;
    }

    public boolean isParameter() {
        return this.f_iParam >= 0;
    }

    public Annotation[] getAnnotations() {
        return this.m_aAnnotations;
    }

    public void addAnnotation(Annotation anno) {
        assert (this.isParameter());
        int cAnnos = this.m_aAnnotations.length;
        if (cAnnos == 0) {
            this.m_aAnnotations = new Annotation[]{anno};
        } else {
            Annotation[] aAnnos = new Annotation[cAnnos + 1];
            System.arraycopy(this.m_aAnnotations, 0, aAnnos, 0, cAnnos);
            aAnnos[cAnnos] = anno;
            this.m_aAnnotations = aAnnos;
        }
    }

    public boolean resolveAnnotations() {
        TypeConstant typeParam = this.m_constType;
        if (typeParam.containsUnresolved()) {
            return false;
        }
        if (!typeParam.isAnnotated()) {
            return true;
        }
        int cExtract = 0;
        TypeConstant typeBase = typeParam.resolveTypedefs();
        while (typeBase instanceof AnnotatedTypeConstant) {
            AnnotatedTypeConstant typeAnnotated = (AnnotatedTypeConstant)typeBase;
            Annotation anno = typeAnnotated.getAnnotation();
            TypeConstant typeAnno = anno.getAnnotationType();
            if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
                return true;
            }
            TypeConstant typeInto = typeAnno.getExplicitClassInto();
            if (typeInto.containsUnresolved()) {
                return false;
            }
            if (typeInto.isIntoMethodParameterType()) {
                ++cExtract;
            }
            typeBase = typeAnnotated.getUnderlyingType();
        }
        if (cExtract == 0) {
            return true;
        }
        Annotation[] aAnnos = typeParam.getAnnotations();
        int cAll = aAnnos.length;
        if (cExtract == cAll) {
            this.m_aAnnotations = aAnnos;
            this.m_constType = typeBase;
            return true;
        }
        int cKeep = cAll - cExtract;
        Annotation[] aKeep = new Annotation[cKeep];
        Annotation[] aMove = new Annotation[cExtract];
        int iKeep = 0;
        int iMove = 0;
        for (Annotation annotation : aAnnos) {
            if (annotation.getAnnotationType().getExplicitClassInto().isIntoMethodParameterType()) {
                aMove[iMove++] = annotation;
                continue;
            }
            aKeep[iKeep++] = annotation;
        }
        this.m_constType = this.getConstantPool().ensureAnnotatedTypeConstant(typeBase, aKeep);
        this.m_aAnnotations = aMove;
        return true;
    }

    public TypeConstant getType() {
        return this.m_constType;
    }

    public boolean isTypeParameter() {
        return this.isParameter() && !this.f_fOrdinary;
    }

    public TypeParameterConstant asTypeParameterConstant(MethodConstant constMethod) {
        assert (this.isTypeParameter());
        return this.getConstantPool().ensureRegisterConstant(constMethod, this.f_iParam, this.getName());
    }

    public TypeConstant asTypeParameterType(MethodConstant constMethod) {
        return this.getConstantPool().ensureTerminalTypeConstant(this.asTypeParameterConstant(constMethod));
    }

    public boolean isConditionalReturn() {
        return !this.isParameter() && !this.f_fOrdinary;
    }

    public boolean isNamed() {
        return this.m_constName != null;
    }

    public String getName() {
        return this.m_constName == null ? null : this.m_constName.getValue();
    }

    public StringConstant getNameConstant() {
        return this.m_constName;
    }

    public void markDefaultValue() {
        this.m_fHasDefault = true;
    }

    public boolean hasDefaultValue() {
        return this.m_fHasDefault || this.m_constDefault != null;
    }

    public Constant getDefaultValue() {
        return this.m_constDefault;
    }

    public void setDefaultValue(Constant constDefault) {
        assert (this.hasDefaultValue());
        assert (constDefault != null);
        this.m_constDefault = constDefault;
    }

    public void markImplicitDeref() {
        assert (this.getType().isA(this.getConstantPool().typeRef()));
        this.m_fImplicitDeref = true;
    }

    public boolean isImplicitDeref() {
        return this.m_fImplicitDeref;
    }

    public Register deref(Register regVar, MethodStructure method) {
        assert (this.isImplicitDeref());
        if (this.m_regDeref == null) {
            TypeConstant typeVar = this.getType();
            TypeConstant typeVal = typeVar.getParamType(0);
            Register reg = new Register(typeVal, null, method);
            reg.specifyRegType(typeVar);
            this.m_regDeref = reg;
        }
        return this.m_regDeref;
    }

    protected Parameter cloneBody() {
        Parameter that;
        try {
            that = (Parameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        this.m_fImplicitDeref = false;
        this.m_regDeref = null;
        return that;
    }

    @Override
    protected void markModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void disassemble(DataInput in) {
        throw new IllegalStateException();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_aAnnotations = (Annotation[])Constant.registerConstants(pool, this.m_aAnnotations);
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
        this.m_constName = (StringConstant)pool.register(this.m_constName);
        this.m_constDefault = pool.register(this.m_constDefault);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        Handy.writePackedLong(out, this.m_aAnnotations.length);
        for (Annotation anno : this.m_aAnnotations) {
            Handy.writePackedLong(out, anno.getPosition());
        }
        Handy.writePackedLong(out, Constant.indexOf(this.m_constType));
        Handy.writePackedLong(out, Constant.indexOf(this.m_constName));
        Handy.writePackedLong(out, Constant.indexOf(this.m_constDefault));
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isParameter() ? "param" : "return").append("-index=").append(this.getIndex());
        if (this.isTypeParameter()) {
            sb.append(" (type parameter)");
        } else if (this.isConditionalReturn()) {
            sb.append(" (conditional return)");
        }
        sb.append(", type=").append(this.m_constType.getValueString());
        if (this.isNamed()) {
            sb.append(", name=").append(this.getName());
        }
        if (this.hasDefaultValue()) {
            sb.append(", has default");
            if (this.m_constDefault != null) {
                sb.append("=").append(this.m_constDefault.getValueString());
            }
        }
        return sb.toString();
    }

    @Override
    protected void dump(PrintWriter out, String sIndent) {
        out.print(sIndent);
        out.println(this);
    }

    @Override
    public int hashCode() {
        return this.f_iParam;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)obj;
        return this.f_iParam == that.f_iParam && this.f_fOrdinary == that.f_fOrdinary && this.m_constType.equals(that.m_constType) && Handy.equals(this.m_constName, that.m_constName) && Handy.equals(this.m_constDefault, that.m_constDefault);
    }
}

