/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.InjectionKey;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.DeferredValueConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.LinkedIterator;

public class PropertyStructure
extends Component {
    private Constants.Access m_accessVar;
    private TypeConstant m_type;
    private Constant m_constVal;
    private transient boolean m_fNative;
    private transient Annotation[] m_aPropAnno;
    private transient Annotation[] m_aRefAnno;

    protected PropertyStructure(XvmStructure xsParent, int nFlags, PropertyConstant constId, ConditionalConstant condition) {
        super(xsParent, nFlags, constId, condition);
    }

    protected PropertyStructure(XvmStructure xsParent, int nFlags, PropertyConstant constId, ConditionalConstant condition, Constants.Access access2, TypeConstant type) {
        this(xsParent, nFlags, constId, condition);
        if (access2 != null) {
            this.setVarAccess(access2);
        }
        if (type != null) {
            this.setType(type);
        }
    }

    @Override
    public PropertyConstant getIdentityConstant() {
        return (PropertyConstant)super.getIdentityConstant();
    }

    @Override
    public void setAccess(Constants.Access access) {
        super.setAccess(access);
        if (access.ordinal() > this.getVarAccess().ordinal()) {
            this.setVarAccess(access);
        }
    }

    public boolean isConstant() {
        return this.isStatic();
    }

    public boolean isRuntimeConstant() {
        ClassStructure clzParent;
        Component component;
        return this.isConstant() || (component = this.getParent()) instanceof ClassStructure && (clzParent = (ClassStructure)component).isSingleton() && clzParent.isConst() && (this.hasInitialValue() || this.getInitializer() != null) && !this.isTransient();
    }

    public Constants.Access getVarAccess() {
        return this.m_accessVar;
    }

    public void setVarAccess(Constants.Access access) {
        assert (access == null || access.ordinal() >= this.getAccess().ordinal());
        this.m_accessVar = access;
    }

    public boolean isRefAccessible(Constants.Access access) {
        return this.getAccess().ordinal() <= access.ordinal();
    }

    public boolean isVarAccessible(Constants.Access access) {
        Constants.Access accessVar = this.getVarAccess();
        return accessVar == null ? this.isRefAccessible(access) : accessVar.ordinal() <= access.ordinal();
    }

    public TypeConstant getType() {
        return this.m_type;
    }

    public void setType(TypeConstant type) {
        assert (type != null);
        this.m_type = type;
        this.getIdentityConstant().invalidateCache();
    }

    public boolean isGenericTypeParameter() {
        return this.isAuxiliary();
    }

    public void markAsGenericTypeParameter() {
        assert (!this.isStatic() && !this.isSynthetic() && this.m_type.isTypeOfType());
        this.markAuxiliary();
    }

    public boolean containsPropertyAnnotation(IdentityConstant idAnno) {
        for (Annotation anno : this.getPropertyAnnotations()) {
            if (!anno.getAnnotationClass().equals(idAnno)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getPropertyAnnotations() {
        Annotation[] aAnno = this.m_aPropAnno;
        if (aAnno == null) {
            this.buildAnnotationArrays();
            aAnno = this.m_aPropAnno;
            assert (aAnno != null);
        }
        return aAnno;
    }

    public boolean isExplicitReadOnly() {
        return this.containsPropertyAnnotation(this.getConstantPool().clzRO());
    }

    public boolean isExplicitOverride() {
        return this.containsPropertyAnnotation(this.getConstantPool().clzOverride());
    }

    public boolean isTransient() {
        return this.containsPropertyAnnotation(this.getConstantPool().clzTransient());
    }

    public boolean isRefAnnotated() {
        return this.getRefAnnotations().length > 0;
    }

    public boolean isAtomic() {
        return this.containsRefAnnotation(this.getConstantPool().clzAtomic());
    }

    public boolean isFuture() {
        return this.containsRefAnnotation(this.getConstantPool().clzFuture());
    }

    public boolean isInjected() {
        return this.containsRefAnnotation(this.getConstantPool().clzInject());
    }

    public boolean isSimple() {
        return !this.isRefAnnotated() && !this.hasChildren();
    }

    public boolean isSimpleUnassigned() {
        Annotation[] aAnnos = this.getRefAnnotations();
        return aAnnos.length == 1 && aAnnos[0].getAnnotationClass().equals(this.getConstantPool().clzUnassigned());
    }

    public boolean containsRefAnnotation(IdentityConstant idAnno) {
        for (Annotation anno : this.getRefAnnotations()) {
            if (!anno.getAnnotationClass().equals(idAnno)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getRefAnnotations() {
        Annotation[] aAnno = this.m_aRefAnno;
        if (aAnno == null) {
            this.buildAnnotationArrays();
            aAnno = this.m_aRefAnno;
            assert (aAnno != null);
        }
        return aAnno;
    }

    private void buildAnnotationArrays() {
        ConstantPool pool = this.getConstantPool();
        ArrayList<Annotation> listPropAnno = null;
        ArrayList<Annotation> listRefAnno = null;
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            if (contrib.getComposition() != Component.Composition.Annotation) continue;
            Annotation annotation = contrib.getAnnotation();
            Constant constAnno = annotation.getAnnotationClass();
            TypeConstant typeAnno = pool.ensureTerminalTypeConstant(constAnno);
            if (typeAnno.isExplicitClassIdentity(true) && typeAnno.getExplicitClassFormat() == Component.Format.ANNOTATION && pool.typeProperty().equals(typeAnno.getExplicitClassInto().getIntoPropertyType())) {
                if (listPropAnno == null) {
                    listPropAnno = new ArrayList<Annotation>();
                }
                listPropAnno.add(annotation);
                continue;
            }
            if (listRefAnno == null) {
                listRefAnno = new ArrayList<Annotation>();
            }
            listRefAnno.add(annotation);
        }
        this.m_aPropAnno = listPropAnno == null ? Annotation.NO_ANNOTATIONS : listPropAnno.toArray(Annotation.NO_ANNOTATIONS);
        this.m_aRefAnno = listRefAnno == null ? Annotation.NO_ANNOTATIONS : listRefAnno.toArray(Annotation.NO_ANNOTATIONS);
    }

    public boolean hasInitialValue() {
        return this.m_constVal != null;
    }

    public Constant getInitialValue() {
        return this.m_constVal;
    }

    public void setInitialValue(Constant constVal) {
        this.m_constVal = constVal;
    }

    public void indicateInitialValue() {
        this.setInitialValue(new DeferredValueConstant(this.getConstantPool()));
    }

    public MethodStructure getInitializer() {
        Collection<MethodStructure> methods;
        MultiMethodStructure mmInit = (MultiMethodStructure)this.getChild("=");
        if (mmInit != null && (methods = mmInit.methods()) != null && !methods.isEmpty()) {
            return methods.iterator().next();
        }
        return null;
    }

    public MethodStructure getGetter() {
        MultiMethodStructure mms = (MultiMethodStructure)this.getChild("get");
        if (mms != null) {
            for (MethodStructure method : mms.methods()) {
                Parameter[] aParamReturn;
                if (method.getParamArray().length > 0 || (aParamReturn = method.getReturnArray()).length != 1 || !aParamReturn[0].getType().equals(this.getType())) continue;
                return method;
            }
        }
        return null;
    }

    public MethodStructure getSetter() {
        MultiMethodStructure mms = (MultiMethodStructure)this.getChild("set");
        if (mms != null) {
            for (MethodStructure method : mms.methods()) {
                Parameter[] aParam;
                if (method.getReturnArray().length > 0 || (aParam = method.getParamArray()).length != 1 || !aParam[0].getType().equals(this.getType())) continue;
                return method;
            }
        }
        return null;
    }

    public boolean isNative() {
        return this.m_fNative;
    }

    public void markNative() {
        this.m_fNative = true;
    }

    public boolean isSubstitutableFor(ConstantPool pool, SignatureConstant sigThat, List<TypeConstant> listActual) {
        assert (this.getName().equals(sigThat.getName()));
        assert (sigThat.getParamCount() == 0);
        assert (sigThat.getReturnCount() == 1);
        SignatureConstant sigThis = this.getIdentityConstant().getSignature();
        if (!listActual.isEmpty()) {
            ClassStructure clzThis;
            ClassStructure classStructure = clzThis = (ClassStructure)this.getParent();
            Objects.requireNonNull(classStructure);
            sigThis = sigThis.resolveGenericTypes(pool, classStructure.new ClassStructure.SimpleTypeResolver(pool, listActual));
        }
        return sigThat.equals(sigThis) || sigThat.isSubstitutableFor(sigThis, null) && sigThis.isSubstitutableFor(sigThat, null);
    }

    public boolean resolveAnnotations() {
        List<Component.Contribution> listContribs = this.getContributionsAsList();
        if (listContribs.isEmpty()) {
            return true;
        }
        TypeConstant typeProp = this.getType();
        if (typeProp.containsUnresolved()) {
            return false;
        }
        ArrayList<Component.Contribution> listMove = null;
        for (Component.Contribution contrib : listContribs) {
            Component.Contribution contribExtends;
            if (contrib.getComposition() != Component.Composition.Annotation) continue;
            Annotation annotation = contrib.getAnnotation();
            if (annotation.getAnnotationClass().containsUnresolved()) {
                return false;
            }
            ClassStructure structAnno = (ClassStructure)((IdentityConstant)annotation.getAnnotationClass()).getComponent();
            Component.Contribution contribInto = null;
            while (structAnno != null && structAnno.getFormat() == Component.Format.ANNOTATION && (contribInto = structAnno.findContribution(Component.Composition.Into)) == null && (contribExtends = structAnno.findContribution(Component.Composition.Extends)) != null) {
                Constant constExtends;
                TypeConstant typeExtends = contribExtends.getTypeConstant();
                if (typeExtends.containsUnresolved()) {
                    return false;
                }
                structAnno = null;
                if (!typeExtends.isExplicitClassIdentity(true) || !((constExtends = typeExtends.getDefiningConstant()) instanceof IdentityConstant)) continue;
                IdentityConstant idExtends = (IdentityConstant)constExtends;
                structAnno = (ClassStructure)idExtends.getComponent();
            }
            boolean fMove = true;
            if (contribInto != null) {
                TypeConstant typeInto = contribInto.getTypeConstant();
                if (typeInto.containsUnresolved()) {
                    return false;
                }
                boolean bl = fMove = !typeInto.isIntoPropertyType();
            }
            if (!fMove) continue;
            if (listMove == null) {
                listMove = new ArrayList<Component.Contribution>();
            }
            listMove.add(contrib);
        }
        if (listMove != null) {
            ConstantPool pool = this.getConstantPool();
            for (int i = listMove.size() - 1; i >= 0; --i) {
                Component.Contribution contrib = (Component.Contribution)listMove.get(i);
                Annotation annotation = contrib.getAnnotation();
                this.removeContribution(contrib);
                typeProp = pool.ensureAnnotatedTypeConstant(annotation.getAnnotationClass(), annotation.getParams(), typeProp);
            }
            this.setType(typeProp);
        }
        return true;
    }

    @Override
    public boolean isClassContainer() {
        return true;
    }

    @Override
    public MethodStructure.ConcurrencySafety getConcurrencySafety() {
        ConstantPool pool = this.getConstantPool();
        if (this.containsPropertyAnnotation(pool.clzSynchronized())) {
            return MethodStructure.ConcurrencySafety.Unsafe;
        }
        if (this.containsPropertyAnnotation(pool.clzConcurrent())) {
            return MethodStructure.ConcurrencySafety.Safe;
        }
        return this.getParent().getConcurrencySafety();
    }

    @Override
    public boolean isMethodContainer() {
        return true;
    }

    @Override
    public boolean isAutoNarrowingAllowed() {
        return !this.isStatic() && this.getParent().isAutoNarrowingAllowed();
    }

    @Override
    public ComponentResolver.ResolutionResult resolveName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector) {
        Component.SimpleCollector collectorTemp = new Component.SimpleCollector(collector.getErrorListener());
        ComponentResolver.ResolutionResult result = this.getType().resolveContributedName(sName, access, null, collectorTemp);
        if (result == ComponentResolver.ResolutionResult.RESOLVED) {
            Constant constant = collectorTemp.getResolvedConstant();
            switch (constant.getFormat()) {
                case Property: {
                    PropertyConstant idProp = (PropertyConstant)constant;
                    if (!idProp.isConstant()) break;
                    collector.resolvedConstant(constant);
                    return ComponentResolver.ResolutionResult.RESOLVED;
                }
                case Class: {
                    ClassConstant idClz = (ClassConstant)constant;
                    ClassStructure clz = (ClassStructure)idClz.getComponent();
                    if (!clz.isSingleton()) break;
                    collector.resolvedConstant(constant);
                    return ComponentResolver.ResolutionResult.RESOLVED;
                }
            }
            return ComponentResolver.ResolutionResult.UNKNOWN;
        }
        return super.resolveName(sName, access, collector);
    }

    @Override
    protected Iterator<IdentityConstant> potentialVirtualChildContributors() {
        ArrayList<IdentityConstant> list = null;
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            if (contrib.getComposition() != Component.Composition.Annotation) continue;
            TypeConstant typeAnno = contrib.getTypeConstant();
            if (typeAnno.containsUnresolved()) {
                return null;
            }
            if (!typeAnno.isIntoVariableType()) continue;
            if (list == null) {
                list = new ArrayList<IdentityConstant>();
            }
            list.add(typeAnno.getSingleUnderlyingClass(true));
        }
        return list == null ? Collections.emptyIterator() : list.iterator();
    }

    @Override
    public void collectInjections(Set<InjectionKey> setInjections) {
        Annotation[] annos;
        if (this.isRefAnnotated() && (annos = this.getRefAnnotations())[0].getAnnotationClass().equals(this.getConstantPool().clzInject())) {
            String string;
            Constant constant;
            Constant[] aconstParam = annos[0].getParams();
            if (aconstParam.length > 0 && (constant = aconstParam[0]) instanceof StringConstant) {
                StringConstant constName = (StringConstant)constant;
                string = constName.getValue();
            } else {
                string = this.getName();
            }
            String sName = string;
            setInjections.add(new InjectionKey(sName, this.getType()));
        }
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        super.addAnnotation(annotation);
        this.m_aPropAnno = null;
        this.m_aRefAnno = null;
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        super.disassemble(in);
        ConstantPool pool = this.getConstantPool();
        byte nAccess = in.readByte();
        this.m_accessVar = nAccess < 0 ? null : Constants.Access.valueOf(nAccess);
        this.m_type = (TypeConstant)pool.getConstant(Handy.readIndex(in));
        int nValue = Handy.readIndex(in);
        if (nValue >= 0) {
            this.m_constVal = pool.getConstant(nValue);
        }
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_type = (TypeConstant)pool.register(this.m_type);
        if (this.m_constVal != null) {
            assert (!(this.m_constVal instanceof DeferredValueConstant));
            this.m_constVal = pool.register(this.m_constVal);
        }
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        assert (!(this.m_constVal instanceof DeferredValueConstant));
        super.assemble(out);
        out.writeByte(this.m_accessVar == null ? -1 : this.m_accessVar.ordinal());
        Handy.writePackedLong(out, this.m_type.getPosition());
        Handy.writePackedLong(out, Constant.indexOf(this.m_constVal));
    }

    @Override
    public Iterator<? extends XvmStructure> getContained() {
        ArrayList<Annotation> listAnno = null;
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            if (contrib.getComposition() != Component.Composition.Annotation) continue;
            if (listAnno == null) {
                listAnno = new ArrayList<Annotation>();
            }
            listAnno.add(contrib.getAnnotation());
        }
        return listAnno == null ? super.getContained() : new LinkedIterator(super.getContained(), listAnno.iterator());
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder().append("id=").append(this.getIdentityConstant().getValueString()).append(this.isGenericTypeParameter() ? ", constraint=" : ", type=").append(this.m_type).append(", ").append("var-access=").append((Object)this.m_accessVar).append(", ");
        return sb.append(super.getDescription()).toString();
    }
}

