/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import org.xvm.asm.Argument;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.NarrowedExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;

public class Register
implements Argument {
    public static final Register DEFAULT = new Register(null, null, -4);
    public static final Register ASYNC = new Register(null, null, -3);
    public static final int UNKNOWN = 1000000000;
    private TypeConstant m_type;
    private String m_sName;
    private TypeConstant m_typeReg;
    private int m_iArg;
    private boolean m_fRO;
    private final int f_nOrigIndex;
    private boolean m_fEffectivelyFinal;
    private boolean m_fMarkedFinal;
    private boolean m_fMarkedUnassigned;
    private transient RegAllocAST m_astAlloc;
    private transient RegisterAST m_astSpecial;

    public Register(TypeConstant type, String sName, MethodStructure method) {
        if (type == null) {
            throw new IllegalArgumentException("type required");
        }
        type = type.resolveTypedefs();
        this.m_fRO = false;
        this.m_type = type;
        this.m_sName = sName;
        this.f_nOrigIndex = this.m_iArg = 1000000000 + (method == null ? 0 : method.getUnassignedRegisterIndex());
    }

    public Register(TypeConstant type, String sName, int iArg) {
        block4: {
            block3: {
                if (type != null) break block3;
                switch (iArg) {
                    case -4: 
                    case -3: 
                    case -2: {
                        break block4;
                    }
                    default: {
                        throw new IllegalArgumentException("type required");
                    }
                }
            }
            type = type.resolveTypedefs();
        }
        Register.validateIndex(iArg);
        this.m_fRO = Register.isPredefinedReadonly(iArg);
        this.m_type = type;
        this.m_sName = sName;
        this.m_iArg = iArg;
        this.f_nOrigIndex = iArg;
    }

    public void markInPlace() {
        throw new IllegalStateException();
    }

    public boolean isInPlace() {
        return true;
    }

    @Override
    public TypeConstant getType() {
        return this.m_type;
    }

    @Override
    public boolean isStack() {
        return this.m_iArg == -1;
    }

    @Override
    public boolean isEffectivelyFinal() {
        return this.m_fEffectivelyFinal || this.isStack();
    }

    @Override
    public Register registerConstants(Op.ConstantRegistry registry) {
        if (this.m_typeReg != null) {
            this.m_typeReg = (TypeConstant)registry.register(this.m_typeReg);
            assert (!this.m_typeReg.containsDynamicType(this));
        } else if (this.m_type != null) {
            if (this.m_type.containsDynamicType(this)) {
                this.m_type = this.m_type.resolveDynamicConstraints(this);
            }
            this.m_type = (TypeConstant)registry.register(this.m_type);
        }
        return this;
    }

    public boolean isVar() {
        return this.m_typeReg != null;
    }

    public TypeConstant ensureRegType(boolean fRO) {
        assert (fRO | !this.m_fRO);
        if (this.m_typeReg != null) {
            return this.m_typeReg;
        }
        ConstantPool pool = this.m_type.getConstantPool();
        return pool.ensureParameterizedTypeConstant(fRO ? pool.typeRef() : pool.typeVar(), this.m_type);
    }

    public void specifyRegType(TypeConstant typeReg) {
        ConstantPool pool = typeReg.getConstantPool();
        assert (this.m_typeReg == null || typeReg.isAnnotated());
        assert (typeReg.isA(pool.typeRef()));
        this.m_typeReg = typeReg;
        if (!typeReg.isA(pool.typeVar())) {
            this.m_fRO = true;
        }
    }

    public void specifyActualType(TypeConstant type) {
        assert (type != null && type.isA(this.m_type));
        this.m_type = type;
    }

    public Register narrowType(TypeConstant typeNarrowed) {
        ShadowRegister regShadow = new ShadowRegister(typeNarrowed, this.m_sName, this.f_nOrigIndex);
        TypeConstant typeReg = this.m_typeReg;
        if (typeReg != null) {
            if (typeReg.isAnnotated() && !typeNarrowed.equals(this.m_type)) {
                ConstantPool pool = typeReg.getConstantPool();
                TypeConstant typeNarrowedReg = pool.ensureParameterizedTypeConstant(this.isVar() ? pool.typeVar() : pool.typeRef(), typeNarrowed);
                typeReg = typeNarrowedReg.adoptAnnotations(pool, typeReg);
            }
            regShadow.specifyRegType(typeReg);
        }
        return regShadow;
    }

    public Register restoreType() {
        return new ShadowRegister(this.getOriginalType(), this.m_sName, this.f_nOrigIndex);
    }

    public Register getOriginalRegister() {
        return this;
    }

    public TypeConstant getOriginalType() {
        return this.getType();
    }

    public String getName() {
        return this.m_sName;
    }

    public int getIndex() {
        return this.m_iArg;
    }

    public int assignIndex(int iArg) {
        if (this.m_iArg < 1000000000 && this.m_iArg != iArg) {
            throw new IllegalStateException("index has already been assigned (old=" + this.m_iArg + ", new=" + iArg);
        }
        Register.validateIndex(iArg);
        this.m_iArg = iArg;
        return this.m_iArg;
    }

    public void resetIndex() {
        this.m_iArg = this.f_nOrigIndex;
    }

    public int getId() {
        assert (this.f_nOrigIndex == this.m_iArg || this.f_nOrigIndex >= 1000000000);
        return this.f_nOrigIndex < 1000000000 ? this.f_nOrigIndex : this.f_nOrigIndex - 1000000000;
    }

    protected static boolean isPredefinedReadonly(int iArg) {
        return switch (iArg) {
            case -16, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4 -> true;
            default -> false;
        };
    }

    public boolean isPredefined() {
        return this.m_iArg < 0;
    }

    public boolean isSuper() {
        return this.m_iArg == -13;
    }

    public boolean isStruct() {
        return this.m_iArg == -10;
    }

    public boolean isLabel() {
        return this.m_iArg == -16;
    }

    public boolean isUnknown() {
        return this.m_iArg >= 1000000000;
    }

    public boolean isReadable() {
        return switch (this.m_iArg) {
            case -16, -3, -2 -> false;
            default -> true;
        };
    }

    public boolean isWritable() {
        return !this.m_fRO;
    }

    public void markEffectivelyFinal() {
        this.m_fRO = true;
        this.m_fEffectivelyFinal = true;
    }

    public boolean isNormal() {
        return !this.isPredefined() && this.isReadable() && this.isWritable() && !this.isVar();
    }

    public void markFinal() {
        this.m_fMarkedFinal = true;
    }

    public boolean isMarkedFinal() {
        return this.m_fMarkedFinal;
    }

    public void markAllowUnassigned() {
        this.m_fMarkedUnassigned = true;
    }

    public boolean isAllowedUnassigned() {
        return this.m_fMarkedUnassigned;
    }

    public RegAllocAST getRegAllocAST() {
        RegAllocAST astAlloc = this.m_astAlloc;
        if (astAlloc == null) {
            StringConstant constName = this.m_sName == null ? null : this.m_type.getConstantPool().ensureStringConstant(this.m_sName);
            astAlloc = this.m_typeReg == null ? new RegAllocAST(this.m_type, constName) : new RegAllocAST(this.m_typeReg, this.m_type, constName);
            this.m_astAlloc = astAlloc;
        }
        return astAlloc;
    }

    public ExprAST getRegisterAST() {
        assert (!this.isStack());
        if (this.isPredefined()) {
            RegisterAST regSpecial = this.m_astSpecial;
            if (regSpecial == null) {
                regSpecial = this.m_astSpecial = new RegisterAST(this.m_iArg, this.getType(), null);
            }
            return regSpecial;
        }
        return this.getRegAllocAST().getRegister();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Register) {
            Register that = (Register)obj;
            if (that instanceof ShadowRegister) {
                assert (!(this instanceof ShadowRegister));
                return false;
            }
            return this.m_iArg == that.m_iArg && this.m_fRO == that.m_fRO && this.m_fEffectivelyFinal == that.m_fEffectivelyFinal && this.isInPlace() == that.isInPlace() && this.getType().equals(that.getType());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_type != null) {
            sb.append(this.m_type.getValueString()).append(' ');
        }
        if (this.m_fEffectivelyFinal) {
            sb.append("@Final ");
        } else if (this.m_fRO) {
            sb.append("@RO ");
        }
        sb.append(this.getIdString());
        return sb.toString();
    }

    public String getIdString() {
        return this.m_iArg >= 1000000000 ? "#? (@" + System.identityHashCode(this) + ")" : Register.getIdString(this.m_iArg);
    }

    protected static void validateIndex(int iReg) {
        if (0 > iReg && iReg >= 1000000000 && !Register.isPredefinedRegister(iReg)) {
            throw new IllegalArgumentException("invalid register ID: " + iReg);
        }
    }

    protected static boolean isPredefinedRegister(int iArg) {
        switch (iArg) {
            case -16: 
            case -13: 
            case -12: 
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                return true;
            }
        }
        if (iArg < 0) {
            throw new IllegalArgumentException("illegal argument index: " + iArg);
        }
        return false;
    }

    public static String getIdString(int nReg) {
        switch (nReg) {
            case -1: {
                return "this:stack";
            }
            case -3: 
            case -2: {
                return "_";
            }
            case -4: {
                return "<default>";
            }
            case -5: {
                return "this";
            }
            case -6: {
                return "this:target";
            }
            case -7: {
                return "this:public";
            }
            case -8: {
                return "this:protected";
            }
            case -9: {
                return "this:private";
            }
            case -10: {
                return "this:struct";
            }
            case -11: {
                return "this:class";
            }
            case -12: {
                return "this:service";
            }
            case -13: {
                return "super";
            }
            case -16: {
                return "<label>";
            }
        }
        return nReg < 1000000000 ? "#" + nReg : "#???";
    }

    private class ShadowRegister
    extends Register {
        private boolean m_fInPlace;
        private ExprAST m_astNarrowed;

        protected ShadowRegister(TypeConstant typeNew, String sName, int iArg) {
            super(typeNew, sName, iArg);
            this.m_fInPlace = false;
        }

        @Override
        public TypeConstant getType() {
            return super.getType();
        }

        @Override
        public Register registerConstants(Op.ConstantRegistry registry) {
            return super.registerConstants(registry);
        }

        @Override
        public void markInPlace() {
            this.m_fInPlace = true;
        }

        @Override
        public boolean isInPlace() {
            return this.m_fInPlace;
        }

        @Override
        public boolean isStack() {
            return Register.this.isStack();
        }

        @Override
        public boolean isEffectivelyFinal() {
            return Register.this.isEffectivelyFinal();
        }

        @Override
        public boolean isVar() {
            return Register.this.isVar();
        }

        @Override
        public TypeConstant ensureRegType(boolean fRO) {
            return super.ensureRegType(fRO);
        }

        @Override
        public void specifyRegType(TypeConstant typeReg) {
            super.specifyRegType(typeReg);
        }

        @Override
        public void specifyActualType(TypeConstant type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Register narrowType(TypeConstant typeNarrowed) {
            return Register.this.narrowType(typeNarrowed);
        }

        @Override
        public Register restoreType() {
            TypeConstant typeOrig = this.getOriginalType();
            return this.getType().equals(typeOrig) ? this : Register.this.narrowType(typeOrig);
        }

        @Override
        public Register getOriginalRegister() {
            return Register.this;
        }

        @Override
        public TypeConstant getOriginalType() {
            return Register.this.getOriginalType();
        }

        @Override
        public int getIndex() {
            return Register.this.getIndex();
        }

        @Override
        public int assignIndex(int iArg) {
            return Register.this.assignIndex(iArg);
        }

        @Override
        public boolean isPredefined() {
            return Register.this.isPredefined();
        }

        @Override
        public boolean isLabel() {
            return false;
        }

        @Override
        public boolean isUnknown() {
            return Register.this.isUnknown();
        }

        @Override
        public boolean isReadable() {
            return Register.this.isReadable();
        }

        @Override
        public boolean isWritable() {
            return Register.this.isWritable();
        }

        @Override
        public void markEffectivelyFinal() {
            Register.this.markEffectivelyFinal();
        }

        @Override
        public void markFinal() {
            Register.this.markFinal();
        }

        @Override
        public boolean isMarkedFinal() {
            return Register.this.isMarkedFinal();
        }

        @Override
        public void markAllowUnassigned() {
            Register.this.markAllowUnassigned();
        }

        @Override
        public boolean isAllowedUnassigned() {
            return Register.this.isAllowedUnassigned();
        }

        @Override
        public RegAllocAST getRegAllocAST() {
            if (this.isInPlace()) {
                return Register.this.getRegAllocAST();
            }
            throw new IllegalStateException();
        }

        @Override
        public ExprAST getRegisterAST() {
            ExprAST astNarrowed = this.m_astNarrowed;
            if (astNarrowed == null) {
                TypeConstant typeNarrowed = this.getType();
                TypeConstant typeOrig = this.getOriginalType();
                ExprAST astOrig = Register.this.getRegisterAST();
                this.m_astNarrowed = typeNarrowed.equals(typeOrig) ? astOrig : new NarrowedExprAST(astOrig, typeNarrowed);
                astNarrowed = this.m_astNarrowed;
            }
            return astNarrowed;
        }

        @Override
        public boolean isNormal() {
            return Register.this.isNormal();
        }

        @Override
        public String getIdString() {
            return "shadow of " + String.valueOf(Register.this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShadowRegister)) return false;
            ShadowRegister that = (ShadowRegister)obj;
            if (!this.getOriginalRegister().equals(that.getOriginalRegister())) return false;
            if (!this.getType().equals(that.getType())) return false;
            return true;
        }
    }
}

