/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import org.xvm.asm.Op;

public class Scope {
    private Scope m_scopeParent;
    private Scope m_scopeChild;
    private Op m_opEnter;
    private int m_cVars;
    private int m_cMaxVars;
    private int m_cMaxDepth;
    private int m_cGuardDepth;
    private int m_cGuardAllDepth;

    public Scope() {
    }

    private Scope(Scope scopeParent, Op opEnter) {
        assert (scopeParent != null);
        this.m_scopeParent = scopeParent;
        this.m_opEnter = opEnter;
    }

    public void enter(Op op) {
        if (this.m_scopeChild == null) {
            this.validate();
            this.m_scopeChild = new Scope(this, op);
        } else {
            this.m_scopeChild.enter(op);
        }
    }

    public Op getEnter() {
        return this.m_opEnter;
    }

    public void exit(Op op) {
        if (this.m_scopeChild == null) {
            Scope scopeParent;
            this.validate();
            if (this.m_cVars == 0 && op.getOpCode() == 6) {
                assert (this.m_opEnter.getOpCode() == 5);
                this.m_opEnter.markRedundant();
                op.markRedundant();
            }
            if ((scopeParent = this.m_scopeParent) != null) {
                scopeParent.tallyDepth(this.m_cMaxDepth);
                scopeParent.tallyVars(this.m_cMaxVars);
                scopeParent.m_scopeChild = null;
            }
            this.m_scopeParent = this;
        } else {
            this.m_scopeChild.exit(op);
        }
    }

    public void enterGuard() {
        ++this.m_cGuardDepth;
    }

    public void exitGuard() {
        --this.m_cGuardDepth;
    }

    public void enterGuardAll() {
        ++this.m_cGuardAllDepth;
    }

    public void exitGuardAll() {
        --this.m_cGuardAllDepth;
    }

    public int allocVar() {
        if (this.m_scopeChild == null) {
            this.validate();
            int iVar = this.m_cVars++;
            if (this.m_cVars > this.m_cMaxVars) {
                this.m_cMaxVars = this.m_cVars;
            }
            return iVar;
        }
        return this.m_cVars + this.m_scopeChild.allocVar();
    }

    public void ensureVar(int iVar) {
        if (this.m_scopeChild == null) {
            this.validate();
            this.m_cVars = Math.max(iVar + 1, this.m_cVars);
            if (this.m_cVars > this.m_cMaxVars) {
                this.m_cMaxVars = this.m_cVars;
            }
        } else {
            this.m_scopeChild.ensureVar(iVar - this.m_cVars);
        }
    }

    public int getCurDepth() {
        return this.m_scopeChild == null ? 1 : this.m_scopeChild.getCurDepth() + 1;
    }

    public int getMaxDepth() {
        return this.m_scopeChild == null ? this.m_cMaxDepth + 1 : this.m_scopeChild.getMaxDepth() + 1;
    }

    public int getCurVars() {
        return this.m_scopeChild == null ? this.m_cVars : this.m_cVars + this.m_scopeChild.getCurVars();
    }

    public int getMaxVars() {
        return this.m_scopeChild == null ? this.m_cMaxVars : Math.max(this.m_cMaxVars, this.m_cVars + this.m_scopeChild.getMaxVars());
    }

    public int getGuardDepth() {
        return this.m_cGuardDepth;
    }

    public int getGuardAllDepth() {
        return this.m_cGuardAllDepth;
    }

    private void validate() {
        if (this.m_scopeParent == this) {
            throw new IllegalStateException("Scope cannot be re-entered after exit");
        }
    }

    private void tallyDepth(int cNested) {
        if (cNested >= this.m_cMaxDepth) {
            this.m_cMaxDepth = cNested + 1;
        }
    }

    private void tallyVars(int cNested) {
        int cTotal = this.m_cVars + cNested;
        if (cTotal > this.m_cMaxVars) {
            this.m_cMaxVars = cTotal;
        }
    }
}

