/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.Version;
import org.xvm.asm.constants.AllCondition;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.NamedCondition;
import org.xvm.asm.constants.PresentCondition;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.asm.constants.VersionMatchesCondition;
import org.xvm.asm.constants.VersionedCondition;
import org.xvm.util.Handy;

public class SimulatedLinkerContext
implements LinkerContext {
    public static final SimulatedLinkerContext EMPTY = new SimulatedLinkerContext(null);
    private final ConditionalConstant cond;
    private Map<ConditionalConstant, ConditionalConstant.Influence> influences = Collections.emptyMap();
    private Set<String> names = Collections.emptySet();
    private Map<IdentityConstant, Boolean> present = Collections.emptyMap();
    private Map<ModuleConstant, Version> modules = Collections.emptyMap();
    private Version version;

    public SimulatedLinkerContext(ConditionalConstant cond) {
        this.cond = cond;
        if (cond != null) {
            this.influences = cond.terminalInfluences();
            this.extractRequiredConditions();
        }
    }

    public SimulatedLinkerContext(ConstantPool pool, ConditionalConstant ... conds) {
        this(SimulatedLinkerContext.toCondition(pool, conds));
    }

    private static ConditionalConstant toCondition(ConstantPool pool, ConditionalConstant[] conds) {
        if (conds == null || conds.length == 0) {
            return null;
        }
        if (conds.length == 1) {
            return conds[0];
        }
        return new AllCondition(pool, conds);
    }

    private void extractRequiredConditions() {
        for (Map.Entry<ConditionalConstant, ConditionalConstant.Influence> entry : this.influences.entrySet()) {
            if (!entry.getValue().isRequired()) continue;
            ConditionalConstant condEach = entry.getKey();
            if (condEach instanceof NamedCondition) {
                if (this.names.isEmpty()) {
                    this.names = new HashSet<String>();
                }
                this.names.add(((NamedCondition)condEach).getName());
                continue;
            }
            if (condEach instanceof PresentCondition) {
                if (this.present.isEmpty()) {
                    this.present = new HashMap<IdentityConstant, Boolean>();
                }
                this.present.put(((PresentCondition)condEach).getPresentConstant(), true);
                continue;
            }
            if (condEach instanceof VersionMatchesCondition) {
                VersionMatchesCondition condModuleVer = (VersionMatchesCondition)condEach;
                if (this.modules.isEmpty()) {
                    this.modules = new HashMap<ModuleConstant, Version>();
                }
                this.modules.put(condModuleVer.getModuleConstant(), condModuleVer.getVersionConstant().getVersion());
                continue;
            }
            if (!(condEach instanceof VersionedCondition)) continue;
            assert (this.version == null);
            this.version = ((VersionedCondition)condEach).getVersion();
        }
    }

    @Override
    public boolean isSpecified(String sName) {
        return this.names.contains(sName);
    }

    @Override
    public boolean isPresent(IdentityConstant constId) {
        if (this.present.isEmpty()) {
            return false;
        }
        Boolean fPresent = this.present.get(constId);
        if (fPresent != null) {
            return fPresent;
        }
        ModuleConstant module = constId.getModuleConstant();
        for (Map.Entry<IdentityConstant, Boolean> entry : this.present.entrySet()) {
            IdentityConstant constIdPresent;
            if (!entry.getValue().booleanValue() || !(constIdPresent = entry.getKey()).getModuleConstant().equals(module)) continue;
            for (IdentityConstant constIdParent = constIdPresent.getNamespace(); constIdParent != null; constIdParent = constIdParent.getNamespace()) {
                if (!constId.equals(constIdParent)) continue;
                this.present.put(constId, true);
                return true;
            }
        }
        this.present.put(constId, false);
        return false;
    }

    @Override
    public boolean isVersionMatch(ModuleConstant constModule, VersionConstant constVer) {
        if (this.modules.isEmpty()) {
            return false;
        }
        Version ver = this.modules.get(constModule);
        return ver != null && ver.equals(constVer.getVersion());
    }

    @Override
    public boolean isVersion(VersionConstant constVer) {
        return this.version != null && this.version.equals(constVer.getVersion());
    }

    public int hashCode() {
        return 11 * this.cond.hashCode();
    }

    public boolean equals(Object obj) {
        SimulatedLinkerContext that;
        return obj instanceof SimulatedLinkerContext && (this == (that = (SimulatedLinkerContext)obj) || Handy.equals(this.cond, that.cond));
    }

    public String toString() {
        return "SimulatedLinkerContext{" + String.valueOf(this.cond) + "}";
    }
}

