/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.util.Handy;

public class TypedefStructure
extends Component {
    private TypeConstant m_type;

    protected TypedefStructure(XvmStructure xsParent, int nFlags, TypedefConstant constId, ConditionalConstant condition) {
        super(xsParent, nFlags, constId, condition);
    }

    @Override
    public TypedefConstant getIdentityConstant() {
        return (TypedefConstant)super.getIdentityConstant();
    }

    public TypeConstant getType() {
        return this.m_type;
    }

    public void setType(TypeConstant type) {
        assert (type != null);
        this.m_type = type;
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        super.disassemble(in);
        this.m_type = (TypeConstant)this.getConstantPool().getConstant(Handy.readIndex(in));
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_type = (TypeConstant)pool.register(this.m_type);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        Handy.writePackedLong(out, this.m_type.getPosition());
    }

    @Override
    public String getDescription() {
        return "type=" + this.m_type + ", " + super.getDescription();
    }
}

