/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.ArrayList;
import org.xvm.util.Handy;

public class Version
implements Comparable<Version> {
    private static final String[] PREFIX = new String[]{"CI", "Dev", "QC", "alpha", "beta", "rc"};
    protected String literal;
    protected int[] ints;
    protected String build;

    public Version(String sLiteral) {
        ArrayList<Integer> listParts = new ArrayList<Integer>();
        String sBuild = null;
        int cLen = sLiteral.length();
        int ix = 0;
        Object sErr = null;
        boolean requiredNumber = false;
        block15: while (ix < cLen) {
            char ch = sLiteral.charAt(ix);
            block0 : switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int n = 0;
                    do {
                        if (n > 200000000) {
                            sErr = "version number overflow";
                            break block0;
                        }
                        n = n * 10 + (sLiteral.charAt(ix++) - 48);
                    } while (ix < cLen && Handy.isDigit(sLiteral.charAt(ix)));
                    listParts.add(n);
                    requiredNumber = false;
                    continue block15;
                }
                case '-': 
                case '.': {
                    if (requiredNumber || ix == 0) {
                        sErr = "number expected; '" + ch + "' found";
                        break;
                    }
                    ++ix;
                    requiredNumber = true;
                    continue block15;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'Q': 
                case 'R': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'q': 
                case 'r': {
                    requiredNumber = false;
                    break;
                }
                case '+': {
                    break;
                }
                default: {
                    sErr = "unknown version component " + Handy.quotedString(sLiteral.substring(ix));
                    break;
                }
            }
            break;
        }
        if (requiredNumber && sErr == null) {
            sErr = "number expected; " + Handy.quotedString(sLiteral.substring(ix) + " found");
        }
        if (sErr == null && ix < cLen) {
            String expectedWord = null;
            switch (sLiteral.charAt(ix)) {
                case 'A': 
                case 'a': {
                    listParts.add(-3);
                    expectedWord = "alpha";
                    break;
                }
                case 'B': 
                case 'b': {
                    listParts.add(-2);
                    expectedWord = "beta";
                    break;
                }
                case 'C': 
                case 'c': {
                    listParts.add(-6);
                    expectedWord = "ci";
                    break;
                }
                case 'D': 
                case 'd': {
                    listParts.add(-5);
                    expectedWord = "dev";
                    break;
                }
                case 'Q': 
                case 'q': {
                    listParts.add(-4);
                    expectedWord = "qa";
                    break;
                }
                case 'R': 
                case 'r': {
                    listParts.add(-1);
                    expectedWord = "rc";
                    break;
                }
                case '+': {
                    break;
                }
                default: {
                    sErr = "illegal character " + Handy.quotedChar(sLiteral.charAt(ix));
                }
            }
            if (expectedWord != null) {
                String word = this.grabLetters(sLiteral, ix);
                int wordlen = word.length();
                ix += wordlen;
                if (wordlen > 1 && !word.equalsIgnoreCase(expectedWord)) {
                    sErr = "expected \"" + expectedWord + "\" but encountered \"" + word + "\"";
                } else if (ix < cLen) {
                    boolean requireDigits = false;
                    char ch = sLiteral.charAt(ix);
                    if (ch == '.' || ch == '-') {
                        requireDigits = true;
                        char c = ch = ++ix < cLen ? (char)sLiteral.charAt(ix) : (char)'?';
                    }
                    if (Handy.isDigit(ch)) {
                        int n = 0;
                        do {
                            if (n > 200000000) {
                                sErr = "version number overflow";
                                break;
                            }
                            n = n * 10 + (ch - 48);
                        } while (++ix < cLen && Handy.isDigit(ch = sLiteral.charAt(ix)));
                        listParts.add(n);
                    } else if (requireDigits) {
                        sErr = "expected trailing version; " + Handy.quotedChar(ch) + " found";
                    }
                }
            }
        }
        if (sErr == null && ix < cLen) {
            if (sLiteral.charAt(ix) == '+') {
                sBuild = sLiteral.substring(ix + 1);
                if (!sBuild.matches("[A-Za-z0-9\\-.]*")) {
                    sErr = "illegal build string \"" + sBuild + "\"; only A-Z, a-z, 0-9, '-', and '.' are permitted";
                }
            } else {
                sErr = "invalid trailing string: " + Handy.quotedString(sLiteral.substring(ix));
            }
        }
        if (sErr == null && listParts.isEmpty()) {
            sErr = "no version number";
        }
        if (sErr != null) {
            throw new IllegalStateException("illegal version string \"" + sLiteral + "\": " + (String)sErr);
        }
        int cParts = listParts.size();
        int[] aiParts = new int[cParts];
        for (int i = 0; i < cParts; ++i) {
            aiParts[i] = (Integer)listParts.get(i);
        }
        this.literal = sLiteral;
        this.ints = aiParts;
        this.build = sBuild;
    }

    public Version(int[] aiParts, String sBuild) {
        assert (aiParts != null);
        StringBuilder sb = new StringBuilder();
        boolean err = aiParts.length == 0;
        boolean fGA = true;
        int c = aiParts.length;
        for (int i = 0; i < c; ++i) {
            int part = aiParts[i];
            if (aiParts[i] >= 0) {
                if (i > 0 && fGA) {
                    sb.append('.');
                }
                sb.append(part);
                continue;
            }
            if (part >= -PREFIX.length) {
                fGA = false;
                switch (c - i) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (aiParts[i + 1] >= 0) break;
                        err = true;
                        break;
                    }
                    default: {
                        err = true;
                    }
                }
                if (i > 0 && aiParts[i - 1] == 0) {
                    err = true;
                }
                if (i > 0) {
                    sb.append('-');
                }
                sb.append(PREFIX[part + PREFIX.length]);
                continue;
            }
            sb.append(".illegal(").append(i).append(')');
            err = true;
        }
        if (sBuild != null && !sBuild.isEmpty()) {
            sb.append('+').append(sBuild);
        }
        this.literal = sb.toString();
        this.ints = aiParts;
        this.build = sBuild;
        if (err) {
            throw new IllegalStateException("illegal version: " + this.literal);
        }
    }

    public boolean isGARelease() {
        for (int part : this.getIntArray()) {
            if (part >= 0) continue;
            return false;
        }
        return true;
    }

    public int getReleaseCategory() {
        for (int part : this.getIntArray()) {
            if (part >= 0) continue;
            return part;
        }
        return 0;
    }

    public String getReleaseCategoryString() {
        int n = this.getReleaseCategory();
        return n < 0 ? PREFIX[n + PREFIX.length] : "ga";
    }

    public boolean isSubstitutableFor(Version that) {
        boolean fThatGA;
        int nVerDif;
        if (this.equals(that)) {
            return true;
        }
        int[] thisInts = this.getIntArray();
        int[] thatInts = that.getIntArray();
        int cThis = thisInts.length;
        int cThisGA = thisInts[cThis - 1] < 0 ? cThis - 1 : (cThis >= 2 && thisInts[cThis - 2] < 0 ? cThis - 2 : cThis);
        int cThat = thatInts.length;
        int cThatGA = thatInts[cThat - 1] < 0 ? cThat - 1 : (cThat >= 2 && thatInts[cThat - 2] < 0 ? cThat - 2 : cThat);
        int iLastGA = Math.min(cThisGA, cThatGA) - 1;
        for (int i = 0; i < iLastGA; ++i) {
            if (thisInts[i] == thatInts[i]) continue;
            return false;
        }
        int n = nVerDif = iLastGA >= 0 ? thisInts[iLastGA] - thatInts[iLastGA] : 0;
        if (nVerDif < 0) {
            return false;
        }
        if (nVerDif > 0) {
            return cThisGA >= cThatGA;
        }
        if (cThisGA > cThatGA) {
            for (i = cThatGA; i < cThisGA; ++i) {
                if (thisInts[i] <= 0) continue;
                return true;
            }
        } else if (cThisGA < cThatGA) {
            for (i = cThisGA; i < cThatGA; ++i) {
                if (thatInts[i] <= 0) continue;
                return false;
            }
        }
        boolean fThisGA = cThis == cThisGA;
        boolean bl = fThatGA = cThat == cThatGA;
        if (!fThisGA || !fThatGA) {
            if (fThisGA ^ fThatGA) {
                return fThisGA;
            }
            int cThisNonGA = cThis - cThisGA;
            int cThatNonGA = cThat - cThatGA;
            int cSharedNonGA = Math.min(cThisNonGA, cThatNonGA);
            assert (cSharedNonGA == 1 || cSharedNonGA == 2);
            for (int of = 0; of < cSharedNonGA; ++of) {
                nVerDif = thisInts[cThisGA + of] - thatInts[cThatGA + of];
                if (nVerDif < 0) {
                    return false;
                }
                if (nVerDif <= 0) continue;
                return true;
            }
            if (cThisNonGA != cThatNonGA) {
                return cThisNonGA > cThatNonGA;
            }
        }
        return true;
    }

    public boolean isSameAs(Version that) {
        if (this.equals(that)) {
            return true;
        }
        int[] thisInts = this.getIntArray();
        int[] thatInts = that.getIntArray();
        int cThis = thisInts.length;
        int cThat = thatInts.length;
        int cShared = Math.min(cThis, cThat);
        for (int i = 0; i < cShared; ++i) {
            if (thisInts[i] == thatInts[i]) continue;
            return false;
        }
        if (cThis != cThat) {
            int[] remaining = cThis > cThat ? thisInts : thatInts;
            int c = remaining.length;
            for (int i = cShared; i < c; ++i) {
                if (thatInts[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public Version normalize() {
        int[] parts = this.getIntArray();
        int cParts = parts.length;
        int cZeros = 0;
        for (int i = cParts - 1; i > 0 && parts[i] == 0; --i) {
            ++cZeros;
        }
        if (cZeros == 0) {
            return this;
        }
        int[] partsNew = new int[cParts - cZeros];
        System.arraycopy(parts, 0, partsNew, 0, cParts - cZeros);
        return new Version(partsNew, this.build);
    }

    public int getPartCount() {
        return this.ints.length;
    }

    public int getPart(int i) {
        assert (i >= 0 && i < this.getPartCount());
        return this.ints[i];
    }

    public String getBuildString() {
        return this.build;
    }

    public Version withoutBuildString() {
        return this.build == null ? this : new Version(this.ints, null);
    }

    @Override
    public int compareTo(Version that) {
        int[] thisParts = this.getIntArray();
        int[] thatParts = that.getIntArray();
        int nDefault = thisParts.length - thatParts.length;
        int c = Math.min(thisParts.length, thatParts.length);
        for (int i = 0; i < c; ++i) {
            if (thisParts[i] == thatParts[i]) continue;
            return thisParts[i] - thatParts[i];
        }
        return nDefault;
    }

    public String toString() {
        return this.literal;
    }

    public int hashCode() {
        return this.literal.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Version && this.literal.equals(((Version)obj).literal);
    }

    private String grabLetters(String sLiteral, int of) {
        int start = of;
        int strlen = sLiteral.length();
        while (of < strlen && Character.isLetter(sLiteral.charAt(of))) {
            ++of;
        }
        return sLiteral.substring(start, of);
    }

    protected int[] getIntArray() {
        return this.ints;
    }
}

