/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.xvm.asm.Version;
import org.xvm.util.Handy;

public class VersionTree<V>
implements Iterable<Version> {
    Node<V> root;
    int count;

    public VersionTree() {
        this.clear();
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    @Override
    public Iterator<Version> iterator() {
        return new Iterator<Version>(){
            private Node prev;
            private Node next;
            {
                this.prev = VersionTree.this.root;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.loadNext() != null;
            }

            @Override
            public Version next() {
                Node node;
                this.prev = node = this.loadNext();
                this.next = null;
                if (node == null) {
                    throw new NoSuchElementException();
                }
                return node.getVersion();
            }

            private Node loadNext() {
                if (this.next != null) {
                    return this.next;
                }
                if (this.prev == null) {
                    return null;
                }
                Node[] kids = this.prev.kids;
                if (kids != null && kids[0] != null) {
                    this.next = kids[0].firstContainedPresent();
                    return this.next;
                }
                Node nodeRewind = this.prev;
                while (nodeRewind != null) {
                    Node nodeSibling = nodeRewind.nextSibling();
                    if (nodeSibling != null) {
                        this.next = nodeSibling.firstContainedPresent();
                        return this.next;
                    }
                    nodeRewind = nodeRewind.parent;
                }
                return null;
            }
        };
    }

    public boolean contains(Version ver) {
        return this.findNode(ver) != null;
    }

    public boolean containsAll(VersionTree<?> that) {
        for (Version ver : that) {
            if (this.contains(ver)) continue;
            return false;
        }
        return true;
    }

    public V get(Version ver) {
        Node<V> node = this.findNode(ver);
        return node == null ? null : (V)node.value;
    }

    public Version findClosestVersion(Version ver) {
        int[] parts = ver.getIntArray();
        Node node = this.root.findClosestNode(parts, 0);
        return node == null ? null : node.getVersion();
    }

    public Version findLowestVersion() {
        return this.isEmpty() ? null : this.root.kids[0].firstContainedPresent().getVersion();
    }

    public Version findHighestVersion() {
        Node node = this.root.findHighestNode();
        return node == null ? null : node.getVersion();
    }

    public Version findHighestVersion(Version ver) {
        int[] parts = ver.getIntArray();
        Node node = this.root.findHighestNode(parts, 0);
        return node == null ? null : node.getVersion();
    }

    public void put(Version ver, V value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Node<V> node = this.ensureNode(ver);
        if (!node.isPresent()) {
            ++this.count;
        }
        node.value = value;
    }

    public void putAll(VersionTree<V> that) {
        for (Version ver : that) {
            this.put(ver, that.get(ver));
        }
    }

    public void remove(Version ver) {
        Node<V> node = this.findNode(ver);
        if (node != null) {
            if (node.isPresent()) {
                --this.count;
            }
            node.remove();
        }
    }

    public void removeAll(VersionTree<?> that) {
        for (Version ver : that) {
            this.remove(ver);
        }
    }

    public void retainAll(VersionTree<?> that) {
        ArrayList<Version> listRemove = null;
        for (Version ver : this) {
            if (that.get(ver) != null) continue;
            if (listRemove == null) {
                listRemove = new ArrayList<Version>();
            }
            listRemove.add(ver);
        }
        if (listRemove != null) {
            for (Version ver : listRemove) {
                this.remove(ver);
            }
        }
    }

    public void clear() {
        this.root = new Node(null, 0);
        this.count = 0;
    }

    public VersionTree<V> subTree(Version ver) {
        VersionTree<V> that = new VersionTree<V>();
        Node<V> node = this.findNode(ver);
        if (node != null) {
            node.copyTo(that);
        }
        return that;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VersionTree) {
            VersionTree that = (VersionTree)o;
            if (this.size() == that.size()) {
                Iterator<Version> iterThis = this.iterator();
                Iterator<Version> iterThat = that.iterator();
                while (iterThis.hasNext()) {
                    Version verThat;
                    Version verThis = iterThis.next();
                    if (verThis.equals(verThat = iterThat.next()) && Handy.equals(this.get(verThis), that.get(verThat))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VersionTree");
        this.root.render(sb, "", "");
        return sb.toString();
    }

    private Node<V> findNode(Version ver) {
        Node node = this.root;
        int[] parts = ver.getIntArray();
        int c = parts.length;
        for (int i = 0; i < c && node != null; node = node.getChild(parts[i]), ++i) {
        }
        return node;
    }

    private Node<V> ensureNode(Version ver) {
        Node node = this.root;
        for (int part : ver.getIntArray()) {
            node = node.ensureChild(part);
        }
        node.version = ver;
        return node;
    }

    private static class Node<V> {
        Node parent;
        Version version;
        int part;
        V value;
        Node[] kids;

        Node(Node parent, int part) {
            this.parent = parent;
            this.part = part;
        }

        Version getVersion() {
            if (this.version == null) {
                int cDepth = 0;
                Node node = this;
                while (node.parent != null) {
                    ++cDepth;
                    node = node.parent;
                }
                int[] parts = new int[cDepth];
                node = this;
                for (int i = cDepth - 1; i >= 0; --i) {
                    parts[i] = node.part;
                    node = node.parent;
                }
                this.version = new Version(parts, null);
            }
            return this.version;
        }

        boolean isPresent() {
            return this.value != null;
        }

        Node firstContainedPresent() {
            if (this.isPresent()) {
                return this;
            }
            if (this.kids == null) {
                throw new IllegalStateException(this.toString());
            }
            Node first = this.kids[0];
            return first == null ? null : first.firstContainedPresent();
        }

        Node nextSibling() {
            if (this.parent == null) {
                return null;
            }
            Node[] siblings = this.parent.kids;
            int c = siblings.length;
            for (int i = 0; i < c; ++i) {
                if (siblings[i] != this) continue;
                return i < c - 1 ? siblings[i + 1] : null;
            }
            throw new IllegalStateException(this.toString());
        }

        Node getChild(int part) {
            Node[] kids = this.kids;
            int i = Node.indexOf(kids, part);
            return i < 0 ? null : kids[i];
        }

        Node ensureChild(int part) {
            Node<V> node = this.getChild(part);
            if (node == null) {
                node = new Node<V>(this, part);
                this.kids = Node.addNode(this.kids, node);
            }
            return node;
        }

        Node findClosestNode(int[] parts, int iPart) {
            int nPart = iPart >= parts.length ? 0 : parts[iPart];
            Node nodeBestMatch = this.isPresent() && nPart >= 0 ? this : null;
            Node[] kids = this.kids;
            if (kids != null) {
                for (Node kid : kids) {
                    if (kid == null) break;
                    if (kid.part == nPart) {
                        Node node = kid.findClosestNode(parts, iPart + 1);
                        if (node == null) break;
                        return node;
                    }
                    if (kid.part >= nPart) break;
                    if (!kid.isPresent()) continue;
                    nodeBestMatch = kid;
                }
            }
            return nodeBestMatch;
        }

        Node findHighestNode(int[] parts, int iPart) {
            boolean fGA;
            Node[] kids = this.kids;
            int cParts = parts.length;
            int cMatch = cParts - 1;
            boolean bl = fGA = !(cParts >= 1 && parts[cParts - 1] < 0 || cParts >= 2 && parts[cParts - 2] < 0);
            if (!fGA) {
                cMatch -= parts[cParts - 1] < 0 ? 1 : 2;
            }
            if (iPart < cMatch) {
                int nPart = parts[iPart];
                Node kid = this.getChild(nPart);
                if (kid != null) {
                    return kid.findHighestNode(parts, iPart + 1);
                }
                if (nPart == 0 && this.isPresent()) {
                    while (++iPart < cParts) {
                        if (parts[iPart] == 0) continue;
                        return null;
                    }
                    return this;
                }
                return null;
            }
            if (iPart < cParts) {
                int nPart = parts[iPart];
                Node nodeNonGA = null;
                if (kids != null) {
                    for (int i = kids.length - 1; i >= 0; --i) {
                        Node node;
                        Node kid = kids[i];
                        if (kid == null) continue;
                        if (kid.part < nPart) break;
                        Node node2 = node = kid.part == nPart ? kid.findHighestNode(parts, i + 1) : kid.findHighestNode();
                        if (node == null) continue;
                        if (node.getVersion().isGARelease()) {
                            return node;
                        }
                        if (nodeNonGA != null && nodeNonGA.getVersion().getReleaseCategory() >= node.getVersion().getReleaseCategory()) continue;
                        nodeNonGA = node;
                    }
                }
                return this.isPresent() && (nodeNonGA == null || this.getVersion().isGARelease()) && this.getVersion().isSubstitutableFor(new Version(parts, null)) ? this : nodeNonGA;
            }
            return this.findHighestNode();
        }

        Node findHighestNode() {
            Node nodeBestMatch = null;
            Node[] kids = this.kids;
            if (kids != null) {
                for (int i = kids.length - 1; i >= 0; --i) {
                    Node node;
                    Node kid = kids[i];
                    if (kid == null || (node = kid.findHighestNode()) == null) continue;
                    if (node.getVersion().isGARelease()) {
                        return node;
                    }
                    if (nodeBestMatch != null) continue;
                    nodeBestMatch = node;
                }
            }
            return this.isPresent() && (nodeBestMatch == null || this.getVersion().isGARelease()) ? this : nodeBestMatch;
        }

        void remove() {
            this.value = null;
            if ((this.kids == null || this.kids[0] == null) && this.parent != null) {
                this.parent.removeChild(this);
            }
        }

        private void removeChild(Node child) {
            Node[] kids = this.kids;
            int iKid = Node.indexOf(kids, child);
            assert (iKid >= 0);
            Node.deleteNode(kids, iKid);
            if (kids[0] == null) {
                this.kids = null;
                if (this.value == null) {
                    this.remove();
                }
            }
        }

        void copyTo(VersionTree<V> tree) {
            if (this.isPresent()) {
                tree.put(this.version, this.value);
            }
            if (this.kids != null) {
                for (Node kid : this.kids) {
                    if (kid == null) {
                        return;
                    }
                    kid.copyTo(tree);
                }
            }
        }

        public String toString() {
            return this.parent == null ? "root" : String.valueOf(this.getVersion()) + "=" + String.valueOf(this.value);
        }

        void render(StringBuilder sb, String sIndentFirst, String sIndent) {
            if (this.parent != null) {
                sb.append('\n').append(sIndentFirst).append(this.part);
                if (this.isPresent()) {
                    sb.append(":  ").append(this);
                }
            }
            if (this.kids != null) {
                String sIndentNext = sIndent + "|- ";
                String sIndentKids = sIndent + "|  ";
                String sIndentLast = sIndent + "   ";
                int c = this.kids.length;
                for (int i = 0; i < c; ++i) {
                    Node cur = this.kids[i];
                    if (cur == null) {
                        return;
                    }
                    boolean fLast = i == c - 1 || this.kids[i + 1] == null;
                    cur.render(sb, sIndentNext, fLast ? sIndentLast : sIndentKids);
                }
            }
        }

        private static int indexOf(Node[] nodes, Node node) {
            if (nodes == null) {
                return -1;
            }
            int c = nodes.length;
            for (int i = 0; i < c; ++i) {
                Node cur = nodes[i];
                if (cur == null) {
                    return -1;
                }
                if (cur != node) continue;
                return i;
            }
            return -1;
        }

        private static int indexOf(Node[] nodes, int part) {
            if (nodes == null) {
                return -1;
            }
            int c = nodes.length;
            for (int i = 0; i < c; ++i) {
                Node cur = nodes[i];
                if (cur == null) {
                    return -1;
                }
                if (cur.part != part) continue;
                return i;
            }
            return -1;
        }

        private static Node[] addNode(Node[] nodes, Node node) {
            if (nodes == null) {
                nodes = new Node[4];
                nodes[0] = node;
                return nodes;
            }
            int c = nodes.length;
            if (nodes[c - 1] != null) {
                int cNew = c * 2;
                Node[] nodesNew = new Node[cNew];
                System.arraycopy(nodes, 0, nodesNew, 0, c);
                nodes = nodesNew;
                c = cNew;
            }
            int nodePart = node.part;
            for (int i = 0; i < c; ++i) {
                Node cur = nodes[i];
                if (cur == null) {
                    nodes[i] = node;
                    return nodes;
                }
                if (nodePart > cur.part) continue;
                assert (nodePart != cur.part);
                System.arraycopy(nodes, i, nodes, i + 1, c - i - 1);
                nodes[i] = node;
                return nodes;
            }
            throw new IllegalStateException();
        }

        private static void deleteNode(Node[] nodes, int iNode) {
            int iLast = nodes.length - 1;
            System.arraycopy(nodes, iNode + 1, nodes, iNode, iLast - iNode);
            nodes[iLast] = null;
        }
    }
}

