/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.util.Severity;

public abstract class XvmStructure
implements Constants {
    private XvmStructure m_xsParent;

    protected XvmStructure(XvmStructure xsParent) {
        this.m_xsParent = xsParent;
    }

    public XvmStructure getContaining() {
        return this.m_xsParent;
    }

    protected void setContaining(XvmStructure xsParent) {
        this.m_xsParent = xsParent;
    }

    public FileStructure getFileStructure() {
        return this.getContaining().getFileStructure();
    }

    public ConstantPool getConstantPool() {
        return this.getContaining().getConstantPool();
    }

    public IdentityConstant getIdentityConstant() {
        return null;
    }

    public Iterator<? extends XvmStructure> getContained() {
        return Collections.emptyIterator();
    }

    public boolean isModified() {
        Iterator<? extends XvmStructure> iter = this.getContained();
        while (iter.hasNext()) {
            if (!iter.next().isModified()) continue;
            return true;
        }
        return false;
    }

    protected abstract void markModified();

    protected void resetModified() {
        Iterator<? extends XvmStructure> iter = this.getContained();
        while (iter.hasNext()) {
            iter.next().resetModified();
        }
    }

    public boolean isConditional() {
        return this.getCondition() != null || this.m_xsParent.isConditional();
    }

    public ConditionalConstant getCondition() {
        return null;
    }

    public ConditionalConstant getAggregateCondition() {
        ConditionalConstant[] conds = this.aggregateConditions(0);
        if (conds == null) {
            return null;
        }
        return conds.length == 1 ? conds[0] : this.getConstantPool().ensureAllCondition(conds);
    }

    protected ConditionalConstant[] aggregateConditions(int cConditions) {
        ConditionalConstant[] conds = null;
        XvmStructure parent = this.m_xsParent;
        ConditionalConstant cond = this.getCondition();
        if (cond != null) {
            ++cConditions;
        }
        if (parent == null) {
            if (cConditions > 0) {
                conds = new ConditionalConstant[cConditions];
            }
        } else {
            conds = parent.aggregateConditions(cConditions);
        }
        if (cond != null) {
            conds[conds.length - cConditions] = cond;
        }
        return conds;
    }

    protected void setCondition(ConditionalConstant condition) {
        throw new UnsupportedOperationException();
    }

    protected void purgeCondition(ConditionalConstant condition) {
        Iterator<? extends XvmStructure> iter = this.getContained();
        while (iter.hasNext()) {
            iter.next().purgeCondition(condition);
        }
    }

    public boolean isPresent(LinkerContext ctx) {
        if (!this.m_xsParent.isPresent(ctx)) {
            return false;
        }
        ConditionalConstant cond = this.getCondition();
        return cond == null || cond.isPresent(ctx);
    }

    public boolean isResolved() {
        if (this.getCondition() != null) {
            return false;
        }
        Iterator<? extends XvmStructure> iter = this.getContained();
        while (iter.hasNext()) {
            if (iter.next().isResolved()) continue;
            return false;
        }
        return true;
    }

    public void resolve(LinkerContext ctx) {
        Iterator<? extends XvmStructure> iter = this.getContained();
        while (iter.hasNext()) {
            iter.next().resolve(ctx);
        }
    }

    protected void disassemble(DataInput in) throws IOException {
    }

    protected void registerConstants(ConstantPool pool) {
        Iterator<? extends XvmStructure> iter = this.getContained();
        while (iter.hasNext()) {
            iter.next().registerConstants(pool);
        }
    }

    protected void assemble(DataOutput out) throws IOException {
    }

    public boolean validate(ErrorListener errs) {
        Iterator<? extends XvmStructure> iter = this.getContained();
        while (iter.hasNext()) {
            if (!iter.next().validate(errs)) continue;
            return true;
        }
        return false;
    }

    public boolean log(ErrorListener errs, Severity sev, String sCode, Object ... aoParam) {
        return this.ensureErrorListener(errs).log(sev, sCode, aoParam, this);
    }

    public ErrorListener ensureErrorListener(ErrorListener errs) {
        return errs == null ? this.getErrorListener() : errs;
    }

    public ErrorListener getErrorListener() {
        return this.m_xsParent.getErrorListener();
    }

    public void setErrorListener(ErrorListener errs) {
        this.m_xsParent.setErrorListener(errs);
    }

    public abstract String getDescription();

    public String toDebugString() {
        StringWriter sw = new StringWriter(1024);
        PrintWriter out = new PrintWriter(sw);
        this.dump(out);
        out.flush();
        return sw.toString();
    }

    public void dump(PrintWriter out) {
        if (out == null) {
            out = System.console().writer();
        }
        this.dump(out, "");
    }

    protected abstract void dump(PrintWriter var1, String var2);

    protected void dumpStructureCollection(PrintWriter out, String sIndent, String sTitle, Collection<? extends XvmStructure> collStructs) {
        if (collStructs != null && !collStructs.isEmpty()) {
            out.print(sIndent);
            out.println(sTitle);
            int i = 0;
            String sIndentMore = this.nextIndent(sIndent);
            for (XvmStructure xvmStructure : collStructs) {
                StringBuilder sb = new StringBuilder();
                sb.append(sIndent).append('[').append(i++).append("]");
                if (xvmStructure == null || xvmStructure instanceof Constant) {
                    sb.append('=').append(xvmStructure);
                    out.println(sb);
                    continue;
                }
                sb.append(':');
                out.println(sb);
                xvmStructure.dump(out, sIndentMore);
            }
        }
    }

    protected void dumpStructureMap(PrintWriter out, String sIndent, String sTitle, Map<?, ? extends XvmStructure> mapStructs) {
        if (mapStructs != null && !mapStructs.isEmpty()) {
            out.print(sIndent);
            out.println(sTitle);
            int i = 0;
            String sIndentMore = this.nextIndent(sIndent);
            for (Map.Entry<?, XvmStructure> entry : mapStructs.entrySet()) {
                out.println(sIndent + "[" + i++ + "]=" + String.valueOf(entry.getKey()));
                XvmStructure xs = entry.getValue();
                if (xs == null) {
                    out.print(sIndentMore);
                    out.print(xs);
                    continue;
                }
                xs.dump(out, sIndentMore);
            }
        }
    }

    protected String nextIndent(String sIndent) {
        return sIndent + "  ";
    }

    public int hashCode() {
        IdentityConstant constant = this.getIdentityConstant();
        if (constant != null) {
            return constant.hashCode();
        }
        throw new UnsupportedOperationException();
    }

    public abstract boolean equals(Object var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getDescription() + "}";
    }
}

