/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class ArrayAccessExprAST
extends ExprAST {
    private ExprAST array;
    private ExprAST index;

    ArrayAccessExprAST() {
    }

    public ArrayAccessExprAST(ExprAST array, ExprAST index) {
        assert (array != null && index != null);
        this.array = array;
        this.index = index;
    }

    public ExprAST getArray() {
        return this.array;
    }

    public ExprAST getIndex() {
        return this.index;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.array.getType(0).getParamType(0);
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.ArrayAccessExpr;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.array = ArrayAccessExprAST.readExprAST(in, res);
        this.index = ArrayAccessExprAST.readExprAST(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.array.prepareWrite(res);
        this.index.prepareWrite(res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.array.writeExpr(out, res);
        this.index.writeExpr(out, res);
    }

    @Override
    public String toString() {
        return this.array.toString() + "[" + String.valueOf(this.index) + "]";
    }
}

