/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.util.Handy;

public class AssertStmtAST
extends BinaryAST {
    private ExprAST cond;
    private ExprAST interval;
    private ExprAST message;

    AssertStmtAST() {
    }

    public AssertStmtAST(ExprAST cond, ExprAST interval, ExprAST message) {
        this.cond = cond;
        this.interval = interval;
        this.message = message;
    }

    public ExprAST getCond() {
        return this.cond;
    }

    public ExprAST getInterval() {
        return this.interval;
    }

    public ExprAST getMessage() {
        return this.message;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.AssertStmt;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        int flags = Handy.readMagnitude(in);
        if ((flags & 1) != 0) {
            this.cond = AssertStmtAST.readExprAST(in, res);
        }
        if ((flags & 2) != 0) {
            this.interval = AssertStmtAST.readExprAST(in, res);
        }
        if ((flags & 4) != 0) {
            this.message = AssertStmtAST.readExprAST(in, res);
        }
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        AssertStmtAST.prepareAST(this.cond, res);
        AssertStmtAST.prepareAST(this.interval, res);
        AssertStmtAST.prepareAST(this.message, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        int flags = (this.cond == null ? 0 : 1) | (this.interval == null ? 0 : 2) | (this.message == null ? 0 : 4);
        Handy.writePackedLong(out, flags);
        if (this.cond != null) {
            this.cond.writeExpr(out, res);
        }
        if (this.interval != null) {
            this.interval.writeExpr(out, res);
        }
        if (this.message != null) {
            this.message.writeExpr(out, res);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("assert");
        if (this.cond != null) {
            buf.append(' ').append(this.cond);
        }
        if (this.message != null) {
            buf.append(" as ").append(this.message);
        }
        buf.append(';');
        return buf.toString();
    }
}

