/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class AssignAST
extends ExprAST {
    ExprAST lhs;
    Operator op;
    ExprAST rhs;
    MethodConstant method;

    AssignAST(boolean binOp) {
        this.op = binOp ? null : Operator.Asn;
    }

    public AssignAST(ExprAST lhs, Operator op, ExprAST rhs) {
        this(lhs, op, rhs, null);
    }

    public AssignAST(ExprAST lhs, Operator op, ExprAST rhs, MethodConstant method) {
        assert (lhs != null && lhs.isAssignable() && op != null && rhs != null);
        this.lhs = lhs;
        this.op = op;
        this.rhs = rhs;
        this.method = method;
    }

    public ExprAST getLValue() {
        return this.lhs;
    }

    public Operator getOperator() {
        return this.op;
    }

    public ExprAST getRValue() {
        return this.rhs;
    }

    public MethodConstant getMethod() {
        return this.method;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.op == Operator.Asn ? BinaryAST.NodeType.Assign : BinaryAST.NodeType.BinOpAssign;
    }

    @Override
    public int getCount() {
        return this.lhs.getCount();
    }

    @Override
    public TypeConstant getType(int i) {
        return this.lhs.getType(i);
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.lhs = AssignAST.readExprAST(in, res);
        if (this.nodeType() != BinaryAST.NodeType.Assign) {
            this.op = Operator.valueOf(Handy.readMagnitude(in));
        }
        this.rhs = AssignAST.readExprAST(in, res);
        int methodId = Handy.readPackedInt(in);
        this.method = methodId < 0 ? null : (MethodConstant)res.getConstant(methodId);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.lhs.prepareWrite(res);
        this.rhs.prepareWrite(res);
        this.method = (MethodConstant)res.register(this.method);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.lhs.writeExpr(out, res);
        if (this.nodeType() != BinaryAST.NodeType.Assign) {
            Handy.writePackedLong(out, this.op.ordinal());
        }
        this.rhs.writeExpr(out, res);
        if (this.method == null) {
            Handy.writePackedLong(out, -1L);
        } else {
            Handy.writePackedLong(out, res.indexOf(this.method));
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.lhs) + " " + this.op.text + " " + String.valueOf(this.rhs);
    }

    public static enum Operator {
        Asn("="),
        AddAsn("+="),
        SubAsn("-="),
        MulAsn("*="),
        DivAsn("/="),
        ModAsn("%="),
        ShiftLAsn("<<="),
        ShiftRAsn(">>="),
        UShiftRAsn(">>>="),
        AndAsn("&="),
        OrAsn("|="),
        XorAsn("^="),
        AsnIfNotFalse(":="),
        AsnIfNotNull("?="),
        AsnIfWasTrue("&&="),
        AsnIfWasFalse("||="),
        AsnIfWasNull("?:="),
        Deref("->");

        public final String text;
        private static final Operator[] OPERATORS;

        private Operator(String text) {
            this.text = text;
        }

        public static Operator valueOf(int i) {
            return OPERATORS[i];
        }

        static {
            OPERATORS = Operator.values();
        }
    }
}

