/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public abstract class BiExprAST
extends ExprAST {
    private ExprAST expr1;
    private Operator op;
    private ExprAST expr2;

    BiExprAST() {
    }

    protected BiExprAST(ExprAST expr1, Operator op, ExprAST expr2) {
        assert (expr1 != null && op != null && expr2 != null);
        this.expr1 = expr1;
        this.op = op;
        this.expr2 = expr2;
    }

    public ExprAST getExpr1() {
        return this.expr1;
    }

    public Operator getOp() {
        return this.op;
    }

    public ExprAST getExpr2() {
        return this.expr2;
    }

    @Override
    public abstract TypeConstant getType(int var1);

    @Override
    public abstract BinaryAST.NodeType nodeType();

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.expr1 = BiExprAST.readExprAST(in, res);
        this.op = Operator.values()[Handy.readMagnitude(in)];
        this.expr2 = BiExprAST.readExprAST(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.expr1.prepareWrite(res);
        this.expr2.prepareWrite(res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.expr1.writeExpr(out, res);
        Handy.writePackedLong(out, this.op.ordinal());
        this.expr2.writeExpr(out, res);
    }

    @Override
    public String toString() {
        return this.op == Operator.As ? String.valueOf(this.expr1) + ".as(" + String.valueOf(this.expr2) + ")" : String.valueOf(this.expr1) + " " + this.op.text + " " + String.valueOf(this.expr2);
    }

    public static enum Operator {
        Else(":"),
        CondElse("?:"),
        CondOr("||"),
        CondXor("^^"),
        CondAnd("&&"),
        BitOr("|"),
        BitXor("^"),
        BitAnd("&"),
        CompEq("=="),
        CompNeq("!="),
        CompLt("<"),
        CompGt(">"),
        CompLtEq("<="),
        CompGtEq(">="),
        CompOrd("<=>"),
        As("as"),
        Is("is"),
        RangeII(".."),
        RangeIE("..<"),
        RangeEI(">.."),
        RangeEE(">..<"),
        Shl("<<"),
        Shr(">>"),
        Ushr(">>>"),
        Add("+"),
        Sub("-"),
        Mul("*"),
        Div("/"),
        Mod("%"),
        DivRem("/%");

        public final String text;

        private Operator(String text) {
            this.text = text;
        }
    }
}

