/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.ArrayAccessExprAST;
import org.xvm.asm.ast.AssertStmtAST;
import org.xvm.asm.ast.AssignAST;
import org.xvm.asm.ast.BindFunctionAST;
import org.xvm.asm.ast.BindMethodAST;
import org.xvm.asm.ast.BreakStmtAST;
import org.xvm.asm.ast.CallExprAST;
import org.xvm.asm.ast.CmpChainExprAST;
import org.xvm.asm.ast.CondOpExprAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ContinueStmtAST;
import org.xvm.asm.ast.ConvertExprAST;
import org.xvm.asm.ast.DivRemExprAST;
import org.xvm.asm.ast.DoWhileStmtAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ForEachStmtAST;
import org.xvm.asm.ast.ForStmtAST;
import org.xvm.asm.ast.IfStmtAST;
import org.xvm.asm.ast.InitAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.ast.IsExprAST;
import org.xvm.asm.ast.ListExprAST;
import org.xvm.asm.ast.LoopStmtAST;
import org.xvm.asm.ast.MapExprAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.ast.NarrowedExprAST;
import org.xvm.asm.ast.NewExprAST;
import org.xvm.asm.ast.NotNullExprAST;
import org.xvm.asm.ast.OrderedExprAST;
import org.xvm.asm.ast.OuterExprAST;
import org.xvm.asm.ast.PoisonAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.ast.RelOpExprAST;
import org.xvm.asm.ast.ReturnStmtAST;
import org.xvm.asm.ast.StmtBlockAST;
import org.xvm.asm.ast.StmtExprAST;
import org.xvm.asm.ast.SwitchAST;
import org.xvm.asm.ast.TemplateExprAST;
import org.xvm.asm.ast.TernaryExprAST;
import org.xvm.asm.ast.ThrowExprAST;
import org.xvm.asm.ast.TryCatchStmtAST;
import org.xvm.asm.ast.TryFinallyStmtAST;
import org.xvm.asm.ast.TupleExprAST;
import org.xvm.asm.ast.UnaryOpExprAST;
import org.xvm.asm.ast.UnpackExprAST;
import org.xvm.asm.ast.WhileStmtAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public abstract class BinaryAST {
    public static final BinaryAST[] NO_ASTS = new BinaryAST[0];
    public static final ExprAST[] NO_EXPRS = new ExprAST[0];
    public static final Constant[] NO_CONSTS = Constant.NO_CONSTS;
    public static final TypeConstant[] NO_TYPES = TypeConstant.NO_TYPES;
    public static final RegisterAST[] NO_REGS = new RegisterAST[0];
    public static final RegAllocAST[] NO_ALLOCS = new RegAllocAST[0];
    public static final ExprAST POISON = PoisonAST.INSTANCE;
    private static final Set<String> ALREADY_DISPLAYED = new HashSet<String>();

    protected abstract NodeType nodeType();

    protected abstract void readBody(DataInput var1, ConstantResolver var2) throws IOException;

    public abstract void prepareWrite(ConstantResolver var1);

    public void write(DataOutput out, ConstantResolver res) throws IOException {
        out.writeByte(this.nodeType().ordinal());
        this.writeBody(out, res);
    }

    protected abstract void writeBody(DataOutput var1, ConstantResolver var2) throws IOException;

    public String toString() {
        BinaryAST.reportUnimplemented("TODO implement toString() for " + this.getClass().getSimpleName());
        return this.nodeType().name();
    }

    static void reportUnimplemented(String msg) {
        if (ALREADY_DISPLAYED.add(msg)) {
            System.err.println(msg);
        }
    }

    public static <N extends BinaryAST> N readAST(DataInput in, ConstantResolver res) throws IOException {
        BinaryAST node = NodeType.valueOf(in.readUnsignedByte()).instantiate();
        if (node == null) {
            node = new StmtBlockAST(NO_ASTS, false);
        } else {
            node.readBody(in, res);
        }
        return (N)node;
    }

    protected static void prepareAST(BinaryAST node, ConstantResolver res) {
        if (node != null) {
            node.prepareWrite(res);
        }
    }

    protected static void writeAST(BinaryAST node, DataOutput out, ConstantResolver res) throws IOException {
        if (node == null) {
            out.writeByte(NodeType.None.ordinal());
        } else {
            node.write(out, res);
        }
    }

    protected static BinaryAST unwrapStatement(BinaryAST stmt) {
        StmtBlockAST block;
        if (stmt instanceof StmtBlockAST && (block = (StmtBlockAST)stmt).getStmts().length == 1) {
            return block.getStmts()[0];
        }
        return stmt;
    }

    public static BinaryAST makeMultiStatement(BinaryAST[] stmts) {
        return switch (stmts == null ? 0 : stmts.length) {
            case 0 -> new StmtBlockAST(NO_ASTS, false);
            case 1 -> stmts[0];
            default -> new StmtBlockAST(stmts, false);
        };
    }

    public static ExprAST makeCondition(ExprAST[] exprs) {
        if (exprs == null) {
            return null;
        }
        int count = exprs.length;
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            ExprAST expr = exprs[0];
            assert (expr != null);
            return expr;
        }
        return new MultiExprAST(exprs);
    }

    protected static ExprAST readExprAST(DataInput in, ConstantResolver res) throws IOException {
        int n = Handy.readPackedInt(in);
        if (n <= -16) {
            int id = -16 - n;
            Constant val = res.getConstant(id);
            return new ConstantExprAST(val);
        }
        if (n < 0 || n >= 32) {
            int id = n < 0 ? n : n - 32;
            return res.getRegister(id);
        }
        NodeType nodeType = NodeType.valueOf(n);
        if (nodeType == NodeType.None) {
            return null;
        }
        if (nodeType == NodeType.Escape) {
            return (ExprAST)BinaryAST.readAST(in, res);
        }
        ExprAST node = (ExprAST)nodeType.instantiate();
        node.readBody(in, res);
        return node;
    }

    protected static void writeExprAST(ExprAST node, DataOutput out, ConstantResolver res) throws IOException {
        if (node == null) {
            Handy.writePackedLong(out, NodeType.None.ordinal());
        } else {
            node.writeExpr(out, res);
        }
    }

    protected static BinaryAST[] readASTArray(DataInput in, ConstantResolver res) throws IOException {
        int count = Handy.readMagnitude(in);
        if (count == 0) {
            return NO_ASTS;
        }
        BinaryAST[] nodes = new BinaryAST[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = BinaryAST.readAST(in, res);
        }
        return nodes;
    }

    protected static void prepareASTArray(BinaryAST[] nodes, ConstantResolver res) {
        for (BinaryAST node : nodes) {
            node.prepareWrite(res);
        }
    }

    protected static void writeASTArray(BinaryAST[] nodes, DataOutput out, ConstantResolver res) throws IOException {
        Handy.writePackedLong(out, nodes.length);
        for (BinaryAST child : nodes) {
            child.write(out, res);
        }
    }

    protected static Constant[] readConstArray(DataInput in, ConstantResolver res) throws IOException {
        int count = Handy.readMagnitude(in);
        if (count == 0) {
            return NO_CONSTS;
        }
        Constant[] values = new Constant[count];
        for (int i = 0; i < count; ++i) {
            values[i] = res.getConstant(Handy.readMagnitude(in));
        }
        return values;
    }

    protected static TypeConstant[] readTypeArray(DataInput in, ConstantResolver res) throws IOException {
        int count = Handy.readMagnitude(in);
        if (count == 0) {
            return NO_TYPES;
        }
        TypeConstant[] types = new TypeConstant[count];
        for (int i = 0; i < count; ++i) {
            types[i] = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
        }
        return types;
    }

    protected static void prepareConstArray(Constant[] values, ConstantResolver res) {
        int count = values == null ? 0 : values.length;
        for (int i = 0; i < count; ++i) {
            Constant value = values[i];
            if (value == null) continue;
            values[i] = res.register(value);
        }
    }

    protected static void writeConstArray(Constant[] values, DataOutput out, ConstantResolver res) throws IOException {
        int count = values == null ? 0 : values.length;
        Handy.writePackedLong(out, count);
        for (int i = 0; i < count; ++i) {
            Handy.writePackedLong(out, res.indexOf(values[i]));
        }
    }

    protected static Constant[] readSparseConstArray(DataInput in, ConstantResolver res, int count) throws IOException {
        assert (count != 0);
        long mask = Handy.readPackedLong(in);
        Constant[] values = new Constant[count];
        for (int i = 0; i < count; ++i) {
            if ((mask & 1L << i) == 0L) continue;
            values[i] = res.getConstant(Handy.readMagnitude(in));
        }
        return values;
    }

    protected static void writeSparseConstArray(Constant[] values, DataOutput out, ConstantResolver res) throws IOException {
        int i;
        assert (values.length < 64);
        long mask = 0L;
        int count = values.length;
        for (i = 0; i < count; ++i) {
            if (values[i] == null) continue;
            mask |= 1L << i;
        }
        Handy.writePackedLong(out, mask);
        for (i = 0; i < count; ++i) {
            Constant value = values[i];
            if (value == null) continue;
            Handy.writePackedLong(out, res.indexOf(value));
        }
    }

    protected static ExprAST[] readExprArray(DataInput in, ConstantResolver res) throws IOException {
        int count = Handy.readMagnitude(in);
        if (count == 0) {
            return NO_EXPRS;
        }
        ExprAST[] exprs = new ExprAST[count];
        for (int i = 0; i < count; ++i) {
            exprs[i] = BinaryAST.readExprAST(in, res);
        }
        return exprs;
    }

    protected static void writeExprArray(ExprAST[] nodes, DataOutput out, ConstantResolver res) throws IOException {
        int count = nodes == null ? 0 : nodes.length;
        Handy.writePackedLong(out, count);
        for (int i = 0; i < count; ++i) {
            nodes[i].writeExpr(out, res);
        }
    }

    public static enum NodeType {
        None,
        PropertyExpr,
        InvokeExpr,
        CondOpExpr,
        Less,
        Greater,
        Assign,
        NamedRegAlloc,
        RelOpExpr,
        NarrowedExpr,
        UnaryOpExpr,
        NewExpr,
        ThrowExpr,
        CallExpr,
        ArrayAccessExpr,
        BinOpAssign,
        TernaryExpr,
        OuterExpr,
        NotExpr,
        MultiExpr,
        BindFunctionExpr,
        DivRemExpr,
        BindMethodExpr,
        NotNullExpr,
        ConvertExpr,
        TemplateExpr,
        NewChildExpr,
        TupleExpr,
        CmpChainExpr,
        UnpackExpr,
        SwitchExpr,
        Escape,
        NewVirtualExpr,
        ListExpr,
        AnnoRegAlloc,
        AnnoNamedRegAlloc,
        RegAlloc,
        RegisterExpr,
        InvokeAsyncExpr,
        CallAsyncExpr,
        IsExpr,
        NegExpr,
        BitNotExpr,
        PreIncExpr,
        PreDecExpr,
        PostIncExpr,
        PostDecExpr,
        RefOfExpr,
        VarOfExpr,
        ConstantExpr,
        MapExpr,
        StmtExpr,
        NotCond,
        NotNullCond,
        NotFalseCond,
        MatrixAccessExpr,
        AssertStmt,
        StmtBlock,
        MultiStmt,
        IfThenStmt,
        IfElseStmt,
        SwitchStmt,
        LoopStmt,
        WhileDoStmt,
        DoWhileStmt,
        ForStmt,
        ForIteratorStmt,
        ForRangeStmt,
        ForListStmt,
        ForMapStmt,
        ForIterableStmt,
        ContinueStmt,
        BreakStmt,
        Return0Stmt,
        Return1Stmt,
        ReturnNStmt,
        ReturnTStmt,
        TryCatchStmt,
        TryFinallyStmt,
        InitAst;

        private static final NodeType[] NODE_TYPES;

        BinaryAST instantiate() {
            return switch (this.ordinal()) {
                case 0 -> null;
                case 31, 37 -> throw new IllegalStateException();
                case 7, 34, 35, 36 -> new RegAllocAST(this);
                case 6 -> new AssignAST(false);
                case 15 -> new AssignAST(true);
                case 2, 38 -> new InvokeExprAST(this);
                case 13, 39 -> new CallExprAST(this);
                case 22 -> new BindMethodAST();
                case 20 -> new BindFunctionAST();
                case 49 -> new ConstantExprAST();
                case 33 -> new ListExprAST();
                case 27 -> new TupleExprAST();
                case 19 -> new MultiExprAST();
                case 50 -> new MapExprAST();
                case 24 -> new ConvertExprAST();
                case 51 -> new StmtExprAST();
                case 17 -> new OuterExprAST();
                case 1 -> new PropertyExprAST();
                case 9 -> new NarrowedExprAST();
                case 11, 26, 32 -> new NewExprAST(this);
                case 14 -> new ArrayAccessExprAST();
                case 8 -> new RelOpExprAST();
                case 21 -> new DivRemExprAST();
                case 40 -> new IsExprAST();
                case 3 -> new CondOpExprAST();
                case 28 -> new CmpChainExprAST();
                case 4, 5 -> new OrderedExprAST(this);
                case 18, 41, 42, 43, 44, 45, 46, 47, 48 -> new UnaryOpExprAST(this);
                case 10 -> new UnaryOpExprAST();
                case 23 -> new NotNullExprAST();
                case 16 -> new TernaryExprAST();
                case 29 -> new UnpackExprAST();
                case 30, 61 -> new SwitchAST(this);
                case 25 -> new TemplateExprAST();
                case 12 -> new ThrowExprAST();
                case 57, 58 -> new StmtBlockAST(this);
                case 59, 60 -> new IfStmtAST(this);
                case 62 -> new LoopStmtAST();
                case 63 -> new WhileStmtAST();
                case 64 -> new DoWhileStmtAST();
                case 65 -> new ForStmtAST();
                case 66, 67, 68, 69, 70 -> new ForEachStmtAST(this);
                case 71 -> new ContinueStmtAST();
                case 72 -> new BreakStmtAST();
                case 73, 74, 75 -> new ReturnStmtAST(this);
                case 77 -> new TryCatchStmtAST();
                case 78 -> new TryFinallyStmtAST();
                case 56 -> new AssertStmtAST();
                case 79 -> InitAST.INSTANCE;
                default -> throw new UnsupportedOperationException("nodeType: " + String.valueOf((Object)this));
            };
        }

        public static NodeType valueOf(int i) {
            return NODE_TYPES[i];
        }

        static {
            NODE_TYPES = NodeType.values();
        }
    }

    public static interface ConstantResolver {
        public Constant register(Constant var1);

        public Constant getConstant(int var1);

        public TypeConstant typeForName(String var1);

        public int indexOf(Constant var1);

        public void init(RegisterAST[] var1);

        public void enter();

        public void register(RegisterAST var1);

        public RegisterAST getRegister(int var1);

        public void exit();
    }
}

