/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class BindFunctionAST
extends ExprAST {
    private ExprAST target;
    private int[] indexes;
    private ExprAST[] args;
    private TypeConstant type;

    BindFunctionAST() {
    }

    public BindFunctionAST(ExprAST target, int[] indexes, ExprAST[] args, TypeConstant type) {
        assert (target != null && indexes != null && type != null);
        assert (args != null && args.length == indexes.length && Arrays.stream(args).allMatch(Objects::nonNull));
        this.target = target;
        this.indexes = indexes;
        this.args = args;
        this.type = type;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.BindFunctionExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    public ExprAST getTarget() {
        return this.target;
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public ExprAST[] getArgs() {
        return this.args;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.target = BindFunctionAST.readExprAST(in, res);
        int count = Handy.readMagnitude(in);
        if (count == 0) {
            this.indexes = new int[0];
            this.args = NO_EXPRS;
        } else {
            this.indexes = new int[count];
            this.args = new ExprAST[count];
            for (int i = 0; i < count; ++i) {
                this.indexes[i] = Handy.readMagnitude(in);
                this.args[i] = BindFunctionAST.readExprAST(in, res);
            }
        }
        this.type = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.target.prepareWrite(res);
        BindFunctionAST.prepareASTArray(this.args, res);
        this.type = (TypeConstant)res.register(this.type);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.target.writeExpr(out, res);
        int count = this.indexes.length;
        Handy.writePackedLong(out, count);
        for (int i = 0; i < count; ++i) {
            Handy.writePackedLong(out, this.indexes[i]);
            this.args[i].writeExpr(out, res);
        }
        Handy.writePackedLong(out, res.indexOf(this.type));
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("&");
        buf.append(this.target).append("(");
        if (this.indexes.length > 0) {
            int i = 0;
            int argIx = 0;
            int max = Arrays.stream(this.indexes).max().getAsInt();
            while (argIx <= max) {
                if (argIx != 0) {
                    buf.append(", ");
                }
                if (i == this.indexes[argIx]) {
                    buf.append(this.args[i]);
                    ++argIx;
                } else {
                    buf.append("_");
                }
                ++i;
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

