/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class BindMethodAST
extends ExprAST {
    private ExprAST target;
    private Constant method;
    private TypeConstant type;

    BindMethodAST() {
    }

    public BindMethodAST(ExprAST target, Constant method, TypeConstant type) {
        assert (target != null && method != null && type != null);
        this.target = target;
        this.method = method;
        this.type = type;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.BindMethodExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    public ExprAST getTarget() {
        return this.target;
    }

    public Constant getMethod() {
        return this.method;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.target = BindMethodAST.readExprAST(in, res);
        this.method = res.getConstant(Handy.readMagnitude(in));
        this.type = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.target.prepareWrite(res);
        this.method = res.register(this.method);
        this.type = (TypeConstant)res.register(this.type);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.target.writeExpr(out, res);
        Handy.writePackedLong(out, res.indexOf(this.method));
        Handy.writePackedLong(out, res.indexOf(this.type));
    }

    @Override
    public String toString() {
        return this.target.toString() + "&" + String.valueOf(this.method);
    }
}

