/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.CallableExprAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;

public class CallExprAST
extends CallableExprAST {
    private final BinaryAST.NodeType nodeType;
    private ExprAST function;

    CallExprAST(BinaryAST.NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public CallExprAST(ExprAST function, TypeConstant[] retTypes, ExprAST[] args, boolean async) {
        super(retTypes, args);
        assert (function != null);
        this.nodeType = async ? BinaryAST.NodeType.CallAsyncExpr : BinaryAST.NodeType.CallExpr;
        this.function = function;
    }

    public CallExprAST(ExprAST function, TypeConstant retType, ExprAST[] args) {
        this(function, new TypeConstant[]{retType}, args, false);
    }

    public ExprAST getFunction() {
        return this.function;
    }

    public boolean isAsync() {
        return this.nodeType == BinaryAST.NodeType.CallAsyncExpr;
    }

    @Override
    public boolean isConditional() {
        ExprAST exprAST = this.function;
        if (exprAST instanceof ConstantExprAST) {
            ConstantExprAST constExpr = (ConstantExprAST)exprAST;
            MethodConstant methodConst = (MethodConstant)constExpr.getValue();
            MethodStructure methodStruct = (MethodStructure)methodConst.getComponent();
            return methodStruct.isConditionalReturn();
        }
        return false;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.nodeType;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.function = CallExprAST.readExprAST(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        this.function.prepareWrite(res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        this.function.writeExpr(out, res);
    }

    @Override
    public String toString() {
        return this.function.toString() + (this.isAsync() ? "^" : "") + super.toString();
    }
}

