/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public abstract class CallableExprAST
extends ExprAST {
    private TypeConstant[] retTypes;
    private ExprAST[] args;

    CallableExprAST() {
    }

    protected CallableExprAST(TypeConstant[] retTypes, ExprAST[] args) {
        assert (retTypes != null && Arrays.stream(retTypes).allMatch(Objects::nonNull));
        assert (args == null || Arrays.stream(args).allMatch(Objects::nonNull));
        this.retTypes = retTypes;
        this.args = args == null ? NO_EXPRS : args;
    }

    @Override
    public int getCount() {
        return this.retTypes.length;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.retTypes[i];
    }

    @Override
    public abstract BinaryAST.NodeType nodeType();

    public ExprAST[] getArgs() {
        return this.args;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.retTypes = CallableExprAST.readTypeArray(in, res);
        this.args = CallableExprAST.readExprArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        CallableExprAST.prepareConstArray(this.retTypes, res);
        CallableExprAST.prepareASTArray(this.args, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        CallableExprAST.writeConstArray(this.retTypes, out, res);
        CallableExprAST.writeExprArray(this.args, out, res);
    }

    @Override
    public String toString() {
        if (this.args == null || this.args.length == 0) {
            return "()";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (ExprAST arg : this.args) {
            buf.append(arg).append(", ");
        }
        return buf.delete(buf.length() - 2, buf.length()).append(')').toString();
    }
}

