/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class CmpChainExprAST
extends ExprAST {
    private ExprAST[] exprs;
    private BiExprAST.Operator[] ops;
    private MethodConstant method;
    private transient TypeConstant booleanType;

    CmpChainExprAST() {
    }

    public CmpChainExprAST(ExprAST[] exprs, BiExprAST.Operator[] ops, MethodConstant method) {
        assert (exprs != null && Arrays.stream(exprs).allMatch(Objects::nonNull));
        assert (ops != null && Arrays.stream(ops).allMatch(Objects::nonNull));
        assert (ops.length == exprs.length - 1);
        assert (method != null);
        block3: for (BiExprAST.Operator op : ops) {
            if ($assertionsDisabled) continue;
            switch (op) {
                case CompEq: 
                case CompNeq: 
                case CompLt: 
                case CompGt: 
                case CompLtEq: 
                case CompGtEq: {
                    continue block3;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.exprs = exprs;
        this.ops = ops;
        this.method = method;
    }

    public BiExprAST.Operator[] getOps() {
        return this.ops;
    }

    public ExprAST[] getExprs() {
        return this.exprs;
    }

    public MethodConstant getMethod() {
        return this.method;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.CmpChainExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.booleanType;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        int count = Handy.readMagnitude(in);
        ExprAST[] exprs = new ExprAST[count];
        for (int i = 0; i < count; ++i) {
            exprs[i] = CmpChainExprAST.readExprAST(in, res);
        }
        BiExprAST.Operator[] ops = new BiExprAST.Operator[count - 1];
        for (int i = 0; i < count - 1; ++i) {
            ops[i] = BiExprAST.Operator.values()[Handy.readMagnitude(in)];
        }
        MethodConstant method = (MethodConstant)res.getConstant(Handy.readMagnitude(in));
        this.exprs = exprs;
        this.ops = ops;
        this.method = method;
        this.booleanType = res.typeForName("Boolean");
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        CmpChainExprAST.prepareASTArray(this.exprs, res);
        res.register(this.method);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        int count = this.exprs.length;
        Handy.writePackedLong(out, count);
        for (ExprAST exprAST : this.exprs) {
            exprAST.writeExpr(out, res);
        }
        for (BiExprAST.Operator operator : this.ops) {
            Handy.writePackedLong(out, operator.ordinal());
        }
        Handy.writePackedLong(out, res.indexOf(this.method));
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.exprs[0]);
        int c = this.exprs.length;
        for (int i = 1; i < c; ++i) {
            buf.append(' ').append(this.ops[i - 1].text).append(' ').append(this.exprs[i]);
        }
        return buf.toString();
    }
}

