/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class CondOpExprAST
extends BiExprAST {
    private transient TypeConstant type;

    CondOpExprAST() {
    }

    public CondOpExprAST(ExprAST expr1, BiExprAST.Operator op, ExprAST expr2) {
        super(expr1, op, expr2);
        if (!$assertionsDisabled) {
            switch (op) {
                case CondOr: 
                case CondXor: 
                case CondAnd: 
                case CompEq: 
                case CompNeq: 
                case CompLt: 
                case CompGt: 
                case CompLtEq: 
                case CompGtEq: 
                case CompOrd: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.CondOpExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.type = switch (this.getOp()) {
            case BiExprAST.Operator.CondOr, BiExprAST.Operator.CondXor, BiExprAST.Operator.CondAnd, BiExprAST.Operator.CompEq, BiExprAST.Operator.CompNeq -> res.typeForName("Boolean");
            case BiExprAST.Operator.CompLt, BiExprAST.Operator.CompGt, BiExprAST.Operator.CompLtEq, BiExprAST.Operator.CompGtEq, BiExprAST.Operator.CompOrd -> res.typeForName("Ordered");
            default -> throw new IllegalStateException();
        };
    }
}

