/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class ConstantExprAST
extends ExprAST {
    private Constant value;

    ConstantExprAST() {
    }

    public ConstantExprAST(Constant value) {
        assert (value != null);
        this.value = value;
    }

    public Constant getValue() {
        return this.value;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.ConstantExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.value.getType();
    }

    @Override
    public boolean isAssignable() {
        return this.value.getFormat() == Constant.Format.Any;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.value = res.getConstant(Handy.readMagnitude(in));
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.value = res.register(this.value);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        Handy.writePackedLong(out, res.indexOf(this.value));
    }

    @Override
    protected void writeExpr(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        Handy.writePackedLong(out, -16 - res.indexOf(this.value));
    }

    @Override
    public String toString() {
        return this.value.getValueString();
    }
}

