/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.util.Handy;

public class ContinueStmtAST
extends BinaryAST {
    private int depth;

    ContinueStmtAST() {
        this.depth = -1;
    }

    public ContinueStmtAST(int depth) {
        assert (depth >= 0 & depth < 1024);
        this.depth = depth;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.ContinueStmt;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.depth = Handy.readMagnitude(in);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        Handy.writePackedLong(out, this.depth);
    }

    @Override
    public String toString() {
        return this.depth <= 0 ? "continue;" : "continue ^" + this.depth + ";";
    }
}

