/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.DelegatingExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;

public class ConvertExprAST
extends DelegatingExprAST {
    private TypeConstant[] types;
    private Constant[] convMethods;

    ConvertExprAST() {
    }

    public ConvertExprAST(ExprAST expr, TypeConstant[] types, MethodConstant[] convMethods) {
        super(expr);
        assert (types != null && Arrays.stream(types).allMatch(Objects::nonNull));
        assert (convMethods != null && convMethods.length <= types.length);
        this.types = types;
        this.convMethods = convMethods;
    }

    public ConvertExprAST(ExprAST expr, TypeConstant type, MethodConstant convMethod) {
        super(expr);
        assert (type != null && convMethod != null);
        this.types = new TypeConstant[]{type};
        this.convMethods = new MethodConstant[]{convMethod};
    }

    public Constant[] getConvMethods() {
        return this.convMethods;
    }

    @Override
    public boolean isConditional() {
        return this.getExpr().isConditional();
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.ConvertExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.types[i];
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.types = ConvertExprAST.readTypeArray(in, res);
        this.convMethods = ConvertExprAST.readSparseConstArray(in, res, this.types.length);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        ConvertExprAST.prepareConstArray(this.types, res);
        ConvertExprAST.prepareConstArray(this.convMethods, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        ConvertExprAST.writeConstArray(this.types, out, res);
        ConvertExprAST.writeSparseConstArray(this.convMethods, out, res);
    }

    @Override
    public String toString() {
        if (this.convMethods.length == 1) {
            MethodConstant convMethod = (MethodConstant)this.convMethods[0];
            return this.getExpr().toString() + "." + convMethod.getName() + "()";
        }
        StringBuilder buff = new StringBuilder("(");
        String expr = this.getExpr().toString();
        boolean cond = this.isConditional();
        int c = this.convMethods.length;
        for (int i = 0; i < c; ++i) {
            MethodConstant convMethod = (MethodConstant)this.convMethods[i];
            if (i > (cond ? 1 : 0)) {
                buff.append(", ");
            }
            if (convMethod == null) {
                if (cond && i == 0) {
                    buff.append("conditional ");
                    continue;
                }
                buff.append(expr).append("[").append(i).append("]");
                continue;
            }
            buff.append(expr).append("[").append(i).append("].").append(convMethod.getName()).append('<').append(this.types[i].getValueString()).append(">()");
        }
        return buff.append(')').toString();
    }
}

