/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class DivRemExprAST
extends BiExprAST {
    private TypeConstant[] types;

    DivRemExprAST() {
    }

    public DivRemExprAST(TypeConstant[] types, ExprAST expr1, ExprAST expr2) {
        super(expr1, BiExprAST.Operator.DivRem, expr2);
        assert (types != null && types.length == 2);
        this.types = types;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.DivRemExpr;
    }

    @Override
    public int getCount() {
        return 2;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.types[i];
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.types = DivRemExprAST.readTypeArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        DivRemExprAST.prepareConstArray(this.types, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        DivRemExprAST.writeConstArray(this.types, out, res);
    }
}

