/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.util.Handy;

public class DoWhileStmtAST
extends BinaryAST {
    private ExprAST[] specialRegs;
    private BinaryAST body;
    private ExprAST cond;

    DoWhileStmtAST() {
    }

    public DoWhileStmtAST(RegAllocAST[] specialRegs, BinaryAST body, ExprAST cond) {
        this.specialRegs = specialRegs == null ? NO_ALLOCS : specialRegs;
        this.body = body;
        this.cond = cond;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.DoWhileStmt;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        res.enter();
        this.specialRegs = DoWhileStmtAST.readExprArray(in, res);
        this.body = DoWhileStmtAST.readAST(in, res);
        this.cond = DoWhileStmtAST.readExprAST(in, res);
        res.exit();
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        res.enter();
        DoWhileStmtAST.prepareASTArray(this.specialRegs, res);
        DoWhileStmtAST.prepareAST(this.body, res);
        DoWhileStmtAST.prepareAST(this.cond, res);
        res.exit();
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        DoWhileStmtAST.writeExprArray(this.specialRegs, out, res);
        DoWhileStmtAST.writeAST(this.body, out, res);
        DoWhileStmtAST.writeExprAST(this.cond, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("do {\n");
        if (this.body != null) {
            buf.append(Handy.indentLines(this.body.toString(), "  "));
        }
        buf.append("\n} while (").append(this.cond).append(");");
        return buf.toString();
    }
}

