/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.util.Handy;

public class ForEachStmtAST
extends BinaryAST {
    private final BinaryAST.NodeType nodeType;
    private ExprAST[] specialRegs;
    private ExprAST lval;
    private ExprAST rval;
    private BinaryAST body;

    ForEachStmtAST(BinaryAST.NodeType nodeType) {
        assert (ForEachStmtAST.nodeTypeOk(nodeType));
        this.nodeType = nodeType;
    }

    public ForEachStmtAST(BinaryAST.NodeType nodeType, RegAllocAST[] specialRegs, ExprAST lval, ExprAST rval, BinaryAST body) {
        assert (ForEachStmtAST.nodeTypeOk(nodeType) && lval != null && rval != null);
        this.nodeType = nodeType;
        this.specialRegs = specialRegs == null ? NO_ALLOCS : specialRegs;
        this.lval = lval;
        this.rval = rval;
        this.body = body;
    }

    private static boolean nodeTypeOk(BinaryAST.NodeType nodeType) {
        return switch (nodeType) {
            default -> false;
            case BinaryAST.NodeType.ForIteratorStmt, BinaryAST.NodeType.ForRangeStmt, BinaryAST.NodeType.ForListStmt, BinaryAST.NodeType.ForMapStmt, BinaryAST.NodeType.ForIterableStmt -> true;
        };
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.nodeType;
    }

    public ExprAST getLValue() {
        return this.lval;
    }

    public ExprAST getRValue() {
        return this.rval;
    }

    public BinaryAST getBody() {
        return this.body;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        res.enter();
        this.specialRegs = ForEachStmtAST.readExprArray(in, res);
        this.lval = ForEachStmtAST.readExprAST(in, res);
        this.rval = ForEachStmtAST.readExprAST(in, res);
        res.enter();
        this.body = ForEachStmtAST.readAST(in, res);
        res.exit();
        res.exit();
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        res.enter();
        ForEachStmtAST.prepareASTArray(this.specialRegs, res);
        ForEachStmtAST.prepareAST(this.lval, res);
        ForEachStmtAST.prepareAST(this.rval, res);
        res.enter();
        ForEachStmtAST.prepareAST(this.body, res);
        res.exit();
        res.exit();
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        ForEachStmtAST.writeExprArray(this.specialRegs, out, res);
        ForEachStmtAST.writeExprAST(this.lval, out, res);
        ForEachStmtAST.writeExprAST(this.rval, out, res);
        ForEachStmtAST.writeAST(this.body, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("for (");
        buf.append(this.lval);
        buf.append(": ");
        buf.append(this.rval);
        buf.append(") ");
        if (this.body == null) {
            buf.append("{}");
        } else {
            buf.append("{\n").append(Handy.indentLines(this.body.toString(), "  ")).append("\n}");
        }
        return buf.toString();
    }
}

