/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.util.Handy;

public class ForStmtAST
extends BinaryAST {
    private ExprAST[] specialRegs;
    private BinaryAST init;
    private ExprAST cond;
    private BinaryAST update;
    private BinaryAST body;

    ForStmtAST() {
    }

    public ForStmtAST(RegAllocAST[] specialRegs, BinaryAST init, ExprAST cond, BinaryAST update, BinaryAST body) {
        this.specialRegs = specialRegs == null ? NO_ALLOCS : specialRegs;
        this.init = init;
        this.cond = cond;
        this.update = update;
        this.body = body;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.ForStmt;
    }

    public BinaryAST getInit() {
        return this.init;
    }

    public ExprAST getCond() {
        return this.cond;
    }

    public BinaryAST getUpdate() {
        return this.update;
    }

    public BinaryAST getBody() {
        return this.body;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        res.enter();
        this.specialRegs = ForStmtAST.readExprArray(in, res);
        this.init = ForStmtAST.readAST(in, res);
        this.cond = ForStmtAST.readExprAST(in, res);
        this.update = ForStmtAST.readAST(in, res);
        res.enter();
        this.body = ForStmtAST.readAST(in, res);
        res.exit();
        res.exit();
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        res.enter();
        ForStmtAST.prepareASTArray(this.specialRegs, res);
        ForStmtAST.prepareAST(this.init, res);
        ForStmtAST.prepareAST(this.cond, res);
        ForStmtAST.prepareAST(this.update, res);
        res.enter();
        ForStmtAST.prepareAST(this.body, res);
        res.exit();
        res.exit();
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        ForStmtAST.writeExprArray(this.specialRegs, out, res);
        ForStmtAST.writeAST(this.init, out, res);
        ForStmtAST.writeExprAST(this.cond, out, res);
        ForStmtAST.writeAST(this.update, out, res);
        ForStmtAST.writeAST(this.body, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("for (");
        if (this.init != null) {
            buf.append(this.init);
        }
        buf.append("; ");
        if (this.cond != null) {
            buf.append(this.cond);
        }
        buf.append("; ");
        if (this.update != null) {
            buf.append(this.update);
        }
        buf.append(") ");
        if (this.body == null) {
            buf.append("{}");
        } else {
            buf.append("{\n").append(Handy.indentLines(this.body.toString(), "  ")).append("\n}");
        }
        return buf.toString();
    }
}

