/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.util.Handy;

public class IfStmtAST
extends BinaryAST {
    private ExprAST cond;
    private BinaryAST thenStmt;
    private boolean hasElse;
    private BinaryAST elseStmt;

    IfStmtAST(BinaryAST.NodeType nodeType) {
        this.hasElse = switch (nodeType) {
            case BinaryAST.NodeType.IfThenStmt -> false;
            case BinaryAST.NodeType.IfElseStmt -> true;
            default -> throw new IllegalArgumentException("nodeType=" + String.valueOf((Object)nodeType));
        };
    }

    public IfStmtAST(ExprAST cond, BinaryAST thenStmt, BinaryAST elseStmt) {
        assert (cond != null);
        this.cond = cond;
        this.thenStmt = IfStmtAST.unwrapStatement(thenStmt);
        this.elseStmt = IfStmtAST.unwrapStatement(elseStmt);
        this.hasElse = elseStmt != null;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.hasElse ? BinaryAST.NodeType.IfElseStmt : BinaryAST.NodeType.IfThenStmt;
    }

    public ExprAST getCond() {
        return this.cond;
    }

    public BinaryAST getThen() {
        return this.thenStmt;
    }

    public BinaryAST getElse() {
        return this.elseStmt;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        res.enter();
        this.cond = IfStmtAST.readExprAST(in, res);
        res.enter();
        this.thenStmt = IfStmtAST.readAST(in, res);
        res.exit();
        if (this.hasElse) {
            res.enter();
            this.elseStmt = IfStmtAST.readAST(in, res);
            res.exit();
        }
        res.exit();
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        res.enter();
        IfStmtAST.prepareAST(this.cond, res);
        res.enter();
        IfStmtAST.prepareAST(this.thenStmt, res);
        res.exit();
        if (this.hasElse) {
            res.enter();
            IfStmtAST.prepareAST(this.elseStmt, res);
            res.exit();
        }
        res.exit();
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        IfStmtAST.writeExprAST(this.cond, out, res);
        IfStmtAST.writeAST(this.thenStmt, out, res);
        if (this.hasElse) {
            IfStmtAST.writeAST(this.elseStmt, out, res);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("if (").append(this.cond).append(") {\n").append(Handy.indentLines(this.thenStmt.toString(), "  ")).append("\n}");
        if (this.hasElse) {
            buf.append(" else {\n").append(Handy.indentLines(this.elseStmt.toString(), "  ")).append("\n}");
        }
        return buf.toString();
    }
}

